/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.player.vampire;

import de.teamlapen.lib.HelperLib;
import de.teamlapen.lib.VampLib;
import de.teamlapen.lib.lib.storage.ISyncableSaveData;
import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.lib.util.ISoundReference;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.advancements.critereon.VampireActionCriterionTrigger;
import de.teamlapen.vampirism.api.EnumStrength;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.VampirismAttachments;
import de.teamlapen.vampirism.api.entity.IBiteableEntity;
import de.teamlapen.vampirism.api.entity.IExtendedCreatureVampirism;
import de.teamlapen.vampirism.api.entity.factions.IFaction;
import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import de.teamlapen.vampirism.api.entity.player.actions.IActionHandler;
import de.teamlapen.vampirism.api.entity.player.actions.ILastingAction;
import de.teamlapen.vampirism.api.entity.player.refinement.IRefinement;
import de.teamlapen.vampirism.api.entity.player.skills.ISkillHandler;
import de.teamlapen.vampirism.api.entity.player.vampire.IBloodStats;
import de.teamlapen.vampirism.api.entity.player.vampire.IDrinkBloodContext;
import de.teamlapen.vampirism.api.entity.player.vampire.IVampirePlayer;
import de.teamlapen.vampirism.api.entity.player.vampire.IVampireVision;
import de.teamlapen.vampirism.api.entity.vampire.IVampire;
import de.teamlapen.vampirism.api.util.VResourceLocation;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.core.ModAdvancements;
import de.teamlapen.vampirism.core.ModAttachments;
import de.teamlapen.vampirism.core.ModAttributes;
import de.teamlapen.vampirism.core.ModBlocks;
import de.teamlapen.vampirism.core.ModEffects;
import de.teamlapen.vampirism.core.ModFluids;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.core.ModParticles;
import de.teamlapen.vampirism.core.ModRefinements;
import de.teamlapen.vampirism.core.ModSounds;
import de.teamlapen.vampirism.core.ModStats;
import de.teamlapen.vampirism.effects.SanguinareEffect;
import de.teamlapen.vampirism.effects.VampireNightVisionEffectInstance;
import de.teamlapen.vampirism.entity.ExtendedCreature;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.entity.minion.VampireMinionEntity;
import de.teamlapen.vampirism.entity.player.FactionBasePlayer;
import de.teamlapen.vampirism.entity.player.IVampirismPlayer;
import de.teamlapen.vampirism.entity.player.LevelAttributeModifier;
import de.teamlapen.vampirism.entity.player.actions.ActionHandler;
import de.teamlapen.vampirism.entity.player.skills.SkillHandler;
import de.teamlapen.vampirism.entity.player.vampire.BloodStats;
import de.teamlapen.vampirism.entity.player.vampire.VampirePlayerSpecialAttributes;
import de.teamlapen.vampirism.entity.player.vampire.actions.VampireActions;
import de.teamlapen.vampirism.entity.vampire.DrinkBloodContext;
import de.teamlapen.vampirism.fluids.BloodHelper;
import de.teamlapen.vampirism.items.HunterArmorItem;
import de.teamlapen.vampirism.mixin.accessor.AttributeInstanceAccessor;
import de.teamlapen.vampirism.modcompat.PlayerReviveHelper;
import de.teamlapen.vampirism.network.ServerboundSimpleInputEvent;
import de.teamlapen.vampirism.particle.FlyingBloodEntityParticleOptions;
import de.teamlapen.vampirism.util.ArmorModifier;
import de.teamlapen.vampirism.util.DamageHandler;
import de.teamlapen.vampirism.util.Helper;
import de.teamlapen.vampirism.util.Permissions;
import de.teamlapen.vampirism.util.ScoreboardUtil;
import de.teamlapen.vampirism.util.VampirismEventFactory;
import de.teamlapen.vampirism.world.MinionWorldData;
import de.teamlapen.vampirism.world.ModDamageSources;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.attachment.IAttachmentHolder;
import net.neoforged.neoforge.attachment.IAttachmentSerializer;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VampirePlayer
extends FactionBasePlayer<IVampirePlayer>
implements IVampirePlayer {
    private static final String NBT_KEY = "vampire_player";
    public static final ResourceLocation NATURAL_ARMOR_UUID = VResourceLocation.mod("natural_armor");
    private static final ResourceLocation LEVEL_DAMAGE_UUID = VResourceLocation.mod("level_damage");
    private static final Logger LOGGER = LogManager.getLogger(VampirePlayer.class);
    private static final int FEED_TIMER = 20;
    private static final String KEY_EYE = "eye_type";
    private static final String KEY_FANGS = "fang_type";
    private static final String KEY_GLOWING_EYES = "glowing_eyes";
    private static final String KEY_SPAWN_BITE_PARTICLE = "bite_particle";
    private static final String KEY_VISION = "vision";
    private static final String KEY_FEED_VICTIM_ID = "feed_victim";
    private static final String KEY_DBNO_TIMER = "dbno";
    private static final String KEY_DBNO_MSG = "dbno_msg";
    private static final String KEY_WAS_DBNO = "wasDBNO";
    @NotNull
    private final BloodStats bloodStats;
    @NotNull
    private final ActionHandler<IVampirePlayer> actionHandler;
    @NotNull
    private final SkillHandler<IVampirePlayer> skillHandler;
    private boolean sundamage_cache = false;
    @NotNull
    private EnumStrength garlic_cache = EnumStrength.NONE;
    private int ticksInSun = 0;
    private int remainingBarkTicks = 0;
    private boolean wasDead = false;
    @NotNull
    private final VisionStatus vision = new VisionStatus();
    private int feed_victim = -1;
    @Nullable
    private ISoundReference feedingSoundReference;
    @Nullable
    private IVampirePlayer.BITE_TYPE feed_victim_bite_type;
    private int feedBiteTickCounter = 0;
    private boolean forceNaturalArmorUpdate;
    private int dbnoTimer = -1;
    private boolean wasDBNO = false;
    @Nullable
    private Component dbnoMessage;

    @NotNull
    public static VampirePlayer get(@NotNull Player player) {
        return (VampirePlayer)player.getData(ModAttachments.VAMPIRE_PLAYER);
    }

    @Deprecated
    @NotNull
    public static Optional<VampirePlayer> getOpt(@NotNull Player player) {
        return Optional.of((VampirePlayer)player.getData(ModAttachments.VAMPIRE_PLAYER));
    }

    public static double getNaturalArmorValue(int lvl) {
        return lvl > 0 ? (double)((Integer)VampirismConfig.BALANCE.vpNaturalArmorBaseValue.get()).intValue() + (double)lvl / 14.0 * (double)((Integer)VampirismConfig.BALANCE.vpNaturalArmorIncrease.get()).intValue() : 0.0;
    }

    public static double getNaturalArmorToughnessValue(int lvl) {
        return (double)lvl / 14.0 * (double)((Integer)VampirismConfig.BALANCE.vpNaturalArmorToughnessIncrease.get()).intValue();
    }

    public VampirePlayer(Player player) {
        super(player);
        this.bloodStats = new BloodStats(player);
        this.actionHandler = new ActionHandler<VampirePlayer>(this);
        this.skillHandler = new SkillHandler<IVampirePlayer>(this, VReference.VAMPIRE_FACTION);
    }

    @Override
    public void activateVision(@Nullable IVampireVision vision) {
        if (vision != null && !this.isRemote()) {
            VampirismAPI.vampireVisionRegistry().getVisionId(vision);
        }
        this.vision.activate(vision);
    }

    @Override
    public void addExhaustion(float exhaustion) {
        if (!this.player.getAbilities().invulnerable && this.getLevel() > 0 && !this.isRemote()) {
            this.bloodStats.addExhaustion(exhaustion);
        }
    }

    public void biteBlock(@NotNull BlockPos pos) {
        if (this.player.isSpectator()) {
            LOGGER.warn("Player can't bite in spectator mode");
            return;
        }
        double dist = this.player.getAttribute(Attributes.ENTITY_INTERACTION_RANGE).getValue() + 1.0;
        if (this.player.distanceToSqr((double)pos.getX(), (double)pos.getY(), (double)pos.getZ()) > dist * dist) {
            LOGGER.warn("Block sent by client is not in reach" + String.valueOf(pos));
        } else {
            this.biteBlock(pos, this.player.level().getBlockState(pos), this.player.level().getBlockEntity(pos));
        }
    }

    public void biteEntity(int entityId) {
        block9: {
            block10: {
                if (this.getLevel() == 0) {
                    LOGGER.warn("Player can't bite. Isn't a vampire");
                    return;
                }
                Entity e = this.player.getCommandSenderWorld().getEntity(entityId);
                if (this.player.isSpectator()) {
                    LOGGER.warn("Player can't bite in spectator mode");
                    return;
                }
                if (this.getActionHandler().isActionActive((ILastingAction)VampireActions.BAT.get())) {
                    LOGGER.warn("Cannot bite in bat mode");
                    return;
                }
                if (!(e instanceof LivingEntity)) break block9;
                if (!((double)e.distanceTo((Entity)this.player) <= this.player.getAttribute(Attributes.ENTITY_INTERACTION_RANGE).getValue() + 1.0)) break block10;
                this.feed_victim_bite_type = this.determineBiteType((LivingEntity)e);
                this.player.awardStat((ResourceLocation)ModStats.AMOUNT_BITTEN.get());
                switch (this.feed_victim_bite_type) {
                    case HUNTER_CREATURE: {
                        this.player.addEffect(new MobEffectInstance(ModEffects.POISON, 60));
                        if (this.player instanceof ServerPlayer) {
                            ((VampireActionCriterionTrigger)((Object)ModAdvancements.TRIGGER_VAMPIRE_ACTION.get())).trigger((ServerPlayer)this.player, VampireActionCriterionTrigger.Action.POISONOUS_BITE);
                            break;
                        }
                        break block9;
                    }
                    case NONE: {
                        break;
                    }
                    default: {
                        if (this.feed_victim == -1) {
                            this.feedBiteTickCounter = 0;
                        }
                        this.feed_victim = e.getId();
                        ((LivingEntity)e).addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 20, 7, false, false));
                        this.player.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 25, 4, false, false));
                        CompoundTag nbt = new CompoundTag();
                        nbt.putInt(KEY_FEED_VICTIM_ID, this.feed_victim);
                        this.sync(nbt, true);
                        break;
                    }
                }
                break block9;
            }
            LOGGER.warn("Entity sent by client is not in reach " + entityId);
        }
    }

    @Override
    public float calculateFireDamage(float amount) {
        float protectionMod = 1.0f;
        MobEffectInstance protection = this.player.getEffect(ModEffects.FIRE_PROTECTION);
        if (protection != null) {
            int amplifier = protection.getAmplifier();
            protectionMod = amplifier >= 5 ? 0.0f : 1.0f / (2.0f + (float)amplifier);
        }
        return amount * protectionMod * (float)LevelAttributeModifier.calculateModifierValue(this.getLevel(), this.getMaxLevel(), (Double)VampirismConfig.BALANCE.vpFireVulnerabilityMod.get(), 0.5);
    }

    @Override
    public boolean canBeBitten(IVampire biter) {
        return !this.player.isSpectator() && !this.player.isCreative();
    }

    @Override
    public boolean canLeaveFaction() {
        return true;
    }

    @Override
    @NotNull
    public IVampirePlayer.BITE_TYPE determineBiteType(LivingEntity entity) {
        if (this.player instanceof ServerPlayer && Permissions.FEED.isDisallowed((ServerPlayer)this.player)) {
            return IVampirePlayer.BITE_TYPE.NONE;
        }
        if (entity instanceof IBiteableEntity && ((IBiteableEntity)entity).canBeBitten(this)) {
            return IVampirePlayer.BITE_TYPE.SUCK_BLOOD;
        }
        if (entity instanceof PathfinderMob && entity.isAlive()) {
            Optional<ExtendedCreature> opt = ExtendedCreature.getSafe((Entity)entity);
            if (opt.map(creature -> creature.canBeBitten(this)).orElse(false).booleanValue()) {
                if (opt.map(IExtendedCreatureVampirism::hasPoisonousBlood).orElse(false).booleanValue()) {
                    return IVampirePlayer.BITE_TYPE.HUNTER_CREATURE;
                }
                return IVampirePlayer.BITE_TYPE.SUCK_BLOOD_CREATURE;
            }
        } else if (entity instanceof Player) {
            if (((Player)entity).getAbilities().instabuild || !Permissions.isPvpEnabled(this.player)) {
                return IVampirePlayer.BITE_TYPE.NONE;
            }
            if (!UtilLib.canReallySee(entity, (LivingEntity)this.player, false) && VampirePlayer.get((Player)entity).canBeBitten(this) && (!(this.player instanceof ServerPlayer) || Permissions.FEED_PLAYER.isAllowed((ServerPlayer)this.player))) {
                if (!(entity.getItemBySlot(EquipmentSlot.CHEST).getItem() instanceof HunterArmorItem)) {
                    return IVampirePlayer.BITE_TYPE.SUCK_BLOOD_PLAYER;
                }
            } else {
                return IVampirePlayer.BITE_TYPE.NONE;
            }
        }
        return IVampirePlayer.BITE_TYPE.NONE;
    }

    @Override
    public boolean doesResistGarlic(EnumStrength strength) {
        return false;
    }

    @Override
    public void drinkBlood(int amt, float saturationMod, boolean useRemaining, IDrinkBloodContext drinkContext) {
         @NotNull BloodDrinkEvent.PlayerDrinkBloodEvent event = VampirismEventFactory.fireVampirePlayerDrinkBloodEvent(this, amt, saturationMod, useRemaining, drinkContext);
        int remainingBlood = this.bloodStats.addBlood(event.getAmount(), event.getSaturation());
        if (event.useRemaining() && remainingBlood > 0) {
            this.handleSpareBlood(remainingBlood);
        }
        this.player.awardStat((ResourceLocation)ModStats.BLOOD_DRUNK.get(), amt * 100);
    }

    public void endFeeding(boolean sync) {
        if (this.feed_victim != -1 || this.feed_victim_bite_type != null) {
            this.feed_victim = -1;
            this.feed_victim_bite_type = null;
            if (this.player.hasEffect(MobEffects.MOVEMENT_SLOWDOWN)) {
                this.player.removeEffect(MobEffects.MOVEMENT_SLOWDOWN);
            }
        }
        if (sync) {
            CompoundTag nbt = new CompoundTag();
            nbt.putInt(KEY_FEED_VICTIM_ID, this.feed_victim);
            this.sync(nbt, true);
        }
    }

    @Override
    @NotNull
    public IActionHandler<IVampirePlayer> getActionHandler() {
        return this.actionHandler;
    }

    @Override
    @Nullable
    public IVampireVision getActiveVision() {
        return this.vision.vision;
    }

    @Override
    public int getBloodLevel() {
        return this.bloodStats.getBloodLevel();
    }

    @Override
    public float getBloodLevelRelative() {
        if (this.getLevel() == 0) {
            return (float)this.player.getFoodData().getFoodLevel() / 20.0f;
        }
        return (float)this.bloodStats.getBloodLevel() / (float)this.bloodStats.getMaxBlood();
    }

    @Override
    public float getBloodSaturation() {
        return ((Double)VampirismConfig.BALANCE.vpPlayerBloodSaturation.get()).floatValue();
    }

    @Override
    @NotNull
    public IBloodStats getBloodStats() {
        return this.bloodStats;
    }

    public int getRemainingBarkTicks() {
        return this.remainingBarkTicks;
    }

    public void increaseRemainingBarkTicks(int additionalTicks) {
        this.remainingBarkTicks = additionalTicks;
    }

    @Override
    @NotNull
    public ResourceLocation getAttachedKey() {
        return VampirismAttachments.Keys.VAMPIRE_PLAYER;
    }

    public int getDbnoDuration() {
        return (int)this.player.getAttributeValue(ModAttributes.DBNO_DURATION);
    }

    public int getDbnoTimer() {
        return this.dbnoTimer;
    }

    @Override
    @Nullable
    public IFaction<?> getDisguisedAs() {
        return this.isDisguised() ? this.getSpecialAttributes().disguisedAs : this.getFaction();
    }

    public int getEyeType() {
        return this.getSpecialAttributes().eyeType;
    }

    public int getFangType() {
        return this.getSpecialAttributes().fangType;
    }

    public float getFeedProgress() {
        return (float)this.feedBiteTickCounter / 20.0f;
    }

    public boolean getGlowingEyes() {
        return this.getSpecialAttributes().glowingEyes;
    }

    public void setGlowingEyes(boolean value) {
        if (value != this.getSpecialAttributes().glowingEyes) {
            this.getSpecialAttributes().glowingEyes = value;
            if (!this.isRemote()) {
                CompoundTag nbt = new CompoundTag();
                nbt.putBoolean(KEY_GLOWING_EYES, value);
                this.sync(nbt, true);
            }
        }
    }

    @Override
    public int getLevel() {
        return ((IVampirismPlayer)this.player).getVampAtts().vampireLevel;
    }

    @Override
    public int getMaxLevel() {
        return 14;
    }

    @Override
    public Predicate<LivingEntity> getNonFriendlySelector(boolean otherFactionPlayers, boolean ignoreDisguise) {
        if (otherFactionPlayers) {
            return entity -> true;
        }
        return VampirismAPI.factionRegistry().getPredicate(this.getFaction(), ignoreDisguise);
    }

    @Override
    @NotNull
    public ISkillHandler<IVampirePlayer> getSkillHandler() {
        return this.skillHandler;
    }

    @NotNull
    public VampirePlayerSpecialAttributes getSpecialAttributes() {
        return ((IVampirismPlayer)this.player).getVampAtts().getVampSpecial();
    }

    @Override
    public int getTicksInSun() {
        return this.ticksInSun;
    }

    @Override
    public boolean isAdvancedBiter() {
        return this.getSpecialAttributes().advanced_biter;
    }

    @Override
    public boolean isDBNO() {
        return this.dbnoTimer >= 0;
    }

    @Override
    public boolean isDisguised() {
        return this.getSpecialAttributes().disguised;
    }

    @Override
    @NotNull
    public EnumStrength isGettingGarlicDamage(LevelAccessor iWorld, boolean forcerefresh) {
        if (forcerefresh) {
            this.garlic_cache = Helper.getGarlicStrength((Entity)this.player, iWorld);
        }
        return this.garlic_cache;
    }

    @Override
    public boolean isGettingSundamage(LevelAccessor iWorld, boolean forcerefresh) {
        if (forcerefresh) {
            this.sundamage_cache = Helper.gettingSundamge((LivingEntity)this.player, iWorld, this.player.level().getProfiler()) && ModItems.UMBRELLA.get() != this.player.getMainHandItem().getItem();
        }
        return this.sundamage_cache;
    }

    @Override
    public boolean isIgnoringSundamage() {
        return false;
    }

    @Override
    public void deserializeNBT(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider, @NotNull CompoundTag nbt) {
        super.deserializeNBT(provider, nbt);
        this.bloodStats.deserializeNBT(provider, nbt.getCompound(this.bloodStats.nbtKey()));
        this.actionHandler.deserializeNBT(provider, nbt.getCompound(this.actionHandler.nbtKey()));
        this.skillHandler.deserializeNBT(provider, nbt.getCompound(this.skillHandler.nbtKey()));
        this.vision.deserializeNBT(provider, nbt.getCompound(KEY_VISION));
        if (nbt.getBoolean(KEY_WAS_DBNO)) {
            this.wasDBNO = true;
        }
        VampirePlayerSpecialAttributes a = this.getSpecialAttributes();
        a.eyeType = nbt.getInt(KEY_EYE);
        a.fangType = nbt.getInt(KEY_FANGS);
        a.glowingEyes = nbt.getBoolean(KEY_GLOWING_EYES);
    }

    @Override
    public boolean canBeInfected(IVampire vampire) {
        return !this.player.hasEffect(ModEffects.SANGUINARE) && Helper.canTurnPlayer(vampire, this.player) && Helper.canBecomeVampire(this.player);
    }

    @Override
    public boolean tryInfect(IVampire vampire) {
        if (this.canBeInfected(vampire)) {
            SanguinareEffect.addRandom((LivingEntity)this.player, true);
            return true;
        }
        return false;
    }

    @Override
    public int onBite(IVampire biter) {
        float perc;
        float f = perc = biter instanceof IVampirePlayer ? 0.2f : 0.08f;
        if (this.getLevel() == 0) {
            int amt = this.player.getFoodData().getFoodLevel();
            int sucked = (int)Math.ceil((float)amt * perc);
            this.player.getFoodData().setFoodLevel(amt - sucked);
            this.player.causeFoodExhaustion(1000.0f);
            return sucked;
        }
        int amt = this.getBloodStats().getBloodLevel();
        int sucked = (int)Math.ceil((float)amt * perc);
        this.bloodStats.removeBlood(sucked, true);
        this.syncProperty(this.bloodStats, true);
        return sucked;
    }

    public int removeBlood(float percentage) {
        if (this.getLevel() == 0) {
            int amt = this.player.getFoodData().getFoodLevel();
            int sucked = (int)Math.ceil((float)amt * percentage);
            this.player.getFoodData().setFoodLevel(amt - sucked);
            return sucked;
        }
        int amt = this.getBloodStats().getBloodLevel();
        int sucked = (int)Math.ceil((float)amt * percentage);
        this.bloodStats.removeBlood(sucked, true);
        this.syncProperty(this.bloodStats, true);
        return sucked;
    }

    @Override
    public void onChangedDimension(ResourceKey<Level> from, ResourceKey<Level> to) {
    }

    @Override
    public boolean onDeadlyHit(@NotNull DamageSource source) {
        if (this.getLevel() > 0 && !this.player.hasEffect(ModEffects.NEONATAL) && !Helper.canKillVampires(source)) {
            int timePreviouslySpentInPlayerRevive = PlayerReviveHelper.getPreviousDownTime(this.player);
            int dbnoTime = Math.max(1, this.getDbnoDuration() - timePreviouslySpentInPlayerRevive);
            this.setDBNOTimer(dbnoTime);
            this.player.setHealth(0.5f);
            this.player.setForcedPose(Pose.SLEEPING);
            this.resetNearbyTargetingMobs();
            boolean flag = this.player.level().getGameRules().getBoolean(GameRules.RULE_SHOWDEATHMESSAGES);
            if (flag) {
                this.dbnoMessage = this.player.getCombatTracker().getDeathMessage();
            }
            CompoundTag nbt = new CompoundTag();
            nbt.putInt(KEY_DBNO_TIMER, this.dbnoTimer);
            if (this.dbnoMessage != null) {
                nbt.putString(KEY_DBNO_MSG, Component.Serializer.toJson((Component)this.dbnoMessage, (HolderLookup.Provider)this.asEntity().registryAccess()));
            }
            HelperLib.sync(this, nbt, (Entity)this.player, true);
            return true;
        }
        return false;
    }

    @Override
    public void onDeath(@NotNull DamageSource src) {
        super.onDeath(src);
        if (this.actionHandler.isActionActive((ILastingAction)VampireActions.BAT.get()) && src.getDirectEntity() instanceof Projectile && this.player instanceof ServerPlayer) {
            ((VampireActionCriterionTrigger)((Object)ModAdvancements.TRIGGER_VAMPIRE_ACTION.get())).trigger((ServerPlayer)this.player, VampireActionCriterionTrigger.Action.SNIPED_IN_BAT);
        }
        this.actionHandler.deactivateAllActions();
        this.wasDead = true;
        this.setDBNOTimer(-1);
        this.dbnoMessage = null;
    }

    @Override
    public boolean onEntityAttacked(@NotNull DamageSource src, float amt) {
        if (this.getLevel() > 0) {
            if (this.isDBNO() && !Helper.canKillVampires(src)) {
                if (src.getEntity() != null && src.getEntity() instanceof Mob && ((Mob)src.getEntity()).getTarget() == this.player) {
                    ((Mob)src.getEntity()).setTarget(null);
                }
                return true;
            }
            if (src.is(DamageTypes.ON_FIRE)) {
                DamageHandler.hurtModded((Entity)this.player, ModDamageSources::vampireOnFire, this.calculateFireDamage(amt));
                return true;
            }
            if (src.is(DamageTypes.IN_FIRE) || src.is(DamageTypes.LAVA)) {
                DamageHandler.hurtModded((Entity)this.player, ModDamageSources::vampireInFire, this.calculateFireDamage(amt));
                return true;
            }
        }
        this.endFeeding(true);
        if (this.getSpecialAttributes().half_invulnerable) {
            double d = amt;
            double d2 = this.getRepresentingEntity().getMaxHealth();
            double d3 = this.skillHandler.isRefinementEquipped((IRefinement)ModRefinements.HALF_INVULNERABLE.get()) ? (Double)VampirismConfig.BALANCE.vrHalfInvulnerableThresholdMod.get() : 1.0;
            if (d >= d2 * d3 * (Double)VampirismConfig.BALANCE.vaHalfInvulnerableThreshold.get() && amt < 999.0f) {
                if (this.useBlood((Integer)VampirismConfig.BALANCE.vaHalfInvulnerableBloodCost.get(), false)) {
                    return true;
                }
                this.actionHandler.deactivateAction((ILastingAction)VampireActions.HALF_INVULNERABLE.get());
            }
        }
        return false;
    }

    @Override
    public void onEntityKilled(LivingEntity victim, DamageSource src) {
        if (this.getSkillHandler().isRefinementEquipped((IRefinement)ModRefinements.RAGE_FURY.get())) {
            int bonus = (Integer)VampirismConfig.BALANCE.vrRageFuryDurationBonus.get() * 20;
            if (victim instanceof Player) {
                bonus *= 2;
            }
            this.getActionHandler().extendActionTimer((ILastingAction)VampireActions.VAMPIRE_RAGE.get(), bonus);
        }
    }

    @Override
    public void onJoinWorld() {
        if (this.getLevel() > 0) {
            this.actionHandler.onActionsReactivated();
            this.ticksInSun = 0;
            if (this.wasDead) {
                this.player.addEffect(new MobEffectInstance(ModEffects.SUNSCREEN, 400, 4, false, false));
                this.player.addEffect(new MobEffectInstance(ModEffects.ARMOR_REGENERATION, (Integer)VampirismConfig.BALANCE.vpNaturalArmorRegenDuration.get() * 20, 0, false, false));
                this.requestNaturalArmorUpdate();
                this.player.setHealth(this.player.getMaxHealth());
                this.bloodStats.setBloodLevel(this.bloodStats.getMaxBlood());
            }
        }
    }

    @Override
    public void onLevelChanged(int newLevel, int oldLevel) {
        super.onLevelChanged(newLevel, oldLevel);
        if (newLevel > 0) {
            this.applyEntityAttributes();
        } else {
            this.removeEntityAttributes();
        }
        if (!this.isRemote()) {
            ScoreboardUtil.updateScoreboard(this.player, ScoreboardUtil.VAMPIRE_LEVEL_CRITERIA, newLevel);
            this.applyLevelModifiersA(newLevel);
            this.applyLevelModifiersB(newLevel, false);
            if (this.player.getHealth() > this.player.getMaxHealth()) {
                this.player.setHealth(this.player.getMaxHealth());
            }
            this.updateNaturalArmor(newLevel);
            if (newLevel > 13) {
                this.bloodStats.setMaxBlood(40);
            } else if (newLevel > 9) {
                this.bloodStats.setMaxBlood(34);
            } else if (newLevel > 6) {
                this.bloodStats.setMaxBlood(30);
            } else if (newLevel > 3) {
                this.bloodStats.setMaxBlood(26);
            } else if (newLevel > 0) {
                this.bloodStats.setMaxBlood(20);
            } else {
                this.vision.deactivate();
                this.sync(true);
            }
        } else if (oldLevel == 0) {
            if (this.player.hasEffect(MobEffects.NIGHT_VISION)) {
                this.player.removeEffect(MobEffects.NIGHT_VISION);
            }
        } else if (newLevel == 0 && this.player.getEffect(MobEffects.NIGHT_VISION) instanceof VampireNightVisionEffectInstance) {
            this.player.removeEffect(MobEffects.NIGHT_VISION);
        }
    }

    @Override
    public void onPlayerLoggedIn() {
        if (this.getLevel() > 0 && !this.player.level().isClientSide) {
            this.player.addEffect(new MobEffectInstance(ModEffects.SUNSCREEN, 200, 4, true, false));
        }
    }

    @Override
    public void onPlayerLoggedOut() {
        this.endFeeding(false);
        if (this.isDBNO()) {
            this.setDBNOTimer(-1);
            DamageHandler.kill((Entity)this.player, 10000);
        }
    }

    public void onSanguinareFinished() {
        if (Helper.canBecomeVampire(this.player) && !this.isRemote() && this.player.isAlive()) {
            FactionPlayerHandler handler = FactionPlayerHandler.get(this.player);
            handler.joinFaction((IPlayableFaction<?>)this.getFaction());
            this.player.addEffect(new MobEffectInstance(MobEffects.DAMAGE_RESISTANCE, 300));
            this.player.addEffect(new MobEffectInstance(MobEffects.SATURATION, 300));
        }
    }

    @Override
    public void onUpdate() {
        Level world = this.player.getCommandSenderWorld();
        world.getProfiler().push("vampirism_vampirePlayer");
        if (this.wasDBNO) {
            this.wasDBNO = false;
            DamageHandler.kill((Entity)this.player, 100000);
            return;
        }
        if (this.dbnoTimer >= 0) {
            if (this.dbnoTimer > 0) {
                this.setDBNOTimer(this.dbnoTimer - 1);
                if (this.dbnoTimer == 0) {
                    CompoundTag nbt = new CompoundTag();
                    nbt.putInt(KEY_DBNO_TIMER, 0);
                    HelperLib.sync(this, nbt, (Entity)this.player, false);
                }
            }
            this.player.setAirSupply(300);
            this.player.setDeltaMovement(0.0, Math.min(0.0, this.player.getDeltaMovement().y()), 0.0);
            this.player.removeAllEffects();
            return;
        }
        super.onUpdate();
        int level = this.getLevel();
        if (level > 0) {
            if (this.player.tickCount % 8 == 0) {
                this.isGettingSundamage((LevelAccessor)world, true);
            }
            if (this.player.tickCount % 40 == 0) {
                this.isGettingGarlicDamage((LevelAccessor)world, true);
            }
        } else {
            this.sundamage_cache = false;
            this.garlic_cache = EnumStrength.NONE;
        }
        this.vision.tick();
        if (!this.isRemote()) {
            if (level > 0) {
                boolean sync = false;
                boolean syncToAll = false;
                CompoundTag syncPacket = new CompoundTag();
                if (this.isGettingSundamage((LevelAccessor)world)) {
                    this.handleSunDamage(false);
                } else if (this.ticksInSun > 0) {
                    --this.ticksInSun;
                }
                if (this.isGettingGarlicDamage((LevelAccessor)world) != EnumStrength.NONE) {
                    DamageHandler.affectVampireGarlicAmbient(this, this.isGettingGarlicDamage((LevelAccessor)world), this.player.tickCount);
                }
                if (this.player.isAlive()) {
                    this.player.setAirSupply(300);
                    if (this.player.tickCount % 16 == 4 && !this.getSpecialAttributes().waterResistance && !this.player.getAbilities().instabuild && this.player.isInWater()) {
                        FluidState state1 = world.getFluidState(this.player.blockPosition());
                        FluidState state2 = world.getFluidState(this.player.blockPosition().above());
                        if (state1.is(FluidTags.WATER) && state1.getFlow((BlockGetter)world, this.player.blockPosition()).lengthSqr() > 0.0 || state2.is(FluidTags.WATER) && state2.getFlow((BlockGetter)world, this.player.blockPosition().above()).lengthSqr() > 0.0) {
                            this.player.addEffect(new MobEffectInstance(MobEffects.WEAKNESS, 80, (int)((float)this.getLevel() / (float)this.getMaxLevel() * 3.0f)));
                        }
                    }
                }
                if (this.player.tickCount % 9 == 3 && ((Boolean)VampirismConfig.BALANCE.vpFireResistanceReplace.get()).booleanValue() && this.player.hasEffect(MobEffects.FIRE_RESISTANCE)) {
                    MobEffectInstance fireResistance = this.player.getEffect(MobEffects.FIRE_RESISTANCE);
                    this.player.addEffect(new MobEffectInstance(ModEffects.FIRE_PROTECTION, fireResistance.getDuration(), fireResistance.getAmplifier()));
                    this.player.removeEffect(MobEffects.FIRE_RESISTANCE);
                }
                if (this.actionHandler.updateActions()) {
                    sync = true;
                    syncToAll = true;
                    syncPacket.put(this.actionHandler.nbtKey(), (Tag)this.actionHandler.serializeUpdateNBT((HolderLookup.Provider)this.asEntity().level().registryAccess()));
                }
                if (this.skillHandler.isDirty()) {
                    sync = true;
                    syncPacket.put(this.skillHandler.nbtKey(), (Tag)this.skillHandler.serializeUpdateNBT((HolderLookup.Provider)this.asEntity().level().registryAccess()));
                }
                if (sync) {
                    this.sync(syncPacket, syncToAll);
                }
                if (this.feed_victim != -1 && this.feedBiteTickCounter++ >= 20) {
                    this.updateFeeding();
                    this.feedBiteTickCounter = 0;
                }
                if (this.forceNaturalArmorUpdate || this.player.tickCount % 128 == 0) {
                    this.updateNaturalArmor(this.getLevel());
                    this.forceNaturalArmorUpdate = false;
                }
            } else {
                this.ticksInSun = 0;
            }
        } else {
            if (level > 0) {
                this.actionHandler.updateActions();
                if (this.isGettingSundamage((LevelAccessor)world)) {
                    this.handleSunDamage(true);
                } else if (this.ticksInSun > 0) {
                    --this.ticksInSun;
                }
            } else {
                this.ticksInSun = 0;
            }
            if (this.feed_victim != -1 && this.feedBiteTickCounter++ % 5 == 0) {
                Entity e = VampirismMod.proxy.getMouseOverEntity();
                if (e == null || e.getId() != this.feed_victim) {
                    VampirismMod.proxy.sendToServer(new ServerboundSimpleInputEvent(ServerboundSimpleInputEvent.Event.FINISH_SUCK_BLOOD));
                    this.feedBiteTickCounter = 0;
                    this.feed_victim = -1;
                    return;
                }
                if (this.feedBiteTickCounter >= 20) {
                    this.feedBiteTickCounter = 0;
                }
            }
        }
        if (this.feed_victim == -1) {
            this.feedBiteTickCounter = 0;
        }
        if (this.remainingBarkTicks > 0) {
            --this.remainingBarkTicks;
        }
        world.getProfiler().pop();
    }

    @Override
    public void onUpdatePlayer(PlayerTickEvent event) {
        if (event instanceof PlayerTickEvent.Post) {
            if (this.getLevel() > 0) {
                VampirismMod.proxy.handleSleepClient(this.player);
            }
            if (this.getLevel() > 0 && !this.isDBNO()) {
                this.player.level().getProfiler().push("vampirism_bloodupdate");
                if (!this.player.level().isClientSide && this.bloodStats.onUpdate()) {
                    this.syncProperty(this.bloodStats, false);
                }
                this.player.level().getProfiler().pop();
            }
        }
    }

    public void requestNaturalArmorUpdate() {
        this.forceNaturalArmorUpdate = true;
    }

    @Override
    @NotNull
    public CompoundTag serializeNBT(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        CompoundTag nbt = super.serializeNBT(provider);
        nbt.put(this.bloodStats.nbtKey(), (Tag)this.bloodStats.serializeNBT(provider));
        nbt.putInt(KEY_EYE, this.getEyeType());
        nbt.putInt(KEY_FANGS, this.getFangType());
        nbt.putBoolean(KEY_GLOWING_EYES, this.getGlowingEyes());
        nbt.put(this.actionHandler.nbtKey(), (Tag)this.actionHandler.serializeNBT(provider));
        nbt.put(this.skillHandler.nbtKey(), (Tag)this.skillHandler.serializeNBT(provider));
        nbt.put(this.vision.nbtKey(), (Tag)this.vision.serializeNBT(provider));
        if (this.isDBNO()) {
            nbt.putBoolean(KEY_WAS_DBNO, true);
        }
        return nbt;
    }

    public boolean setEyeType(int eyeType) {
        if (eyeType >= 17 || eyeType < 0) {
            return false;
        }
        if (eyeType != this.getEyeType()) {
            this.getSpecialAttributes().eyeType = eyeType;
            if (!this.isRemote()) {
                CompoundTag nbt = new CompoundTag();
                nbt.putInt(KEY_EYE, eyeType);
                this.sync(nbt, true);
            }
        }
        return true;
    }

    public boolean setFangType(int fangType) {
        if (fangType >= 7 || fangType < 0) {
            return false;
        }
        if (fangType != this.getFangType()) {
            this.getSpecialAttributes().fangType = fangType;
            if (!this.isRemote()) {
                CompoundTag nbt = new CompoundTag();
                nbt.putInt(KEY_FANGS, fangType);
                this.sync(nbt, true);
            }
        }
        return true;
    }

    public void setSkinData(@NotNull List<Integer> data) {
        block6: for (int i = 0; i < data.size(); ++i) {
            switch (i) {
                case 0: {
                    this.setFangType(data.get(i));
                    continue block6;
                }
                case 1: {
                    this.setEyeType(data.get(i));
                    continue block6;
                }
                case 2: {
                    this.setGlowingEyes(data.get(i) > 0);
                    continue block6;
                }
                case 3: {
                    FactionPlayerHandler.get(this.player).setTitleGender(data.get(i) > 0);
                }
            }
        }
    }

    public void switchVision() {
        this.vision.switchVision();
    }

    public void tryResurrect() {
        if (this.getDbnoTimer() == 0) {
            this.setDBNOTimer(-1);
            this.dbnoMessage = null;
            this.player.setHealth(Math.max(0.5f, (float)(this.bloodStats.getBloodLevel() - 1)));
            this.bloodStats.removeBlood(this.bloodStats.getBloodLevel() - 1, true);
            this.player.setForcedPose(null);
            this.player.refreshDimensions();
            this.sync(true);
            int duration = (int)this.player.getAttributeValue(ModAttributes.NEONATAL_DURATION);
            this.player.addEffect(new MobEffectInstance(ModEffects.NEONATAL, duration));
            this.player.awardStat((ResourceLocation)ModStats.RESURRECTED.get());
            Player player = this.player;
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                ((VampireActionCriterionTrigger)((Object)ModAdvancements.TRIGGER_VAMPIRE_ACTION.get())).trigger(serverPlayer, VampireActionCriterionTrigger.Action.RESURRECT);
            }
        } else if (this.isRemote()) {
            this.setDBNOTimer(-1);
        } else {
            this.sync(false);
        }
    }

    public void giveUpDBNO() {
        if (this.isDBNO()) {
            this.setDBNOTimer(-1);
            Component msg = this.dbnoMessage;
            this.dbnoMessage = null;
            this.player.setForcedPose(null);
            this.player.refreshDimensions();
            this.sync(true);
            DamageHandler.hurtModded((Entity)this.player, sources -> sources.dbno(msg), 10000.0f);
        }
    }

    @Override
    public void unUnlockVision(@NotNull IVampireVision vision) {
        this.vision.lockVision(vision);
    }

    @Override
    public void unlockVision(@NotNull IVampireVision vision) {
        this.vision.unlockVision(vision);
    }

    public void updateNaturalArmor(int lvl) {
        AttributeInstance armorAtt = this.player.getAttribute(Attributes.ARMOR);
        AttributeInstance toughnessAtt = this.player.getAttribute(Attributes.ARMOR_TOUGHNESS);
        if (armorAtt != null && toughnessAtt != null) {
            if (lvl == 0) {
                armorAtt.removeModifier(NATURAL_ARMOR_UUID);
                toughnessAtt.removeModifier(NATURAL_ARMOR_UUID);
            } else {
                AttributeModifier modArmor = armorAtt.getModifier(NATURAL_ARMOR_UUID);
                AttributeModifier modToughness = toughnessAtt.getModifier(NATURAL_ARMOR_UUID);
                double naturalArmor = VampirePlayer.getNaturalArmorValue(lvl);
                MobEffectInstance armorRegen = this.player.getEffect(ModEffects.ARMOR_REGENERATION);
                double armorRegenerationMod = armorRegen == null ? 0.0 : (double)armorRegen.getDuration() / ((double)((Integer)VampirismConfig.BALANCE.vpNaturalArmorRegenDuration.get()).intValue() * 20.0);
                double naturalToughness = VampirePlayer.getNaturalArmorToughnessValue(lvl);
                double baseArmor = ((AttributeInstanceAccessor)armorAtt).getModifiers(AttributeModifier.Operation.ADD_VALUE).stream().filter(pair -> ArmorModifier.ARMOR_IDS.contains(pair.id())).map(AttributeModifier::amount).mapToDouble(Double::doubleValue).sum();
                double baseToughness = ((AttributeInstanceAccessor)toughnessAtt).getModifiers(AttributeModifier.Operation.ADD_VALUE).stream().filter(m -> ArmorModifier.ARMOR_IDS.contains(m.id())).map(AttributeModifier::amount).mapToDouble(Double::doubleValue).sum();
                double targetArmor = Math.max(0.0, (naturalArmor *= 1.0 - 0.75 * armorRegenerationMod) - baseArmor);
                double targetToughness = Math.max(0.0, naturalToughness - baseToughness);
                if (modArmor != null && targetArmor != modArmor.amount()) {
                    ((AttributeInstanceAccessor)armorAtt).invoke_removeModifier(modArmor);
                    modArmor = null;
                }
                if (targetArmor != 0.0 && modArmor == null) {
                    armorAtt.addTransientModifier(new AttributeModifier(NATURAL_ARMOR_UUID, targetArmor, AttributeModifier.Operation.ADD_VALUE));
                }
                if (modToughness != null && targetToughness != modToughness.amount()) {
                    ((AttributeInstanceAccessor)toughnessAtt).invoke_removeModifier(modToughness);
                    modToughness = null;
                }
                if (targetToughness != 0.0 && modToughness == null) {
                    toughnessAtt.addTransientModifier(new AttributeModifier(NATURAL_ARMOR_UUID, targetToughness, AttributeModifier.Operation.ADD_VALUE));
                }
                this.applyLevelModifiersB(lvl, (Boolean)VampirismConfig.BALANCE.vpArmorPenalty.get() != false && baseArmor > 7.0);
            }
        }
    }

    @Override
    public boolean useBlood(int amt, boolean allowPartial) {
        return this.bloodStats.removeBlood(amt, allowPartial);
    }

    @Override
    public boolean wantsBlood() {
        return this.getLevel() > 0 && this.bloodStats.needsBlood();
    }

    @Override
    public void deserializeUpdateNBT(HolderLookup.Provider provider, @NotNull CompoundTag nbt) {
        super.deserializeUpdateNBT(provider, nbt);
        if (nbt.contains(KEY_EYE)) {
            this.setEyeType(nbt.getInt(KEY_EYE));
        }
        if (nbt.contains(KEY_FANGS)) {
            this.setFangType(nbt.getInt(KEY_FANGS));
        }
        if (nbt.contains(KEY_SPAWN_BITE_PARTICLE)) {
            this.spawnBiteParticle(nbt.getInt(KEY_SPAWN_BITE_PARTICLE));
        }
        if (nbt.contains(KEY_GLOWING_EYES)) {
            this.setGlowingEyes(nbt.getBoolean(KEY_GLOWING_EYES));
        }
        if (nbt.contains(KEY_FEED_VICTIM_ID)) {
            this.feed_victim = nbt.getInt(KEY_FEED_VICTIM_ID);
            if (this.feed_victim != -1) {
                if (this.feedingSoundReference == null || !this.feedingSoundReference.isPlaying()) {
                    this.feedingSoundReference = VampLib.proxy.createSoundReference((SoundEvent)ModSounds.VAMPIRE_FEEDING.get(), SoundSource.PLAYERS, this.player.getX(), this.player.getY(), this.player.getZ(), 0.8f, 1.0f);
                    this.feedingSoundReference.startPlaying();
                }
            } else if (this.feedingSoundReference != null) {
                this.feedingSoundReference.stopPlaying();
                this.feedingSoundReference = null;
            }
        }
        if (nbt.contains(KEY_DBNO_MSG)) {
            this.dbnoMessage = Component.Serializer.fromJson((String)nbt.getString(KEY_DBNO_MSG), (HolderLookup.Provider)provider);
        }
        if (nbt.contains(KEY_DBNO_TIMER)) {
            boolean wasDBNOClient = this.isDBNO();
            this.setDBNOTimer(nbt.getInt(KEY_DBNO_TIMER));
            if (!wasDBNOClient && this.isDBNO()) {
                VampirismMod.proxy.showDBNOScreen(this.player, this.dbnoMessage);
                this.player.setForcedPose(Pose.SLEEPING);
                this.player.refreshDimensions();
            } else if (wasDBNOClient && !this.isDBNO()) {
                this.player.setForcedPose(null);
                this.player.refreshDimensions();
            }
        }
        this.bloodStats.deserializeUpdateNBT(provider, nbt.getCompound(this.bloodStats.nbtKey()));
        this.actionHandler.deserializeUpdateNBT(provider, nbt.getCompound(this.actionHandler.nbtKey()));
        this.skillHandler.deserializeUpdateNBT(provider, nbt.getCompound(this.skillHandler.nbtKey()));
        if (nbt.contains(this.vision.nbtKey(), 10)) {
            this.vision.deserializeNBT(provider, nbt.getCompound(this.vision.nbtKey()));
        }
    }

    @Override
    @NotNull
    public CompoundTag serializeUpdateNBT(HolderLookup.Provider provider) {
        CompoundTag nbt = super.serializeUpdateNBT(provider);
        nbt.putInt(KEY_EYE, this.getEyeType());
        nbt.putInt(KEY_FANGS, this.getFangType());
        nbt.putBoolean(KEY_GLOWING_EYES, this.getGlowingEyes());
        nbt.putInt(KEY_FEED_VICTIM_ID, this.feed_victim);
        nbt.put(this.bloodStats.nbtKey(), (Tag)this.bloodStats.serializeUpdateNBT(provider));
        nbt.put(this.actionHandler.nbtKey(), (Tag)this.actionHandler.serializeUpdateNBT(provider));
        nbt.put(this.skillHandler.nbtKey(), (Tag)this.skillHandler.serializeUpdateNBT(provider));
        nbt.put(this.vision.nbtKey(), (Tag)this.vision.serializeUpdateNBT(provider));
        nbt.putInt(KEY_DBNO_TIMER, this.getDbnoTimer());
        if (this.dbnoMessage != null) {
            nbt.putString(KEY_DBNO_MSG, Component.Serializer.toJson((Component)this.dbnoMessage, (HolderLookup.Provider)provider));
        }
        return nbt;
    }

    private void applyEntityAttributes() {
        this.player.getAttribute(ModAttributes.SUNDAMAGE).setBaseValue(((Double)VampirismConfig.BALANCE.vpSundamage.get()).doubleValue());
        this.player.getAttribute(ModAttributes.BLOOD_EXHAUSTION).setBaseValue(((Double)VampirismConfig.BALANCE.vpBloodExhaustionFactor.get()).doubleValue());
        this.player.getAttribute(ModAttributes.NEONATAL_DURATION).setBaseValue((double)((Integer)VampirismConfig.BALANCE.vpNeonatalDuration.get() * 20));
        this.player.getAttribute(ModAttributes.DBNO_DURATION).setBaseValue((double)((Integer)VampirismConfig.BALANCE.vpDbnoDuration.get() * 20));
    }

    private void removeEntityAttributes() {
        this.player.getAttribute(ModAttributes.SUNDAMAGE).setBaseValue(0.0);
        this.player.getAttribute(ModAttributes.BLOOD_EXHAUSTION).setBaseValue(0.0);
        this.player.getAttribute(ModAttributes.NEONATAL_DURATION).setBaseValue(0.0);
        this.player.getAttribute(ModAttributes.DBNO_DURATION).setBaseValue(0.0);
    }

    private void applyLevelModifiersA(int level) {
        int damage;
        LevelAttributeModifier.applyModifier(this.player, (Holder<Attribute>)Attributes.MAX_HEALTH, "Vampire", level, this.getMaxLevel(), (Double)VampirismConfig.BALANCE.vpHealthMaxMod.get(), 0.5, AttributeModifier.Operation.ADD_VALUE, true);
        LevelAttributeModifier.applyModifier(this.player, ModAttributes.BLOOD_EXHAUSTION, "Vampire", level, this.getMaxLevel(), (Double)VampirismConfig.BALANCE.vpExhaustionMaxMod.get(), 0.5, AttributeModifier.Operation.ADD_MULTIPLIED_BASE, false);
        AttributeInstance attribute = this.player.getAttribute(Attributes.ATTACK_DAMAGE);
        attribute.removeModifier(LEVEL_DAMAGE_UUID);
        int n = level >= 7 ? (level >= 14 ? 2 : 1) : (damage = 0);
        if (damage > 0) {
            attribute.addPermanentModifier(new AttributeModifier(LEVEL_DAMAGE_UUID, (double)damage, AttributeModifier.Operation.ADD_VALUE));
        }
    }

    private void applyLevelModifiersB(int level, boolean heavyArmor) {
        LevelAttributeModifier.applyModifier(this.player, (Holder<Attribute>)Attributes.MOVEMENT_SPEED, "Vampire", level, this.getMaxLevel(), (Double)VampirismConfig.BALANCE.vpSpeedMaxMod.get() * (double)(heavyArmor ? 0.5f : 1.0f), 0.5, AttributeModifier.Operation.ADD_MULTIPLIED_BASE, false);
        LevelAttributeModifier.applyModifier(this.player, (Holder<Attribute>)Attributes.ATTACK_SPEED, "Vampire", level, this.getMaxLevel(), (Double)VampirismConfig.BALANCE.vpAttackSpeedMaxMod.get() * (double)(heavyArmor ? 0.5f : 1.0f), 0.5, AttributeModifier.Operation.ADD_MULTIPLIED_BASE, false);
    }

    private void biteBlock(@NotNull BlockPos pos, @NotNull BlockState blockState, @Nullable BlockEntity tileEntity) {
        if (this.isRemote()) {
            return;
        }
        if (this.getLevel() == 0) {
            return;
        }
        if (!this.bloodStats.needsBlood()) {
            return;
        }
        int need = Math.min(8, this.bloodStats.getMaxBlood() - this.bloodStats.getBloodLevel());
        if (ModBlocks.BLOOD_CONTAINER.get() == blockState.getBlock() && tileEntity != null) {
            Optional.ofNullable(tileEntity.getLevel()).map(tile -> (IFluidHandler)tile.getCapability(Capabilities.FluidHandler.BLOCK, pos, blockState, tileEntity, null)).ifPresent(handler -> {
                FluidStack drained;
                int blood = 0;
                FluidStack drainable = handler.drain(new FluidStack((Fluid)ModFluids.BLOOD.get(), need * 100), IFluidHandler.FluidAction.SIMULATE);
                if (drainable.getAmount() >= 100 && !(drained = handler.drain(drainable.getAmount() / 100 * 100, IFluidHandler.FluidAction.EXECUTE)).isEmpty()) {
                    blood = drained.getAmount() / 100;
                }
                if (blood > 0) {
                    this.drinkBlood(blood, 0.3f, new DrinkBloodContext(blockState, pos));
                    this.syncProperty(this.bloodStats, true);
                }
            });
        }
    }

    private boolean biteFeed(@NotNull LivingEntity entity) {
        if (this.isRemote()) {
            return true;
        }
        if (this.getLevel() == 0) {
            return false;
        }
        int blood = 0;
        float saturationMod = 1.0f;
        boolean continue_feeding = true;
        if (this.feed_victim_bite_type == IVampirePlayer.BITE_TYPE.SUCK_BLOOD_CREATURE && entity.isAlive()) {
            Optional<ExtendedCreature> opt = ExtendedCreature.getSafe((Entity)entity);
            blood = opt.map(creature -> creature.onBite(this)).orElse(0);
            saturationMod = opt.map(IBiteableEntity::getBloodSaturation).orElse(Float.valueOf(0.0f)).floatValue();
            if (this.isAdvancedBiter() && opt.map(IExtendedCreatureVampirism::getBlood).orElse(0) == 1) {
                continue_feeding = false;
            }
        } else if (this.feed_victim_bite_type == IVampirePlayer.BITE_TYPE.SUCK_BLOOD_PLAYER) {
            VampirePlayer vampire = VampirePlayer.get((Player)entity);
            blood = vampire.onBite(this);
            saturationMod = vampire.getBloodSaturation();
        } else if (this.feed_victim_bite_type == IVampirePlayer.BITE_TYPE.SUCK_BLOOD) {
            blood = ((IBiteableEntity)entity).onBite(this);
            saturationMod = ((IBiteableEntity)entity).getBloodSaturation();
        }
        if (blood > 0) {
            this.drinkBlood(blood, saturationMod, new DrinkBloodContext(entity));
            CompoundTag updatePacket = new CompoundTag();
            updatePacket.put(this.bloodStats.nbtKey(), (Tag)this.bloodStats.serializeUpdateNBT((HolderLookup.Provider)entity.registryAccess()));
            updatePacket.putInt(KEY_SPAWN_BITE_PARTICLE, entity.getId());
            this.sync(updatePacket, true);
            if (this.player instanceof ServerPlayer) {
                ((VampireActionCriterionTrigger)((Object)ModAdvancements.TRIGGER_VAMPIRE_ACTION.get())).trigger((ServerPlayer)this.player, VampireActionCriterionTrigger.Action.SUCK_BLOOD);
            }
            return continue_feeding;
        }
        return false;
    }

    private void handleSpareBlood(int amt) {
        BloodHelper.fillBloodIntoInventory(this.player, amt * 100);
    }

    private void handleSunDamage(boolean isRemote) {
        int sunscreen;
        MobEffectInstance potionEffect = this.player.getEffect(ModEffects.SUNSCREEN);
        int n = sunscreen = potionEffect == null ? -1 : potionEffect.getAmplifier();
        if (this.ticksInSun < 100) {
            ++this.ticksInSun;
        }
        if (this.ticksInSun > 50 && (sunscreen >= 4 || ((Boolean)VampirismConfig.BALANCE.vpSunscreenBuff.get()).booleanValue() && sunscreen >= 0)) {
            this.ticksInSun = 50;
        }
        if (!this.player.isAlive() || isRemote || this.player.getAbilities().instabuild || this.player.getAbilities().invulnerable) {
            return;
        }
        if (this.ticksInSun == 100 && ((Boolean)VampirismConfig.BALANCE.vpSundamageInstantDeath.get()).booleanValue()) {
            DamageHandler.kill((Entity)this.player, 100000);
            this.turnToAsh();
        }
        if (((Boolean)VampirismConfig.BALANCE.vpSundamageNausea.get()).booleanValue() && this.getLevel() >= (Integer)VampirismConfig.BALANCE.vpSundamageNauseaMinLevel.get() && this.player.tickCount % 300 == 1 && this.ticksInSun > 50 && sunscreen == -1) {
            this.player.addEffect(new MobEffectInstance(MobEffects.CONFUSION, 180));
        }
        if (this.getLevel() >= (Integer)VampirismConfig.BALANCE.vpSundamageWeaknessMinLevel.get() && this.player.tickCount % 150 == 3 && sunscreen < 5) {
            this.player.addEffect(new MobEffectInstance(MobEffects.WEAKNESS, 152, 0));
        }
        if (this.getLevel() >= (Integer)VampirismConfig.BALANCE.vpSundamageMinLevel.get() && this.ticksInSun >= 100 && this.player.tickCount % 40 == 5) {
            float damage = (float)this.player.getAttribute(ModAttributes.SUNDAMAGE).getValue();
            if (damage > 0.0f) {
                DamageHandler.hurtModded((Entity)this.player, ModDamageSources::sunDamage, damage);
            }
            if (!this.player.isAlive()) {
                this.turnToAsh();
            }
        }
    }

    private void turnToAsh() {
        if (!this.player.isAlive()) {
            this.player.deathTime = 19;
            ModParticles.spawnParticlesServer(this.player.level(), (ParticleOptions)ParticleTypes.WHITE_ASH, this.player.getX() + 0.5, this.player.getY() + (double)this.player.getBbHeight(), this.player.getZ() + 0.5, 20, 0.2, (double)this.player.getBbHeight() * 0.2, 0.2, 0.1);
            ModParticles.spawnParticlesServer(this.player.level(), (ParticleOptions)ParticleTypes.ASH, this.player.getX() + 0.5, this.player.getY() + (double)(this.player.getBbHeight() / 2.0f), this.player.getZ() + 0.5, 20, 0.2, (double)this.player.getBbHeight() * 0.2, 0.2, 0.1);
        }
    }

    private void resetNearbyTargetingMobs() {
        AABB axisalignedbb = new AABB(this.player.blockPosition()).inflate(32.0, 10.0, 32.0);
        this.player.level().getEntitiesOfClass(Mob.class, axisalignedbb).forEach(e -> {
            if (e.getTarget() == this.player) {
                e.targetSelector.getAvailableGoals().stream().filter(WrappedGoal::isRunning).filter(g -> g.getGoal() instanceof TargetGoal).forEach(WrappedGoal::stop);
            }
            if (e instanceof NeutralMob) {
                ((NeutralMob)e).playerDied(this.player);
            }
        });
    }

    private void setDBNOTimer(int newValue) {
        this.dbnoTimer = newValue;
        this.getSpecialAttributes().isDBNO = this.isDBNO();
    }

    private void spawnBiteParticle(int entityId) {
        Entity entity = this.player.level().getEntity(entityId);
        if (entity != null) {
            UtilLib.spawnParticles(this.player.level(), (ParticleOptions)ParticleTypes.CRIT, entity.getX(), entity.getY(), entity.getZ(), this.player.getX() - entity.getX(), this.player.getY() - entity.getY(), this.player.getZ() - entity.getZ(), 10, 1.0f);
        }
        for (int j = 0; j < 16; ++j) {
            Vec3 vec3 = new Vec3(((double)this.player.getRandom().nextFloat() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, 0.0);
            vec3 = vec3.xRot(-this.player.getXRot() * (float)Math.PI / 180.0f);
            vec3 = vec3.yRot(-this.player.getYRot() * (float)Math.PI / 180.0f);
            double d0 = (double)(-this.player.getRandom().nextFloat()) * 0.6 - 0.3;
            Vec3 vec31 = new Vec3(((double)this.player.getRandom().nextFloat() - 0.5) * 0.3, d0, 0.6);
            vec31 = vec31.xRot(-this.player.getXRot() * (float)Math.PI / 180.0f);
            vec31 = vec31.yRot(-this.player.getYRot() * (float)Math.PI / 180.0f);
            vec31 = vec31.add(this.player.getX(), this.player.getY() + (double)this.player.getEyeHeight(), this.player.getZ());
            this.player.level().addParticle((ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, new ItemStack((ItemLike)Items.APPLE)), vec31.x, vec31.y, vec31.z, vec3.x, vec3.y + 0.05, vec3.z);
        }
    }

    private void updateFeeding() {
        Entity entity = this.player.level().getEntity(this.feed_victim);
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity e = (LivingEntity)entity;
        if (e.getHealth() == 0.0f) {
            this.endFeeding(true);
            return;
        }
        e.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 20, 7, false, false));
        this.player.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 25, 4, false, false));
        ModParticles.spawnParticlesServer(this.player.level(), new FlyingBloodEntityParticleOptions(this.player.getId(), true), e.getX(), e.getY() + (double)(e.getEyeHeight() / 2.0f), e.getZ(), 10, 0.1f, 0.1f, 0.1f, 0.0);
        if (!this.biteFeed(e)) {
            this.endFeeding(true);
        }
        if (!((double)e.distanceTo((Entity)this.player) <= this.player.getAttribute(Attributes.ENTITY_INTERACTION_RANGE).getValue() + 1.0) || e.getHealth() == 0.0f) {
            this.endFeeding(true);
        }
    }

    @Override
    public void updateMinionAttributes(boolean enabled) {
        MinionWorldData.getData(this.player.level()).ifPresent(a -> a.getOrCreateController(FactionPlayerHandler.get(this.player)).contactMinions(minion -> {
            minion.getMinionData().ifPresent(b -> ((VampireMinionEntity.VampireMinionData)b).setIncreasedStats(enabled));
            HelperLib.sync(minion);
        }));
    }

    @Override
    public String nbtKey() {
        return this.getAttachedKey().getPath();
    }

    private class VisionStatus
    implements ISyncableSaveData {
        private static final String KEY_VISION = "vision";
        private final SortedSet<IVampireVision> unlockedVisions = new TreeSet<IVampireVision>(Comparator.comparing(o -> VampirismAPI.vampireVisionRegistry().getVisionId((IVampireVision)o)));
        private ResourceLocation visionId;
        private IVampireVision vision;

        private VisionStatus() {
        }

        public void deactivate() {
            if (this.vision != null) {
                this.vision.onDeactivated(VampirePlayer.this);
                this.vision = null;
                this.visionId = null;
            }
        }

        public void deactivate(IVampireVision vision) {
            if (this.vision == vision) {
                this.deactivate();
            }
        }

        private void tick() {
            if (this.vision != null) {
                this.vision.tick(VampirePlayer.this);
                if (!this.vision.isEnabled()) {
                    this.deactivate();
                }
            }
        }

        private void switchVision() {
            List<IVampireVision> visions = VampirismAPI.vampireVisionRegistry().getVisions().stream().filter(this.unlockedVisions::contains).toList();
            int newIndex = this.vision != null ? visions.indexOf(this.vision) + 1 : 0;
            IVampireVision newVision = newIndex >= visions.size() ? null : visions.get(newIndex);
            this.activate(newVision);
        }

        public void unlockVision(IVampireVision vision) {
            VampirismAPI.vampireVisionRegistry().getVisionId(vision);
            this.unlockedVisions.add(vision);
        }

        public void lockVision(IVampireVision vision) {
            this.deactivate(vision);
            this.unlockedVisions.remove(vision);
        }

        public void activate(@Nullable IVampireVision vision) {
            if (this.vision != null && this.vision == vision) {
                return;
            }
            if (vision != null && !this.unlockedVisions.contains(vision)) {
                return;
            }
            if (this.vision != null) {
                this.deactivate();
            }
            if (vision != null) {
                if (vision.isEnabled()) {
                    this.vision = vision;
                    this.vision.onActivated(VampirePlayer.this);
                } else if (VampirePlayer.this.player.isAddedToLevel()) {
                    VampirePlayer.this.player.displayClientMessage((Component)Component.translatable((String)"text.vampirism.vision_disabled_by_config"), true);
                }
                this.visionId = VampirismAPI.vampireVisionRegistry().getVisionId(vision);
            } else {
                this.vision = null;
                this.visionId = null;
            }
            if (!VampirePlayer.this.isRemote() && VampirePlayer.this.player.isAddedToLevel()) {
                CompoundTag tag = new CompoundTag();
                tag.put("vision", (Tag)this.serializeUpdateNBT((HolderLookup.Provider)VampirePlayer.this.asEntity().registryAccess()));
                VampirePlayer.this.sync(tag, false);
            }
        }

        @Override
        @NotNull
        public CompoundTag serializeNBT(// Could not load outer class - annotation placement on inner may be incorrect
         @NotNull HolderLookup.Provider provider) {
            CompoundTag tag = new CompoundTag();
            if (this.visionId == null) {
                tag.putBoolean("hasVision", false);
            } else {
                tag.putBoolean("hasVision", true);
                tag.putString(this.vision != null ? "vision" : "visionId", this.visionId.toString());
            }
            return tag;
        }

        @Override
        public void deserializeNBT(// Could not load outer class - annotation placement on inner may be incorrect
         @NotNull HolderLookup.Provider provider, @NotNull CompoundTag tag) {
            if (tag.getBoolean("hasVision")) {
                if (tag.contains("vision", 8)) {
                    this.activate(VampirismAPI.vampireVisionRegistry().getVision(ResourceLocation.parse((String)tag.getString("vision"))));
                } else if (tag.contains("visionId", 8)) {
                    this.deactivate();
                    this.visionId = ResourceLocation.parse((String)tag.getString("visionId"));
                }
            } else {
                this.deactivate();
                this.vision = null;
                this.visionId = null;
            }
        }

        @Override
        public void deserializeUpdateNBT(HolderLookup.Provider provider, @NotNull CompoundTag nbt) {
            this.deserializeNBT(provider, nbt);
        }

        @Override
        @NotNull
        public CompoundTag serializeUpdateNBT(HolderLookup.Provider provider) {
            return this.serializeNBT(provider);
        }

        @Override
        public String nbtKey() {
            return "vision";
        }
    }

    public static class Factory
    implements Function<IAttachmentHolder, VampirePlayer> {
        @Override
        public VampirePlayer apply(IAttachmentHolder holder) {
            if (holder instanceof Player) {
                Player player = (Player)holder;
                return new VampirePlayer(player);
            }
            throw new IllegalArgumentException("Cannot create vampire player attachment for holder " + String.valueOf(holder.getClass()) + ". Expected Player");
        }
    }

    public static class Serializer
    implements IAttachmentSerializer<CompoundTag, VampirePlayer> {
        @NotNull
        public VampirePlayer read(@NotNull IAttachmentHolder holder, @NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
         @NotNull HolderLookup.Provider provider) {
            if (holder instanceof Player) {
                Player player = (Player)holder;
                VampirePlayer vampire = new VampirePlayer(player);
                vampire.deserializeNBT(provider, tag);
                return vampire;
            }
            throw new IllegalArgumentException("Holder is not a player");
        }

        public CompoundTag write(VampirePlayer attachment, // Could not load outer class - annotation placement on inner may be incorrect
         @NotNull HolderLookup.Provider provider) {
            return attachment.serializeNBT(provider);
        }
    }
}

