/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.player.skills;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.teamlapen.vampirism.api.VampirismRegistries;
import de.teamlapen.vampirism.api.entity.factions.ISkillNode;
import de.teamlapen.vampirism.api.entity.factions.ISkillTree;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.resources.RegistryFixedCodec;

public record SkillTreeConfiguration(Holder<ISkillTree> skillTree, Holder<ISkillNode> root, List<SkillTreeNodeConfiguration> children) {
    public static final Codec<SkillTreeConfiguration> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)RegistryFixedCodec.create(VampirismRegistries.Keys.SKILL_TREE).fieldOf("skill_tree").forGetter(SkillTreeConfiguration::skillTree), (App)RegistryFixedCodec.create(VampirismRegistries.Keys.SKILL_NODE).fieldOf("node").forGetter(SkillTreeConfiguration::root), (App)SkillTreeNodeConfiguration.CODEC.listOf().fieldOf("children").forGetter(SkillTreeConfiguration::children)).apply((Applicative)inst, SkillTreeConfiguration::new));

    public SkillTreeConfiguration(Holder<ISkillTree> skillTree, Holder<ISkillNode> root, SkillTreeNodeConfiguration ... children) {
        this(skillTree, root, List.of(children));
    }

    public SkillTreeConfiguration(Holder<ISkillTree> skillTree, Holder<ISkillNode> root, List<SkillTreeNodeConfiguration> children) {
        children.forEach(c -> c.setTreeConfig(this));
        this.skillTree = skillTree;
        this.root = root;
        this.children = children;
    }

    public boolean contains(ISkill<?> skill) {
        if (((ISkillNode)this.root.value()).containsSkill(skill)) {
            return true;
        }
        for (SkillTreeNodeConfiguration child : this.children) {
            if (!child.contains(skill)) continue;
            return true;
        }
        return false;
    }

    public Optional<SkillTreeNodeConfiguration> getNode(ISkill<?> skill) {
        for (SkillTreeNodeConfiguration child : this.children) {
            Optional<SkillTreeNodeConfiguration> result = child.getNode(skill);
            if (!result.isPresent()) continue;
            return result;
        }
        return Optional.empty();
    }

    public static final class SkillTreeNodeConfiguration {
        public static final Codec<SkillTreeNodeConfiguration> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)RegistryFixedCodec.create(VampirismRegistries.Keys.SKILL_NODE).fieldOf("node").forGetter(SkillTreeNodeConfiguration::node), (App)Codec.lazyInitialized(() -> CODEC).listOf().optionalFieldOf("children", List.of()).forGetter(SkillTreeNodeConfiguration::children)).apply((Applicative)inst, SkillTreeNodeConfiguration::new));
        private final Holder<ISkillNode> node;
        private final List<SkillTreeNodeConfiguration> children;
        private final boolean isRoot;
        private SkillTreeConfiguration treeConfig;

        public SkillTreeNodeConfiguration(Holder<ISkillNode> node, List<SkillTreeNodeConfiguration> children, boolean isRoot) {
            this.node = node;
            this.children = children;
            this.isRoot = isRoot;
        }

        public SkillTreeNodeConfiguration(Holder<ISkillNode> node, List<SkillTreeNodeConfiguration> children) {
            this(node, children, false);
        }

        public SkillTreeNodeConfiguration(Holder<ISkillNode> node, SkillTreeNodeConfiguration ... children) {
            this(node, List.of(children));
        }

        public int elementCount() {
            return ((ISkillNode)this.node.value()).skills().size();
        }

        public List<Holder<ISkill<?>>> elements() {
            return ((ISkillNode)this.node.value()).skills();
        }

        public int childrenCount() {
            return this.children.size();
        }

        public Holder<ISkillNode> node() {
            return this.node;
        }

        public List<SkillTreeNodeConfiguration> children() {
            return this.children;
        }

        public boolean isRoot() {
            return this.isRoot;
        }

        public void setTreeConfig(SkillTreeConfiguration treeConfig) {
            this.treeConfig = treeConfig;
            this.children.forEach(x -> x.setTreeConfig(treeConfig));
        }

        public SkillTreeConfiguration getTreeConfig() {
            return this.treeConfig;
        }

        public boolean contains(ISkill<?> skill) {
            if (((ISkillNode)this.node.value()).containsSkill(skill)) {
                return true;
            }
            for (SkillTreeNodeConfiguration child : this.children) {
                if (!child.contains(skill)) continue;
                return true;
            }
            return false;
        }

        public Optional<SkillTreeNodeConfiguration> getNode(ISkill<?> skill) {
            if (((ISkillNode)this.node().value()).containsSkill(skill)) {
                return Optional.of(this);
            }
            for (SkillTreeNodeConfiguration child : this.children) {
                Optional<SkillTreeNodeConfiguration> result = child.getNode(skill);
                if (!result.isPresent()) continue;
                return result;
            }
            return Optional.empty();
        }
    }
}

