/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.player;

import de.teamlapen.vampirism.api.util.VResourceLocation;
import net.minecraft.SharedConstants;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;

public class LevelAttributeModifier {
    public static final ResourceLocation ID = VResourceLocation.mod("level_attribute_modifier");

    public static void applyModifier(@NotNull Player player, @NotNull Holder<Attribute> attribute, String name, int level, int lcap, double max, double type, // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull AttributeModifier.Operation operation, boolean evenIntOnly) {
        double m = LevelAttributeModifier.calculateModifierValue(level, lcap, max, type);
        AttributeInstance instance = player.getAttribute(attribute);
        if (instance != null) {
            instance.removeModifier(ID);
            if (evenIntOnly) {
                m = Math.round(m / 2.0) * 2L;
            }
            instance.addPermanentModifier(new AttributeModifier(ID, m, operation));
        } else if (SharedConstants.IS_RUNNING_IN_IDE) {
            throw new IllegalStateException("Attribute " + String.valueOf(attribute) + " not found for player " + String.valueOf(player));
        }
    }

    public static double calculateModifierValue(int level, int lcap, double maxMod, double type) {
        return Math.pow(Math.min(level, lcap), type) / Math.pow(lcap, type) * maxMod;
    }
}

