/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.minion.management;

import de.teamlapen.lib.HelperLib;
import de.teamlapen.lib.lib.inventory.InventoryHelper;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.entity.factions.IFactionRegistry;
import de.teamlapen.vampirism.api.entity.minion.IMinionData;
import de.teamlapen.vampirism.api.entity.minion.IMinionTask;
import de.teamlapen.vampirism.config.BalanceMobProps;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.entity.minion.MinionEntity;
import de.teamlapen.vampirism.entity.minion.management.MinionInventory;
import de.teamlapen.vampirism.entity.minion.management.MinionTasks;
import de.teamlapen.vampirism.util.RegUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.util.INBTSerializable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MinionData
implements INBTSerializable<CompoundTag>,
IMinionData {
    public static final int MAX_NAME_LENGTH = 15;
    protected static final Logger LOGGER = LogManager.getLogger();
    @NotNull
    private final MinionInventory inventory;
    private float health;
    private String name;
    @NotNull
    private CompoundTag entityCaps = new CompoundTag();
    @NotNull
    private IMinionTask.IMinionTaskDesc<MinionData> activeTaskDesc;
    private boolean taskLocked;

    @Nullable
    public static <T extends MinionData> T fromNBT(HolderLookup.Provider provider, @NotNull CompoundTag nbt) {
        ResourceLocation dataType = ResourceLocation.parse((String)nbt.getString("data_type"));
        return (T)((MinionData)Optional.ofNullable(VampirismAPI.factionRegistry().getMinion(dataType)).map(IFactionRegistry.IMinionEntry::data).map(Supplier::get).map(s -> {
            try {
                MinionData t = (MinionData)s;
                t.deserializeNBT(provider, nbt);
                return t;
            }
            catch (ClassCastException ex) {
                return null;
            }
        }).orElse(null));
    }

    protected MinionData(String name, int invSize) {
        this.health = this.getMaxHealth();
        this.name = name;
        this.inventory = new MinionInventory(invSize);
        this.activeTaskDesc = new IMinionTask.NoDesc<MinionData>((IMinionTask)MinionTasks.NOTHING.get());
    }

    protected MinionData() {
        this.inventory = new MinionInventory();
        this.activeTaskDesc = new IMinionTask.NoDesc<MinionData>((IMinionTask)MinionTasks.NOTHING.get());
    }

    public void deserializeNBT(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider, @NotNull CompoundTag nbt) {
        this.inventory.read(provider, nbt.getList("inv", 10));
        this.inventory.setAvailableSize(nbt.getInt("inv_size"));
        this.health = nbt.getFloat("health");
        this.name = nbt.getString("name");
        this.taskLocked = nbt.getBoolean("locked");
        if (nbt.contains("task", 10)) {
            CompoundTag task = nbt.getCompound("task");
            ResourceLocation id = ResourceLocation.parse((String)task.getString("id"));
            IMinionTask<?, ?> activeTask = RegUtil.getMinionTask(id);
            if (activeTask != null) {
                this.activeTaskDesc = activeTask.readFromNBT(provider, task);
            } else {
                LOGGER.error("Saved minion task does not exist anymore {}", (Object)id);
            }
        }
        this.entityCaps = nbt.getCompound("caps");
    }

    @NotNull
    public IMinionTask.IMinionTaskDesc<MinionData> getCurrentTaskDesc() {
        return this.activeTaskDesc;
    }

    public int getDefaultInventorySize() {
        return 9;
    }

    public MutableComponent getFormattedName() {
        return Component.literal((String)this.name);
    }

    @Override
    public float getHealth() {
        return this.health;
    }

    public void setHealth(float health) {
        this.health = health;
    }

    @Override
    public MinionInventory getInventory() {
        return this.inventory;
    }

    public int getInventorySize() {
        return this.getDefaultInventorySize();
    }

    @Override
    public int getMaxHealth() {
        Objects.requireNonNull(BalanceMobProps.mobProps);
        return 45;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void handleMinionAppearanceConfig(String name, List<Integer> data) {
    }

    public boolean hasUsedSkillPoints() {
        return false;
    }

    public boolean isTaskLocked() {
        return this.taskLocked;
    }

    @NotNull
    public CompoundTag getEntityCaps() {
        return this.entityCaps;
    }

    public void updateEntityCaps(CompoundTag caps) {
        this.entityCaps = caps;
    }

    public void resetStats(@NotNull MinionEntity<?> entity) {
        entity.getInventory().ifPresent(inv -> {
            if (!InventoryHelper.removeItemFromInventory(inv, new ItemStack((ItemLike)ModItems.OBLIVION_POTION.get()))) {
                entity.getLordOpt().ifPresent(lord -> InventoryHelper.removeItemFromInventory((Container)lord.getPlayer().getInventory(), new ItemStack((ItemLike)ModItems.OBLIVION_POTION.get())));
            }
        });
        HelperLib.sync(entity);
    }

    @NotNull
    public final CompoundTag serializeNBT(HolderLookup.Provider provider) {
        CompoundTag tag = new CompoundTag();
        this.serializeNBT(tag, provider);
        return tag;
    }

    public void serializeNBT(@NotNull CompoundTag tag, HolderLookup.Provider provider) {
        tag.putInt("inv_size", this.inventory.getAvailableSize());
        tag.put("inv", (Tag)this.inventory.write(provider, new ListTag()));
        tag.putFloat("health", this.health);
        tag.putString("name", this.name);
        tag.putString("data_type", this.getDataType().toString());
        tag.putBoolean("locked", this.taskLocked);
        if (this.activeTaskDesc != null) {
            CompoundTag task = new CompoundTag();
            task.putString("id", RegUtil.id(this.activeTaskDesc.getTask()).toString());
            this.activeTaskDesc.writeToNBT(task);
            tag.put("task", (Tag)task);
        }
        tag.put("caps", (Tag)this.entityCaps);
    }

    public boolean setTaskLocked(boolean locked) {
        this.taskLocked = locked;
        return this.taskLocked;
    }

    public void shrinkInventory(@NotNull MinionEntity<?> entity) {
        Optional<MinionInventory> invOpt = entity.getMinionData().map(MinionData::getInventory);
        if (invOpt.isPresent()) {
            MinionInventory inv = invOpt.get();
            ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
            for (int i = 6 + this.getDefaultInventorySize(); i < inv.getContainerSize(); ++i) {
                ItemStack stack = inv.removeItemNoUpdate(i);
                if (stack.isEmpty()) continue;
                stacks.add(stack);
            }
            inv.setAvailableSize(this.getInventorySize());
            for (ItemStack stack : stacks) {
                if (stack.isEmpty()) continue;
                inv.addItemStack(stack);
                if (stack.isEmpty()) continue;
                entity.getLordOpt().ifPresent(lord -> {
                    if (!lord.getPlayer().addItem(stack)) {
                        entity.spawnAtLocation(stack);
                    }
                });
            }
        }
    }

    public <Q extends IMinionTask.IMinionTaskDesc<MinionData>, T extends IMinionTask<Q, ?>> void switchTask(@NotNull T oldTask, IMinionTask.IMinionTaskDesc<MinionData> oldDesc, @NotNull IMinionTask.IMinionTaskDesc<MinionData> newDesc) {
        oldTask.deactivateTask(oldDesc);
        this.activeTaskDesc = newDesc;
    }

    public boolean upgradeStat(int statId, @NotNull MinionEntity<?> entity) {
        if (statId == -1) {
            this.resetStats(entity);
            return true;
        }
        return false;
    }

    protected ResourceLocation getDataType() {
        return ResourceLocation.withDefaultNamespace((String)"");
    }
}

