/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.minion.goals;

import de.teamlapen.vampirism.entity.minion.MinionEntity;
import de.teamlapen.vampirism.entity.minion.management.MinionTasks;
import java.util.EnumSet;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import org.jetbrains.annotations.NotNull;

public class DefendLordGoal
extends TargetGoal {
    @NotNull
    protected final MinionEntity<?> entity;
    @NotNull
    private final TargetingConditions predicate;
    private final int maxStartDistSQ = 200;
    private final int maxStopDistSQ = 500;

    public DefendLordGoal(@NotNull MinionEntity<?> mobIn) {
        super(mobIn, false, false);
        this.setFlags(EnumSet.of(Goal.Flag.TARGET));
        this.entity = mobIn;
        this.predicate = TargetingConditions.forCombat().selector(e -> this.entity.getAttackPredicate(false).test((LivingEntity)e) && this.entity.getLordOpt().map(lp -> lp.getPlayer().distanceToSqr((Entity)e) < 200.0).orElse(true) != false).ignoreInvisibilityTesting().range(60.0);
    }

    public boolean canContinueToUse() {
        return this.entity.getCurrentTask().map(d -> d.getTask() == MinionTasks.PROTECT_LORD.get()).orElse(false) != false && super.canContinueToUse() && this.entity.getLordOpt().map(lp -> lp.getPlayer().distanceToSqr((Entity)this.targetMob) < 500.0).orElse(true) != false;
    }

    public boolean canUse() {
        return this.entity.getCurrentTask().map(d -> d.getTask() == MinionTasks.PROTECT_LORD.get()).orElse(false) != false && this.entity.getLordOpt().map(lp -> {
            LivingEntity attackTarget = lp.getPlayer().getLastHurtMob();
            if (this.canAttack(attackTarget, this.predicate)) {
                this.targetMob = attackTarget;
                return true;
            }
            LivingEntity revengeTarget = lp.getPlayer().getLastHurtByMob();
            if (this.canAttack(revengeTarget, this.predicate)) {
                this.targetMob = revengeTarget;
                return true;
            }
            return false;
        }).orElse(false) != false;
    }

    public void start() {
        super.start();
        this.entity.setTarget(this.targetMob);
    }
}

