/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.hunter;

import com.mojang.authlib.GameProfile;
import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.difficulty.Difficulty;
import de.teamlapen.vampirism.api.entity.EntityClassType;
import de.teamlapen.vampirism.api.entity.VampireBookLootProvider;
import de.teamlapen.vampirism.api.entity.actions.EntityActionTier;
import de.teamlapen.vampirism.api.entity.actions.IEntityActionUser;
import de.teamlapen.vampirism.api.entity.hunter.IAdvancedHunter;
import de.teamlapen.vampirism.api.entity.hunter.IVampirismCrossbowUser;
import de.teamlapen.vampirism.api.items.IVampirismCrossbow;
import de.teamlapen.vampirism.api.settings.Supporter;
import de.teamlapen.vampirism.api.world.ICaptureAttributes;
import de.teamlapen.vampirism.config.BalanceMobProps;
import de.teamlapen.vampirism.core.ModEntities;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.entity.VampirismEntity;
import de.teamlapen.vampirism.entity.action.ActionHandlerEntity;
import de.teamlapen.vampirism.entity.ai.goals.AttackVillageGoal;
import de.teamlapen.vampirism.entity.ai.goals.DefendVillageGoal;
import de.teamlapen.vampirism.entity.ai.goals.RangedHunterCrossbowAttackGoal;
import de.teamlapen.vampirism.entity.hunter.HunterBaseEntity;
import de.teamlapen.vampirism.entity.vampire.VampireBaseEntity;
import de.teamlapen.vampirism.items.CrossbowArrowItem;
import de.teamlapen.vampirism.util.IPlayerOverlay;
import de.teamlapen.vampirism.util.PlayerModelType;
import de.teamlapen.vampirism.util.SupporterManager;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.StructureTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.OpenDoorGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.PatrollingMonster;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.entity.SkullBlockEntity;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.common.CommonHooks;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AdvancedHunterEntity
extends HunterBaseEntity
implements IAdvancedHunter,
IPlayerOverlay,
IEntityActionUser,
VampireBookLootProvider,
IVampirismCrossbowUser {
    private static final EntityDataAccessor<Integer> LEVEL = SynchedEntityData.defineId(AdvancedHunterEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> TYPE = SynchedEntityData.defineId(AdvancedHunterEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<String> NAME = SynchedEntityData.defineId(AdvancedHunterEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    private static final EntityDataAccessor<String> TEXTURE = SynchedEntityData.defineId(AdvancedHunterEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    private static final EntityDataAccessor<Boolean> IS_CHARGING_CROSSBOW = SynchedEntityData.defineId(AdvancedHunterEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final int MAX_LEVEL = 1;
    private static final int MOVE_TO_RESTRICT_PRIO = 3;
    @NotNull
    private final ActionHandlerEntity<?> entityActionHandler;
    private final EntityClassType entityclass;
    @NotNull
    private final EntityActionTier entitytier;
    @Nullable
    private Pair<ResourceLocation, PlayerModelType> skinDetails;
    @Nullable
    private Optional<GameProfile> skinProfile;
    @Nullable
    private String lootBookId;
    private boolean attack;
    @Nullable
    private ICaptureAttributes villageAttributes;

    public static // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull AttributeSupplier.Builder getAttributeBuilder() {
        AttributeSupplier.Builder builder = VampirismEntity.getAttributeBuilder();
        Objects.requireNonNull(BalanceMobProps.mobProps);
        AttributeSupplier.Builder builder2 = builder.add(Attributes.MAX_HEALTH, 60.0);
        Objects.requireNonNull(BalanceMobProps.mobProps);
        AttributeSupplier.Builder builder3 = builder2.add(Attributes.ATTACK_DAMAGE, 1.0);
        Objects.requireNonNull(BalanceMobProps.mobProps);
        return builder3.add(Attributes.MOVEMENT_SPEED, 0.285);
    }

    public AdvancedHunterEntity(EntityType<? extends AdvancedHunterEntity> type, Level world) {
        super(type, world, true);
        this.saveHome = true;
        ((GroundPathNavigation)this.getNavigation()).setCanOpenDoors(true);
        this.setDontDropEquipment();
        this.entitytier = EntityActionTier.High;
        this.entityclass = EntityClassType.getRandomClass(this.getRandom());
        IEntityActionUser.applyAttributes(this);
        this.entityActionHandler = new ActionHandlerEntity<AdvancedHunterEntity>(this);
        this.enableImobConversion();
    }

    @Override
    public void addAdditionalSaveData(@NotNull CompoundTag nbt) {
        super.addAdditionalSaveData(nbt);
        nbt.putInt("level", this.getEntityLevel());
        nbt.putInt("type", this.getHunterType());
        nbt.putString("texture", (String)this.getEntityData().get(TEXTURE));
        nbt.putString("name", (String)this.getEntityData().get(NAME));
        nbt.putInt("entityclasstype", EntityClassType.getID(this.entityclass));
        if (this.entityActionHandler != null) {
            this.entityActionHandler.write(nbt);
        }
        nbt.putBoolean("attack", this.attack);
        if (this.lootBookId != null) {
            nbt.putString("lootBookId", this.lootBookId);
        }
    }

    @Override
    public void attackVillage(ICaptureAttributes attributes) {
        this.villageAttributes = attributes;
        this.attack = true;
    }

    @Override
    public void aiStep() {
        super.aiStep();
        if (this.entityActionHandler != null) {
            this.entityActionHandler.handle();
        }
    }

    @Override
    public void defendVillage(ICaptureAttributes attributes) {
        this.villageAttributes = attributes;
        this.attack = false;
    }

    @Override
    public ActionHandlerEntity<?> getActionHandler() {
        return this.entityActionHandler;
    }

    public boolean doHurtTarget(@NotNull Entity entity) {
        boolean flag = super.doHurtTarget(entity);
        if (flag && this.getMainHandItem().isEmpty()) {
            this.swing(InteractionHand.MAIN_HAND);
        }
        return flag;
    }

    @Override
    @NotNull
    public Optional<String> getBookLootId() {
        return Optional.ofNullable(this.lootBookId);
    }

    @Override
    @Nullable
    public ICaptureAttributes getCaptureInfo() {
        return this.villageAttributes;
    }

    @Override
    public EntityClassType getEntityClass() {
        return this.entityclass;
    }

    @Override
    public EntityActionTier getEntityTier() {
        return this.entitytier;
    }

    @Override
    public int getHunterType() {
        return (Integer)this.getEntityData().get(TYPE);
    }

    @Override
    public int getEntityLevel() {
        return (Integer)this.getEntityData().get(LEVEL);
    }

    @Override
    public void setEntityLevel(int level) {
        if (level >= 0) {
            this.getEntityData().set(LEVEL, (Object)level);
            this.updateEntityAttributes();
            if (level == 1) {
                this.addEffect(new MobEffectInstance(MobEffects.DAMAGE_RESISTANCE, 1000000, 1, false, false));
            }
        }
    }

    @Override
    public int getMaxEntityLevel() {
        return 1;
    }

    @NotNull
    public Component getName() {
        String senderName = (String)this.getEntityData().get(NAME);
        return "none".equals(senderName) ? super.getName() : Component.literal((String)senderName);
    }

    @Override
    @NotNull
    public Optional<Pair<ResourceLocation, PlayerModelType>> getOverlayPlayerProperties() {
        if (this.skinDetails == null) {
            String name = this.getTextureName();
            if (name == null) {
                return Optional.empty();
            }
            VampirismMod.proxy.obtainPlayerSkins(new GameProfile(Util.NIL_UUID, name), p -> {
                this.skinDetails = p;
            });
            this.skinDetails = PENDING_PROP;
        }
        return Optional.of(this.skinDetails);
    }

    @Override
    @NotNull
    public Optional<GameProfile> getPlayerOverlay() {
        if (this.skinProfile == null) {
            String name = this.getTextureName();
            if (name == null) {
                return Optional.empty();
            }
            this.skinProfile = Optional.empty();
            SkullBlockEntity.fetchGameProfile((String)name).thenAccept(p -> {
                this.skinProfile = p;
            });
        }
        return this.skinProfile;
    }

    @Override
    @Nullable
    public AABB getTargetVillageArea() {
        return this.villageAttributes == null ? null : this.villageAttributes.getVillageArea();
    }

    @Override
    @Nullable
    public String getTextureName() {
        String texture = (String)this.getEntityData().get(TEXTURE);
        return "none".equals(texture) ? null : texture;
    }

    @Override
    public boolean isAttackingVillage() {
        return this.villageAttributes != null && this.attack;
    }

    @Override
    public boolean isDefendingVillage() {
        return this.villageAttributes != null && !this.attack;
    }

    @Override
    public boolean isLookingForHome() {
        return this.getHome() == null;
    }

    @Override
    public void readAdditionalSaveData(@NotNull CompoundTag tagCompund) {
        super.readAdditionalSaveData(tagCompund);
        if (tagCompund.contains("level")) {
            this.setEntityLevel(tagCompund.getInt("level"));
        }
        if (tagCompund.contains("type")) {
            this.getEntityData().set(TYPE, (Object)tagCompund.getInt("type"));
            this.getEntityData().set(NAME, (Object)tagCompund.getString("name"));
            this.getEntityData().set(TEXTURE, (Object)tagCompund.getString("texture"));
        }
        if (this.entityActionHandler != null) {
            this.entityActionHandler.read(tagCompund);
        }
        if (tagCompund.contains("attack")) {
            this.attack = tagCompund.getBoolean("attack");
        }
        if (tagCompund.contains("lootBookId")) {
            this.lootBookId = tagCompund.getString("lootBookId");
        }
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return super.removeWhenFarAway(distanceToClosestPlayer) && this.isLookingForHome();
    }

    @Override
    public void setCampArea(AABB box) {
        super.setHome(box);
        this.setMoveTowardsRestriction(3, true);
    }

    @Override
    public void stopVillageAttackDefense() {
        this.setCustomName(null);
        this.villageAttributes = null;
    }

    public boolean shouldShowName() {
        return true;
    }

    @Override
    public int suggestEntityLevel(@NotNull Difficulty d) {
        if (this.random.nextBoolean()) {
            return (int)((float)(d.avgPercLevel() * 1) / 100.0f);
        }
        return this.random.nextInt(2);
    }

    protected void defineSynchedData(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(LEVEL, (Object)-1);
        builder.define(TYPE, (Object)0);
        builder.define(NAME, (Object)"none");
        builder.define(TEXTURE, (Object)"none");
        builder.define(IS_CHARGING_CROSSBOW, (Object)false);
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData) {
        Supporter supporter = SupporterManager.getRandomHunter(this.random);
        this.getEntityData().set(TYPE, (Object)AdvancedHunterEntity.createCustomisationFlag(supporter));
        this.getEntityData().set(NAME, (Object)supporter.name());
        this.getEntityData().set(TEXTURE, (Object)supporter.texture());
        this.lootBookId = supporter.bookId();
        this.applyCustomisationItems(supporter);
        return super.finalizeSpawn(pLevel, pDifficulty, pReason, pSpawnData);
    }

    private void applyCustomisationItems(Supporter supporter) {
        Map<String, String> appearance = supporter.appearance();
        HunterBaseEntity.EquipmentType equipment = Optional.ofNullable(appearance.get("equipment")).map(HunterBaseEntity.EquipmentType::get).orElseGet(() -> {
            HunterBaseEntity.EquipmentType[] types = HunterBaseEntity.EquipmentType.values();
            return types[this.random.nextInt(types.length)];
        });
        this.setLeftHanded(false);
        this.setItemSlot(EquipmentSlot.MAINHAND, equipment.getMainHand());
        this.setItemSlot(EquipmentSlot.OFFHAND, equipment.getOffHand());
        HunterBaseEntity.HatType hat = Optional.ofNullable(appearance.get("hat")).map(HunterBaseEntity.HatType::get).orElseGet(() -> {
            HunterBaseEntity.HatType[] types = HunterBaseEntity.HatType.values();
            return types[this.random.nextInt(types.length)];
        });
        this.setItemSlot(EquipmentSlot.HEAD, hat.getHeadItem());
        this.setDontDropEquipment();
    }

    private static int createCustomisationFlag(Supporter supporter) {
        Map<String, String> appearance = supporter.appearance();
        int type = 0;
        type |= Boolean.parseBoolean(appearance.getOrDefault("hasCloak", "true")) & true;
        return type |= (Integer.parseInt(appearance.getOrDefault("body", "13")) & 0xFF) << 1;
    }

    protected int getBaseExperienceReward() {
        this.xpReward = 10 * (1 + this.getEntityLevel());
        return super.getBaseExperienceReward();
    }

    @Override
    @NotNull
    protected EntityType<?> getIMobTypeOpt(boolean iMob) {
        return iMob ? (EntityType)ModEntities.ADVANCED_HUNTER_IMOB.get() : (EntityType)ModEntities.ADVANCED_HUNTER.get();
    }

    @NotNull
    protected InteractionResult mobInteract(@NotNull Player player, @NotNull InteractionHand hand) {
        if (hand == InteractionHand.MAIN_HAND && this.tryCureSanguinare(player)) {
            return InteractionResult.SUCCESS;
        }
        return super.mobInteract(player, hand);
    }

    @Nonnull
    public ItemStack getProjectile(ItemStack stack) {
        if (stack.getItem() instanceof IVampirismCrossbow) {
            return CommonHooks.getProjectile((LivingEntity)this, (ItemStack)stack, (ItemStack)((CrossbowArrowItem)ModItems.CROSSBOW_ARROW_NORMAL.get()).getDefaultInstance());
        }
        return super.getProjectile(stack);
    }

    @Override
    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, (Goal)new OpenDoorGoal((Mob)this, true));
        this.goalSelector.addGoal(2, new RangedHunterCrossbowAttackGoal<AdvancedHunterEntity>(this, 0.8, 100.0f));
        this.goalSelector.addGoal(3, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.goalSelector.addGoal(6, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.7, 50));
        this.goalSelector.addGoal(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 13.0f));
        this.goalSelector.addGoal(8, (Goal)new LookAtPlayerGoal((Mob)this, VampireBaseEntity.class, 17.0f));
        this.goalSelector.addGoal(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(2, new AttackVillageGoal<AdvancedHunterEntity>(this));
        this.targetSelector.addGoal(2, new DefendVillageGoal<AdvancedHunterEntity>(this));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 5, true, false, VampirismAPI.factionRegistry().getPredicate(this.getFaction(), true, false, false, false, null)));
        this.targetSelector.addGoal(5, (Goal)new NearestAttackableTargetGoal((Mob)this, PathfinderMob.class, 5, true, false, VampirismAPI.factionRegistry().getPredicate(this.getFaction(), false, true, false, false, null)));
        this.targetSelector.addGoal(6, (Goal)new NearestAttackableTargetGoal((Mob)this, Zombie.class, true, true));
        this.targetSelector.addGoal(7, (Goal)new NearestAttackableTargetGoal((Mob)this, PatrollingMonster.class, 5, true, true, living -> UtilLib.isInsideStructure((Entity)living, (TagKey<Structure>)StructureTags.VILLAGE)));
    }

    protected void updateEntityAttributes() {
        int l = Math.max(this.getEntityLevel(), 0);
        AttributeInstance attributeInstance = this.getAttribute(Attributes.MAX_HEALTH);
        Objects.requireNonNull(BalanceMobProps.mobProps);
        attributeInstance.setBaseValue(60.0 + (double)BalanceMobProps.mobProps.SANGUINARE_AVG_DURATION * (double)l);
        AttributeInstance attributeInstance2 = this.getAttribute(Attributes.ATTACK_DAMAGE);
        Objects.requireNonNull(BalanceMobProps.mobProps);
        Objects.requireNonNull(BalanceMobProps.mobProps);
        attributeInstance2.setBaseValue(1.0 + 1.0 * (double)l);
    }

    @Override
    public boolean isHoldingCrossbow() {
        return this.isHolding(stack -> stack.getItem() instanceof IVampirismCrossbow);
    }

    @Override
    public boolean isChargingCrossbow() {
        return (Boolean)this.getEntityData().get(IS_CHARGING_CROSSBOW);
    }

    public void setChargingCrossbow(boolean pChargingCrossbow) {
        this.getEntityData().set(IS_CHARGING_CROSSBOW, (Object)pChargingCrossbow);
    }

    public void onCrossbowAttackPerformed() {
        this.noActionTime = 0;
    }

    public void performRangedAttack(@NotNull LivingEntity pTarget, float pVelocity) {
        this.performCrossbowAttack((LivingEntity)this, 1.6f);
    }

    public static class IMob
    extends AdvancedHunterEntity
    implements Enemy {
        public IMob(EntityType<? extends AdvancedHunterEntity> type, Level world) {
            super(type, world);
        }
    }
}

