/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.converted;

import de.teamlapen.vampirism.api.entity.convertible.IConvertedCreature;
import de.teamlapen.vampirism.api.entity.convertible.IConvertingHandler;
import de.teamlapen.vampirism.core.ModEntities;
import de.teamlapen.vampirism.datamaps.ConverterEntry;
import de.teamlapen.vampirism.entity.converted.ConvertedCreatureEntity;
import de.teamlapen.vampirism.entity.converted.VampirismEntityRegistry;
import de.teamlapen.vampirism.util.Helper;
import java.util.Objects;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.FloatProvider;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.DefaultAttributes;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultConvertingHandler<T extends PathfinderMob>
implements IConvertingHandler<T> {
    private static final Logger LOGGER = LogManager.getLogger();
    @NotNull
    protected final IConvertingHandler.IDefaultHelper helper;
    @Nullable
    protected final ResourceLocation overlayTexture;

    public DefaultConvertingHandler(@Nullable IConvertingHandler.IDefaultHelper helper, @Nullable ResourceLocation overlayTexture) {
        this.helper = Objects.requireNonNullElse(helper, new VampirismEntityRegistry.DefaultHelper(ConverterEntry.ConvertingAttributeModifier.DEFAULT));
        this.overlayTexture = overlayTexture;
    }

    @Override
    @Nullable
    public IConvertedCreature<T> createFrom(@NotNull T entity) {
        return Helper.createEntity((EntityType)ModEntities.CONVERTED_CREATURE.get(), entity.getCommandSenderWorld()).map(convertedCreature -> {
            this.copyImportantStuff((ConvertedCreatureEntity<T>)convertedCreature, entity);
            convertedCreature.setUUID(Mth.createInsecureUUID((RandomSource)convertedCreature.getRandom()));
            convertedCreature.addEffect(new MobEffectInstance(MobEffects.WEAKNESS, 200, 2));
            convertedCreature.getSourceEntityDataParamOpt().ifPresent(s -> convertedCreature.getRepresentingEntity().getEntityData().set(s, (Object)BuiltInRegistries.ENTITY_TYPE.getKey((Object)entity.getType()).toString()));
            return convertedCreature;
        }).orElse(null);
    }

    @NotNull
    public IConvertingHandler.IDefaultHelper getHelper() {
        return this.helper;
    }

    protected void copyImportantStuff(@NotNull ConvertedCreatureEntity<T> converted, @NotNull T entity) {
        converted.copyPosition((Entity)entity);
        converted.setEntityCreature(entity);
        this.updateEntityAttributes(converted);
        converted.setHealth(converted.getMaxHealth() / 3.0f * 2.0f);
        converted.yBodyRot = ((PathfinderMob)entity).yBodyRot;
        converted.yHeadRot = ((PathfinderMob)entity).yHeadRot;
    }

    @Override
    public void updateEntityAttributes(PathfinderMob creature) {
        try {
            this.helper.getAttributeModifier().forEach((attribute, valueProvider) -> {
                AttributeSupplier supplier = DefaultAttributes.getSupplier((EntityType)creature.getType());
                if (supplier.hasAttribute(attribute)) {
                    creature.getAttribute(attribute).setBaseValue(supplier.getBaseValue(attribute) * (double)((FloatProvider)valueProvider.getFirst()).sample(creature.getRandom()));
                }
            });
        }
        catch (NullPointerException ex) {
            LOGGER.error("Failed to update entity attributes for {} {}", (Object)creature, (Object)ex);
        }
    }
}

