/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.converted;

import de.teamlapen.vampirism.config.BalanceMobProps;
import de.teamlapen.vampirism.core.ModAttributes;
import de.teamlapen.vampirism.entity.converted.CurableConvertedCreature;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import org.jetbrains.annotations.NotNull;

public class ConvertedSheepEntity
extends Sheep
implements CurableConvertedCreature<Sheep, ConvertedSheepEntity> {
    private static final EntityDataAccessor<Boolean> CONVERTING = SynchedEntityData.defineId(ConvertedSheepEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<String> OVERLAY_TEXTURE = SynchedEntityData.defineId(ConvertedSheepEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    private final CurableConvertedCreature.Data<Sheep> data = new CurableConvertedCreature.Data();

    public ConvertedSheepEntity(EntityType<? extends ConvertedSheepEntity> type, Level world) {
        super(type, world);
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull AttributeSupplier.Builder getAttributeBuilder() {
        AttributeSupplier.Builder builder = Sheep.createAttributes();
        Objects.requireNonNull(BalanceMobProps.mobProps);
        AttributeSupplier.Builder builder2 = builder.add(Attributes.ATTACK_DAMAGE, 1.0);
        Objects.requireNonNull(BalanceMobProps.mobProps);
        return builder2.add(ModAttributes.SUNDAMAGE, 7.0);
    }

    public static boolean checkConvertedSheepSpawnRules(EntityType<? extends Animal> pGoat, LevelAccessor pLevel, MobSpawnType pSpawnType, BlockPos pPos, RandomSource pRandom) {
        return pLevel.getDifficulty() != Difficulty.PEACEFUL && Sheep.checkAnimalSpawnRules(pGoat, (LevelAccessor)pLevel, (MobSpawnType)pSpawnType, (BlockPos)pPos, (RandomSource)pRandom);
    }

    @Override
    @NotNull
    public EntityDataAccessor<Boolean> getConvertingDataParam() {
        return CONVERTING;
    }

    @Override
    @NotNull
    public EntityDataAccessor<String> getSourceEntityDataParam() {
        return OVERLAY_TEXTURE;
    }

    @Override
    public CurableConvertedCreature.Data<Sheep> data() {
        return this.data;
    }

    @Override
    public void handleEntityEventSuper(byte id) {
        super.handleEntityEvent(id);
    }

    @Override
    public InteractionResult mobInteractSuper(@NotNull Player player, @NotNull InteractionHand hand) {
        return super.mobInteract(player, hand);
    }

    @Override
    public boolean hurtSuper(DamageSource damageSource, float amount) {
        return super.hurt(damageSource, amount);
    }

    public void addAdditionalSaveData(@NotNull CompoundTag pCompound) {
        super.addAdditionalSaveData(pCompound);
        this.addAdditionalSaveDataC(pCompound);
    }

    public void aiStep() {
        this.aiStepC(EntityType.SHEEP);
        super.aiStep();
    }

    public void die(@NotNull DamageSource pDamageSource) {
        super.die(pDamageSource);
        this.dieC(pDamageSource);
    }

    @NotNull
    public Component getTypeName() {
        return this.getNameC(() -> ((EntityType)EntityType.SHEEP).getDescription());
    }

    public boolean hurt(@NotNull DamageSource pSource, float pAmount) {
        return this.hurtC(pSource, pAmount);
    }

    @NotNull
    public InteractionResult mobInteract(@NotNull Player pPlayer, @NotNull InteractionHand pHand) {
        return this.mobInteractC(pPlayer, pHand);
    }

    public void readAdditionalSaveData(@NotNull CompoundTag pCompound) {
        super.readAdditionalSaveData(pCompound);
        this.readAdditionalSaveDataC(pCompound);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        this.registerConvertingData(builder);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.registerGoalsC();
    }

    protected void tickDeath() {
        super.tickDeath();
        this.tickDeathC();
    }

    public void tick() {
        super.tick();
        this.tickC();
    }
}

