/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.ai.goals;

import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public abstract class MoveToPositionGoal<T extends PathfinderMob>
extends Goal {
    protected final T entity;
    @NotNull
    protected final LevelReader world;
    private final double followSpeed;
    @NotNull
    private final PathNavigation navigator;
    private final float minDist;
    private final float maxDist;
    private final boolean doTeleport;
    private final boolean look;
    private int timeToRecalcPath;
    private float oldWaterCost;

    public MoveToPositionGoal(@NotNull T entity, double followSpeed, float minDist, float maxDist, boolean doTeleport, boolean look) {
        this.entity = entity;
        this.world = entity.getCommandSenderWorld();
        this.followSpeed = followSpeed;
        this.minDist = minDist;
        this.navigator = entity.getNavigation();
        this.maxDist = maxDist;
        this.doTeleport = doTeleport;
        this.look = look;
        this.setFlags(look ? EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP) : EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP));
        if (!(entity.getNavigation() instanceof GroundPathNavigation) && !(entity.getNavigation() instanceof FlyingPathNavigation)) {
            throw new IllegalArgumentException("Unsupported mob type for MoveToPositionGoal");
        }
    }

    public boolean canContinueToUse() {
        return this.getTargetPosition().distSqr((Vec3i)this.entity.blockPosition()) > (double)(this.minDist * this.minDist);
    }

    public boolean canUse() {
        return this.getTargetPosition().distSqr((Vec3i)this.entity.blockPosition()) > (double)(this.minDist * this.minDist);
    }

    public void start() {
        this.timeToRecalcPath = 0;
        this.oldWaterCost = this.entity.getPathfindingMalus(PathType.WATER);
        this.entity.setPathfindingMalus(PathType.WATER, 0.0f);
    }

    public void stop() {
        this.navigator.stop();
        this.entity.setPathfindingMalus(PathType.WATER, this.oldWaterCost);
    }

    public void tick() {
        Vec3i target = this.getTargetPosition();
        if (this.look) {
            this.entity.getLookControl().setLookAt(this.getLookPosition());
        }
        if (--this.timeToRecalcPath <= 0) {
            this.timeToRecalcPath = 10;
            boolean flag = this.navigator.moveTo((double)target.getX(), (double)target.getY(), (double)target.getZ(), this.followSpeed);
            if (!(!this.doTeleport || flag && this.entity.getRandom().nextInt(8) != 0 || this.entity.distanceToSqr((double)target.getX(), (double)target.getY(), (double)target.getZ()) < (double)(this.maxDist * this.maxDist))) {
                int sX = target.getX() - 2;
                int sZ = target.getZ() - 2;
                int sY = target.getY();
                for (int dX = 0; dX <= 4; ++dX) {
                    for (int dZ = 0; dZ <= 4; ++dZ) {
                        if (dX >= 1 && dZ >= 1 && dX <= 3 && dZ <= 3 || !this.canTeleportToBlock(new BlockPos(sX + dX, sY - 1, sZ + dZ))) continue;
                        this.entity.moveTo((double)((float)(sX + dX) + 0.5f), (double)sY, (double)((float)(sZ + dZ) + 0.5f), this.entity.getYRot(), this.entity.getXRot());
                        this.navigator.stop();
                        return;
                    }
                }
            }
        }
    }

    protected boolean canTeleportToBlock(@NotNull BlockPos pos) {
        BlockState blockstate = this.world.getBlockState(pos);
        return blockstate.isValidSpawn((BlockGetter)this.world, pos, this.entity.getType()) && this.world.isEmptyBlock(pos.above()) && this.world.isEmptyBlock(pos.above(2));
    }

    protected abstract Vec3 getLookPosition();

    protected abstract Vec3i getTargetPosition();
}

