/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.ai.goals;

import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FleeGoal
extends Goal {
    private final PathfinderMob theCreature;
    private final double movementSpeed;
    @NotNull
    private final Level world;
    private final boolean restrictToHome;
    private double shelterX;
    private double shelterY;
    private double shelterZ;

    public FleeGoal(@NotNull PathfinderMob theCreature, double movementSpeed, boolean restrictToHome) {
        this.theCreature = theCreature;
        this.movementSpeed = movementSpeed;
        this.restrictToHome = restrictToHome;
        this.world = theCreature.getCommandSenderWorld();
        this.setFlags(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean canUse() {
        if (!this.shouldFlee()) {
            return false;
        }
        Vec3 vec3 = this.findPossibleShelter();
        if (vec3 == null) {
            return false;
        }
        this.shelterX = vec3.x;
        this.shelterY = vec3.y;
        this.shelterZ = vec3.z;
        return true;
    }

    public boolean continueExecuting() {
        return !this.theCreature.getNavigation().isDone();
    }

    public void start() {
        this.theCreature.getNavigation().moveTo(this.shelterX, this.shelterY, this.shelterZ, this.movementSpeed);
    }

    protected abstract boolean isPositionAcceptable(Level var1, BlockPos var2);

    protected abstract boolean shouldFlee();

    @Nullable
    private Vec3 findPossibleShelter() {
        RandomSource random = this.theCreature.getRandom();
        BlockPos blockpos = new BlockPos((int)this.theCreature.getX(), (int)this.theCreature.getBoundingBox().minY, (int)this.theCreature.getZ());
        for (int i = 0; i < 10; ++i) {
            BlockPos blockpos1 = blockpos.offset(random.nextInt(20) - 10, random.nextInt(6) - 3, random.nextInt(20) - 10);
            if (!this.isPositionAcceptable(this.world, blockpos1) || this.restrictToHome && !this.theCreature.getRestrictCenter().equals((Object)BlockPos.ZERO) && !this.theCreature.isWithinRestriction(blockpos1)) continue;
            return new Vec3((double)blockpos1.getX(), (double)blockpos1.getY(), (double)blockpos1.getZ());
        }
        return null;
    }
}

