/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.ai.goals;

import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.entity.IVillageCaptureEntity;
import de.teamlapen.vampirism.api.entity.factions.IFactionEntity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefendVillageGoal<T extends PathfinderMob>
extends TargetGoal {
    @NotNull
    private final T creature;
    @NotNull
    protected final TargetingConditions entityPredicate;
    private final double distance = this.getFollowDistance() * 4.0;

    public DefendVillageGoal(@NotNull T creature) {
        super(creature, false, false);
        this.creature = creature;
        this.entityPredicate = new TargetingConditions(true, (PathfinderMob)creature){
            final /* synthetic */ PathfinderMob val$creature;
            {
                this.val$creature = pathfinderMob;
                super(arg0);
            }

            public boolean test(@Nullable LivingEntity attackEntity, @NotNull LivingEntity targetEntity) {
                if (((IVillageCaptureEntity)this.val$creature).getCaptureInfo() != null && ((IVillageCaptureEntity)this.val$creature).getCaptureInfo().shouldForceTargets() && DefendVillageGoal.this.getFollowDistance() > 0.0) {
                    this.range(-1.0);
                } else if (DefendVillageGoal.this.getFollowDistance() < 0.0) {
                    this.range(DefendVillageGoal.this.distance);
                }
                return super.test(attackEntity, targetEntity);
            }
        }.selector(VampirismAPI.factionRegistry().getPredicate(((IFactionEntity)creature).getFaction(), false)).ignoreInvisibilityTesting();
    }

    public boolean canUse() {
        if (!((IVillageCaptureEntity)this.creature).isDefendingVillage()) {
            return false;
        }
        this.targetMob = this.creature.level().getNearestEntity(LivingEntity.class, this.entityPredicate, (LivingEntity)this.mob, this.mob.getX(), this.mob.getY() + (double)this.mob.getEyeHeight(), this.mob.getZ(), ((IVillageCaptureEntity)this.creature).getTargetVillageArea());
        return this.targetMob != null;
    }

    public void start() {
        this.creature.setTarget(this.targetMob);
        super.start();
    }
}

