/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.ai.goals;

import de.teamlapen.vampirism.api.entity.IExtendedCreatureVampirism;
import de.teamlapen.vampirism.api.entity.vampire.IVampire;
import de.teamlapen.vampirism.core.ModSounds;
import de.teamlapen.vampirism.entity.ExtendedCreature;
import de.teamlapen.vampirism.entity.vampire.DrinkBloodContext;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BiteNearbyEntityVampireGoal<T extends Mob>
extends Goal {
    private final T vampire;
    @Nullable
    private IExtendedCreatureVampirism creature;
    private int timer;

    public BiteNearbyEntityVampireGoal(T vampire) {
        this.vampire = vampire;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean canContinueToUse() {
        return this.timer > 0 && this.creature.getEntity().isAlive() && this.creature.getEntity().getBoundingBox().intersects(this.getBiteBoundingBox());
    }

    public boolean canUse() {
        if (((IVampire)this.vampire).wantsBlood()) {
            List list = this.vampire.getCommandSenderWorld().getEntitiesOfClass(PathfinderMob.class, this.getBiteBoundingBox(), EntitySelector.NO_SPECTATORS.and(entity -> entity != this.vampire && entity.isAlive()));
            if (list.size() > 1) {
                try {
                    list.sort((o1, o2) -> (int)(this.vampire.distanceToSqr((Entity)o1) - this.vampire.distanceToSqr((Entity)o2)));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            for (PathfinderMob o : list) {
                if (!this.vampire.getSensing().hasLineOfSight((Entity)o) || o.hasCustomName() || !ExtendedCreature.getSafe((Entity)o).filter(this::canFeed).map(creature -> {
                    this.creature = creature;
                    return true;
                }).orElse(false).booleanValue()) continue;
                return true;
            }
        }
        this.creature = null;
        return false;
    }

    public void start() {
        this.timer = 20 + this.vampire.getRandom().nextInt(20);
    }

    public void stop() {
        this.creature = null;
    }

    public void tick() {
        PathfinderMob e = this.creature.getEntity();
        this.vampire.lookAt(EntityAnchorArgument.Anchor.EYES, new Vec3(e.getX(), e.getY() + (double)e.getEyeHeight(), e.getZ()));
        --this.timer;
        if (this.timer == 1 && this.canFeed(this.creature)) {
            int amount = this.creature.onBite((IVampire)this.vampire);
            this.vampire.playSound((SoundEvent)ModSounds.VAMPIRE_BITE.get(), 1.0f, 1.0f);
            ((IVampire)this.vampire).drinkBlood(amount, this.creature.getBloodSaturation(), new DrinkBloodContext((LivingEntity)e));
        }
    }

    protected boolean canFeed(@NotNull IExtendedCreatureVampirism entity) {
        return entity.canBeBitten((IVampire)this.vampire) && !entity.hasPoisonousBlood() && (!(entity.getEntity() instanceof Villager) || (float)entity.getBlood() > (float)entity.getMaxBlood() / 2.0f);
    }

    @NotNull
    protected AABB getBiteBoundingBox() {
        return this.vampire.getBoundingBox().inflate(0.5, 0.7, 0.5);
    }
}

