/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity;

import de.teamlapen.vampirism.core.ModEntities;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class ThrowableItemEntity
extends ThrowableProjectile
implements ItemSupplier {
    private static final Logger LOGGER = LogManager.getLogger(ThrowableItemEntity.class);
    private static final EntityDataAccessor<ItemStack> ITEM = SynchedEntityData.defineId(ThrowableItemEntity.class, (EntityDataSerializer)EntityDataSerializers.ITEM_STACK);

    public ThrowableItemEntity(@NotNull EntityType<? extends ThrowableItemEntity> type, @NotNull Level worldIn) {
        super(type, worldIn);
    }

    public ThrowableItemEntity(@NotNull Level worldIn, @NotNull LivingEntity thrower) {
        super((EntityType)ModEntities.THROWABLE_ITEM.get(), thrower, worldIn);
    }

    public void addAdditionalSaveData(@NotNull CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        ItemStack stack = this.getItem();
        if (!stack.isEmpty()) {
            compound.put("thrownItem", stack.save((HolderLookup.Provider)this.registryAccess(), (Tag)new CompoundTag()));
        }
    }

    @NotNull
    public ItemStack getItem() {
        return (ItemStack)this.getEntityData().get(ITEM);
    }

    public void setItem(@NotNull ItemStack stack) {
        if (!stack.isEmpty() && !(stack.getItem() instanceof IVampirismThrowableItem)) {
            throw new IllegalArgumentException("EntityThrowable only accepts IVampirismThrowableItem, but not " + String.valueOf(stack));
        }
        this.getEntityData().set(ITEM, (Object)stack);
    }

    public void readAdditionalSaveData(@NotNull CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        ItemStack stack = ItemStack.parseOptional((HolderLookup.Provider)this.registryAccess(), (CompoundTag)compound.getCompound("thrownItem"));
        if (stack.isEmpty()) {
            this.discard();
        } else {
            this.setItem(stack);
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(ITEM, (Object)ItemStack.EMPTY);
    }

    protected double getDefaultGravity() {
        return 0.05;
    }

    protected void onHit(@NotNull HitResult result) {
        ItemStack stack = this.getItem();
        if (!stack.isEmpty()) {
            Item item = stack.getItem();
            if (item instanceof IVampirismThrowableItem) {
                ((IVampirismThrowableItem)item).onImpact(this, stack, result, this.level().isClientSide);
            } else {
                LOGGER.warn("Saved item ({}) is not an instance of IVampirismThrowableItem. This should not be able to happen", (Object)stack);
            }
        }
        if (!this.level().isClientSide) {
            this.discard();
        }
    }

    public static interface IVampirismThrowableItem {
        public void onImpact(ThrowableItemEntity var1, ItemStack var2, HitResult var3, boolean var4);
    }
}

