/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity;

import de.teamlapen.vampirism.api.VEnums;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.difficulty.Difficulty;
import de.teamlapen.vampirism.api.difficulty.IAdjustableLevel;
import de.teamlapen.vampirism.api.entity.IExtendedCreatureVampirism;
import de.teamlapen.vampirism.api.items.oil.IApplicableOil;
import de.teamlapen.vampirism.api.items.oil.IWeaponOil;
import de.teamlapen.vampirism.blockentity.TotemBlockEntity;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.core.ModTags;
import de.teamlapen.vampirism.entity.ExtendedCreature;
import de.teamlapen.vampirism.entity.ai.goals.GolemTargetNonVillageFactionGoal;
import de.teamlapen.vampirism.entity.ai.goals.NearestTargetGoalModifier;
import de.teamlapen.vampirism.entity.minion.MinionEntity;
import de.teamlapen.vampirism.entity.player.VampirismPlayerAttributes;
import de.teamlapen.vampirism.entity.player.vampire.VampirePlayer;
import de.teamlapen.vampirism.items.VampireSwordItem;
import de.teamlapen.vampirism.items.oil.EvasionOil;
import de.teamlapen.vampirism.mixin.accessor.GoalSelectorAccessor;
import de.teamlapen.vampirism.mixin.accessor.NearestAttackableTargetGoalAccessor;
import de.teamlapen.vampirism.util.DifficultyCalculator;
import de.teamlapen.vampirism.util.Helper;
import de.teamlapen.vampirism.util.OilUtils;
import de.teamlapen.vampirism.util.TotemHelper;
import it.unimi.dsi.fastutil.objects.Object2BooleanArrayMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.AbstractSkeleton;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.monster.Stray;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.damagesource.DamageContainer;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.living.FinalizeSpawnEvent;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingEquipmentChangeEvent;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforge.event.entity.player.AttackEntityEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class ModEntityEventHandler {
    private static final Logger LOGGER = LogManager.getLogger(ModEntityEventHandler.class);
    private static final Object2BooleanMap<String> entityAIReplacementWarnMap = new Object2BooleanArrayMap();
    private final Set<ResourceLocation> unknownZombies = new HashSet<ResourceLocation>();
    private boolean warnAboutGolem = true;

    public static <T extends Mob, S extends LivingEntity, Q extends NearestAttackableTargetGoal<S>> void makeVampireFriendly(String name, @NotNull T e, @NotNull Class<Q> targetClass, @NotNull Class<S> targetEntityClass, int attackPriority, @NotNull Predicate<EntityType<? extends T>> typeCheck) {
        Goal target = null;
        for (WrappedGoal t : ((GoalSelectorAccessor)e.targetSelector).getAvailableGoals()) {
            Goal g = t.getGoal();
            if (!targetClass.equals(g.getClass()) || t.getPriority() != attackPriority || !targetEntityClass.equals(((NearestAttackableTargetGoalAccessor)g).getTargetType())) continue;
            target = g;
            break;
        }
        if (target != null) {
            EntityType type = e.getType();
            if (typeCheck.test(type)) {
                ((NearestTargetGoalModifier)target).ignoreVampires();
            }
        } else if (entityAIReplacementWarnMap.getOrDefault((Object)name, true)) {
            LOGGER.warn("Could not modify {} attack target task for {}", (Object)name, (Object)e.getType().getDescription());
            entityAIReplacementWarnMap.put((Object)name, false);
        }
    }

    @SubscribeEvent
    public void onFinalizeSpawn(@NotNull FinalizeSpawnEvent event) {
        BlockPos pos = new BlockPos((int)(event.getX() - (double)0.6f), (int)event.getY(), (int)(event.getZ() - (double)0.6f)).below();
        if (!event.getLevel().hasChunkAt(pos)) {
            return;
        }
        BlockState blockState = event.getLevel().getBlockState(pos);
        if (blockState.is(ModTags.Blocks.NO_SPAWN) || blockState.is(ModTags.Blocks.VAMPIRE_SPAWN) && event.getEntity().getClassification(false) != VEnums.VAMPIRE_CATEGORY.getValue()) {
            event.setSpawnCancelled(true);
        }
    }

    @SubscribeEvent
    public void onEntityEquipmentChange(@NotNull LivingEquipmentChangeEvent event) {
        LivingEntity livingEntity;
        if (event.getSlot().getType() == EquipmentSlot.Type.HUMANOID_ARMOR && (livingEntity = event.getEntity()) instanceof Player) {
            Player player = (Player)livingEntity;
            VampirePlayer.get(player).requestNaturalArmorUpdate();
        }
    }

    @SubscribeEvent
    public void onEntityJoinWorld(@NotNull EntityJoinLevelEvent event) {
        if (!event.getLevel().isClientSide()) {
            IAdjustableLevel entity;
            Entity entity2 = event.getEntity();
            if (entity2 instanceof IAdjustableLevel && (entity = (IAdjustableLevel)entity2).getEntityLevel() == -1) {
                Difficulty d = DifficultyCalculator.findDifficultyForPos(event.getLevel(), event.getEntity().blockPosition(), 30);
                int l = entity.suggestEntityLevel(d);
                if (l > entity.getMaxEntityLevel()) {
                    l = entity.getMaxEntityLevel();
                } else if (l < 0) {
                    event.setCanceled(true);
                }
                entity.setEntityLevel(l);
                if (entity instanceof PathfinderMob) {
                    ((PathfinderMob)entity).setHealth(((PathfinderMob)entity).getMaxHealth());
                }
            }
            if (((Boolean)VampirismConfig.BALANCE.creeperIgnoreVampire.get()).booleanValue() && event.getEntity() instanceof Creeper) {
                ((Creeper)event.getEntity()).goalSelector.addGoal(3, (Goal)new AvoidEntityGoal((PathfinderMob)((Creeper)event.getEntity()), Player.class, 20.0f, 1.1, 1.3, Helper::isVampire));
                ModEntityEventHandler.makeVampireFriendly("creeper", (Creeper)event.getEntity(), NearestAttackableTargetGoal.class, Player.class, 1, type -> type == EntityType.CREEPER);
                return;
            }
            if (((Boolean)VampirismConfig.BALANCE.zombieIgnoreVampire.get()).booleanValue() && event.getEntity() instanceof Zombie) {
                ModEntityEventHandler.makeVampireFriendly("zombie", (Zombie)event.getEntity(), NearestAttackableTargetGoal.class, Player.class, 2, type -> type == EntityType.ZOMBIE || type == EntityType.HUSK || type == EntityType.ZOMBIE_VILLAGER || type == EntityType.DROWNED);
                ModEntityEventHandler.makeVampireFriendly("villager zombie", (Zombie)event.getEntity(), NearestAttackableTargetGoal.class, AbstractVillager.class, 3, type -> type == EntityType.ZOMBIE || type == EntityType.HUSK || type == EntityType.ZOMBIE_VILLAGER || type == EntityType.DROWNED);
                return;
            }
            if (((Boolean)VampirismConfig.BALANCE.skeletonIgnoreVampire.get()).booleanValue() && (event.getEntity() instanceof Skeleton || event.getEntity() instanceof Stray)) {
                ModEntityEventHandler.makeVampireFriendly("skeleton", (AbstractSkeleton)event.getEntity(), NearestAttackableTargetGoal.class, Player.class, 2, type -> type == EntityType.SKELETON);
            }
            if (event.getEntity() instanceof IronGolem) {
                ((IronGolem)event.getEntity()).targetSelector.addGoal(4, (Goal)new GolemTargetNonVillageFactionGoal((IronGolem)event.getEntity()));
                Goal mobTarget = null;
                for (WrappedGoal t2 : ((GoalSelectorAccessor)((IronGolem)event.getEntity()).targetSelector).getAvailableGoals()) {
                    if (!(t2.getGoal() instanceof NearestAttackableTargetGoal) || t2.getPriority() != 3 || !Mob.class.equals(((NearestAttackableTargetGoalAccessor)t2.getGoal()).getTargetType())) continue;
                    mobTarget = t2.getGoal();
                    break;
                }
                if (mobTarget != null) {
                    ((NearestTargetGoalModifier)mobTarget).ignoreFactionEntities();
                } else if (this.warnAboutGolem) {
                    LOGGER.warn("Could not replace villager iron golem target task");
                    this.warnAboutGolem = false;
                }
                return;
            }
            if (event.getEntity() instanceof Villager) {
                Optional<TotemBlockEntity> tile = TotemHelper.getTotemNearPos((ServerLevel)event.getLevel(), event.getEntity().blockPosition(), true);
                if (tile.filter(t -> VReference.HUNTER_FACTION.equals(t.getControllingFaction())).isPresent()) {
                    ExtendedCreature.getSafe(event.getEntity()).ifPresent(e -> e.setPoisonousBlood(true));
                }
                return;
            }
        }
    }

    @SubscribeEvent
    public void onEntityVisibilityCheck(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull LivingEvent.LivingVisibilityEvent event) {
        Player player;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player && VampirismPlayerAttributes.get(player = (Player)livingEntity).getHuntSpecial().isDisguised()) {
            event.modifyVisibility((VampirismPlayerAttributes.get((Player)((Player)event.getEntity())).getHuntSpecial().fullHunterCoat != null ? 0.5 : 1.0) * (Double)VampirismConfig.BALANCE.haDisguiseVisibilityMod.get());
        }
    }

    @SubscribeEvent
    public void onItemUseFinish(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull LivingEntityUseItemEvent.Finish event) {
        if (event.getEntity() instanceof MinionEntity && event.getItem().getItem() instanceof PotionItem) {
            ItemStack stack = event.getResultStack();
            stack.shrink(1);
            if (stack.isEmpty()) {
                event.setResultStack(new ItemStack((ItemLike)Items.GLASS_BOTTLE));
                return;
            }
            ((MinionEntity)event.getEntity()).getInventory().ifPresent(inv -> inv.addItemStack(new ItemStack((ItemLike)Items.GLASS_BOTTLE)));
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onLivingEquipmentChange(@NotNull LivingEquipmentChangeEvent event) {
        if (event.getTo().getItem() instanceof VampireSwordItem) {
            ((VampireSwordItem)event.getTo().getItem()).updateTrainedCached(event.getTo(), event.getEntity());
        }
    }

    @SubscribeEvent
    public void onLivingUpdate(EntityTickEvent.Post event) {
        if (event.getEntity() instanceof PathfinderMob) {
            event.getEntity().getCommandSenderWorld().getProfiler().push("vampirism_extended_creature");
            ExtendedCreature.getSafe(event.getEntity()).ifPresent(IExtendedCreatureVampirism::tick);
            event.getEntity().getCommandSenderWorld().getProfiler().pop();
        }
    }

    @SubscribeEvent
    public void onStartAttackHit(AttackEntityEvent event) {
        if (!Helper.isHunter(event.getEntity()) && OilUtils.getAppliedOil(event.getEntity().getMainHandItem()).isPresent()) {
            event.setCanceled(true);
            event.getEntity().displayClientMessage((Component)Component.translatable((String)"text.vampirism.oils.cannot_use"), true);
        }
    }

    @SubscribeEvent
    public void onActuallyHurt(@NotNull LivingDamageEvent.Pre event) {
        Entity entity;
        DamageContainer d = event.getContainer();
        if (d.getSource().is(DamageTypes.PLAYER_ATTACK) && (entity = d.getSource().getEntity()) instanceof Player) {
            Player player = (Player)entity;
            ItemStack stack = player.getMainHandItem();
            OilUtils.getAppliedOil(stack).ifPresent(oil -> {
                if (oil instanceof IWeaponOil) {
                    d.setNewDamage(d.getNewDamage() + ((IWeaponOil)oil).onHit(stack, d.getNewDamage(), (IWeaponOil)oil, event.getEntity(), (LivingEntity)player));
                    oil.reduceDuration(stack, (IApplicableOil)oil, oil.getDurationReduction());
                }
            });
        }
    }

    @SubscribeEvent
    public void onLivingDamage(@NotNull LivingIncomingDamageEvent event) {
        block2: {
            ItemStack armorStack;
            Entity entity;
            if (event.getSource().is(DamageTypes.PLAYER_ATTACK) && (entity = event.getSource().getEntity()) instanceof Player) {
                Player player = (Player)entity;
                ItemStack stack = player.getMainHandItem();
                OilUtils.getAppliedOil(stack).ifPresent(oil -> {
                    if (oil instanceof IWeaponOil) {
                        event.setAmount(event.getAmount() + ((IWeaponOil)oil).onDamage(stack, event.getAmount(), (IWeaponOil)oil, event.getEntity(), (LivingEntity)player));
                    }
                });
            }
            if (!event.getSource().is(ModTags.DamageTypes.ENTITY_PHYSICAL) || event.getSource().is(DamageTypeTags.BYPASSES_ARMOR)) break block2;
            Iterator iterator = event.getEntity().getArmorSlots().iterator();
            while (iterator.hasNext() && !OilUtils.getAppliedOil(armorStack = (ItemStack)iterator.next()).map(oil -> {
                EvasionOil evasionOil;
                if (oil instanceof EvasionOil && (evasionOil = (EvasionOil)oil).evasionChance() > Optional.ofNullable(event.getSource().getEntity()).map(entity -> Float.valueOf(entity.level().random.nextFloat())).orElse(Float.valueOf(1.0f)).floatValue()) {
                    event.setAmount(0.0f);
                    oil.reduceDuration(armorStack, (IApplicableOil)oil, oil.getDurationReduction());
                    return true;
                }
                return false;
            }).orElse(false).booleanValue()) {
            }
        }
    }
}

