/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity;

import de.teamlapen.lib.HelperLib;
import de.teamlapen.lib.lib.storage.IAttachment;
import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.datamaps.IEntityBlood;
import de.teamlapen.vampirism.api.entity.IExtendedCreatureVampirism;
import de.teamlapen.vampirism.api.entity.convertible.IConvertedCreature;
import de.teamlapen.vampirism.api.entity.vampire.IVampire;
import de.teamlapen.vampirism.api.util.VResourceLocation;
import de.teamlapen.vampirism.config.BalanceMobProps;
import de.teamlapen.vampirism.core.ModAttachments;
import de.teamlapen.vampirism.core.ModEffects;
import de.teamlapen.vampirism.effects.SanguinareEffect;
import de.teamlapen.vampirism.entity.player.LevelAttributeModifier;
import de.teamlapen.vampirism.entity.player.vampire.VampirePlayer;
import de.teamlapen.vampirism.util.DamageHandler;
import de.teamlapen.vampirism.world.ModDamageSources;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ReputationEventHandler;
import net.minecraft.world.entity.ai.village.ReputationEventType;
import net.minecraft.world.entity.npc.Villager;
import net.neoforged.neoforge.attachment.IAttachmentHolder;
import net.neoforged.neoforge.attachment.IAttachmentSerializer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExtendedCreature
implements IAttachment,
IExtendedCreatureVampirism {
    private static final String NBT_KEY = "extended_creature";
    public static final ResourceLocation SERIALIZER_ID = VResourceLocation.mod("extended_creature");
    private static final String KEY_BLOOD = "bloodLevel";
    private static final String KEY_MAX_BLOOD = "max_blood";
    private static final String POISONOUS_BLOOD = "poisonousBlood";
    private final PathfinderMob entity;
    private final boolean canBecomeVampire;
    private boolean poisonousBlood;
    private boolean markForBloodCalculation = false;
    private int maxBlood;
    private int blood;
    private int remainingBarkTicks;

    @NotNull
    public static Optional<ExtendedCreature> getSafe(@NotNull Entity mob) {
        if (mob instanceof PathfinderMob) {
            PathfinderMob pathfinderMob = (PathfinderMob)mob;
            return Optional.of((ExtendedCreature)pathfinderMob.getData(ModAttachments.EXTENDED_CREATURE));
        }
        return Optional.empty();
    }

    public ExtendedCreature(PathfinderMob entity) {
        this.entity = entity;
        IEntityBlood entry = VampirismAPI.entityRegistry().getEntry(entity);
        if (entry != null && entry.blood() > 0) {
            this.maxBlood = entry.blood();
            this.canBecomeVampire = VampirismAPI.entityRegistry().getConverterEntry(entity) != null;
        } else {
            if (entry == null) {
                this.markForBloodCalculation = true;
            }
            this.maxBlood = -1;
            this.canBecomeVampire = false;
        }
        this.blood = this.maxBlood;
        this.poisonousBlood = false;
    }

    @Override
    @NotNull
    public Entity asEntity() {
        return this.entity;
    }

    @Override
    public boolean canBeBitten(IVampire biter) {
        return this.getBlood() > 0;
    }

    @Override
    public boolean canBecomeVampire() {
        return this.canBecomeVampire;
    }

    @Override
    public int getBlood() {
        return this.blood;
    }

    @Override
    public void setBlood(int blood) {
        if (blood >= 0 && blood <= this.getMaxBlood() && this.getBlood() != -1) {
            this.blood = blood;
        }
    }

    @Override
    public float getBloodLevelRelative() {
        return (float)this.getBlood() / (float)this.getMaxBlood();
    }

    @Override
    public float getBloodSaturation() {
        return 1.0f;
    }

    @Override
    @NotNull
    public ResourceLocation getAttachedKey() {
        return SERIALIZER_ID;
    }

    @Override
    public PathfinderMob getEntity() {
        return this.entity;
    }

    @Override
    public int getMaxBlood() {
        return this.maxBlood;
    }

    private void setMaxBlood(int blood) {
        if (this.maxBlood <= 0) {
            blood = -1;
        }
        this.maxBlood = blood;
        this.blood = blood;
    }

    @Override
    public boolean hasPoisonousBlood() {
        return this.poisonousBlood;
    }

    @Override
    public void deserializeUpdateNBT(HolderLookup.Provider provider, @NotNull CompoundTag nbt) {
        if (nbt.contains(KEY_BLOOD)) {
            this.setBlood(nbt.getInt(KEY_BLOOD));
        }
        if (nbt.contains(KEY_MAX_BLOOD)) {
            this.setBlood(nbt.getInt(KEY_MAX_BLOOD));
        }
        if (nbt.contains(POISONOUS_BLOOD)) {
            this.setPoisonousBlood(nbt.getBoolean(POISONOUS_BLOOD));
        }
    }

    @Override
    @Nullable
    public IConvertedCreature<?> makeVampire() {
        if (this.canBecomeVampire()) {
            this.blood = -1;
            IConvertedCreature<?> c = VampirismAPI.entityRegistry().convert(this.entity);
            if (c != null) {
                UtilLib.replaceEntity((LivingEntity)this.entity, (LivingEntity)((PathfinderMob)c));
            }
            return c;
        }
        return null;
    }

    @Override
    public boolean canBeInfected(IVampire vampire) {
        return this.canBecomeVampire && !this.hasPoisonousBlood() && !this.entity.hasEffect(ModEffects.SANGUINARE);
    }

    @Override
    public boolean tryInfect(IVampire vampire) {
        if (this.canBeInfected(vampire)) {
            SanguinareEffect.addRandom((LivingEntity)this.entity, false);
            return true;
        }
        return false;
    }

    @Override
    public int onBite(IVampire biter) {
        Villager villager;
        PathfinderMob pathfinderMob;
        if (this.getBlood() <= 0) {
            return 0;
        }
        int amt = Math.max(1, this.getMaxBlood() / (biter instanceof VampirePlayer ? 6 : 2));
        if (amt >= this.blood) {
            amt = this.blood > 1 && biter.isAdvancedBiter() ? this.blood - 1 : this.blood;
        }
        this.blood -= amt;
        if (this.blood == 0) {
            DamageHandler.hurtModded((Entity)this.entity, ModDamageSources::noBlood, 1000.0f);
        }
        this.sync();
        this.entity.setLastHurtByMob(biter.asEntity());
        if (this.entity instanceof AgeableMob && ((AgeableMob)this.entity).getAge() < 0) {
            amt = Math.round((float)amt / 3.0f);
        }
        if (biter.isAdvancedBiter() && this.entity.getRandom().nextInt(4) == 0) {
            amt = 2 * amt;
        }
        if ((pathfinderMob = this.entity) instanceof Villager && !(villager = (Villager)pathfinderMob).isSleeping()) {
            ((ServerLevel)villager.level()).onReputationEvent(ReputationEventType.VILLAGER_HURT, (Entity)biter.asEntity(), (ReputationEventHandler)villager);
        }
        return amt;
    }

    @Override
    public void setPoisonousBlood(boolean poisonous) {
        if (poisonous == !this.poisonousBlood) {
            this.poisonousBlood = poisonous;
            this.sync();
        }
    }

    public int getRemainingBarkTicks() {
        return this.remainingBarkTicks;
    }

    public void increaseRemainingBarkTicks(int additionalBarkTicks) {
        this.remainingBarkTicks += additionalBarkTicks;
    }

    @Override
    public void tick() {
        if (!this.entity.getCommandSenderWorld().isClientSide) {
            if (this.blood == 0 && this.entity.tickCount % 20 == 10 && this.entity.getEffect(ModEffects.SANGUINARE) == null) {
                DamageHandler.hurtModded((Entity)this.entity, ModDamageSources::noBlood, 1000.0f);
            }
            if (this.blood > 0 && this.blood < this.getMaxBlood() && this.entity.tickCount % 40 == 8) {
                if ((double)this.blood < (double)this.getMaxBlood() * 0.5) {
                    this.entity.addEffect(new MobEffectInstance(MobEffects.WEAKNESS, 41));
                    this.entity.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 41, 2));
                }
                if (this.entity.getRandom().nextInt(BalanceMobProps.mobProps.BLOOD_REGEN_CHANCE) == 0 && LevelAttributeModifier.calculateModifierValue(this.blood, this.getMaxBlood(), 1.0, 0.8) < this.entity.getRandom().nextDouble()) {
                    this.setBlood(this.getBlood() + 1);
                    this.sync();
                }
            }
        }
        if (this.markForBloodCalculation) {
            IEntityBlood entry = VampirismAPI.entityRegistry().getOrCreateEntry(this.entity);
            this.setMaxBlood(entry.blood());
            this.markForBloodCalculation = false;
        }
        if (this.remainingBarkTicks > 0) {
            --this.remainingBarkTicks;
        }
    }

    @NotNull
    public String toString() {
        return super.toString() + " for entity (" + this.entity.toString() + ") [B" + this.blood + ",MB" + this.maxBlood + ",CV" + this.canBecomeVampire + "]";
    }

    @Override
    @NotNull
    public CompoundTag serializeNBT(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        CompoundTag nbt = new CompoundTag();
        nbt.putInt(KEY_BLOOD, this.blood);
        nbt.putInt(KEY_MAX_BLOOD, this.maxBlood);
        nbt.putBoolean(POISONOUS_BLOOD, this.poisonousBlood);
        return nbt;
    }

    @Override
    public String nbtKey() {
        return NBT_KEY;
    }

    @Override
    public void deserializeNBT(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider, @NotNull CompoundTag compound) {
        if (compound.contains(KEY_MAX_BLOOD)) {
            this.setMaxBlood(compound.getInt(KEY_MAX_BLOOD));
        }
        if (compound.contains(KEY_BLOOD)) {
            this.setBlood(compound.getInt(KEY_BLOOD));
        }
        if (compound.contains(POISONOUS_BLOOD)) {
            this.setPoisonousBlood(compound.getBoolean(POISONOUS_BLOOD));
        }
    }

    @Override
    @NotNull
    public CompoundTag serializeUpdateNBT(HolderLookup.Provider provider) {
        CompoundTag nbt = new CompoundTag();
        nbt.putInt(KEY_BLOOD, this.getBlood());
        nbt.putInt(KEY_MAX_BLOOD, this.getBlood());
        nbt.putBoolean(POISONOUS_BLOOD, this.hasPoisonousBlood());
        return nbt;
    }

    public void sync() {
        HelperLib.sync(this, (Entity)this.getEntity(), true);
    }

    private void sync(@NotNull CompoundTag data) {
        HelperLib.sync(this, data, (Entity)this.getEntity(), true);
    }

    public static class Factory
    implements Function<IAttachmentHolder, ExtendedCreature> {
        @Override
        public ExtendedCreature apply(IAttachmentHolder holder) {
            if (holder instanceof PathfinderMob) {
                PathfinderMob mob = (PathfinderMob)holder;
                return new ExtendedCreature(mob);
            }
            throw new IllegalArgumentException("Cannot create extended creature handler attachment for holder " + String.valueOf(holder.getClass()) + ". Expected PathfinderMob");
        }
    }

    public static class Serializer
    implements IAttachmentSerializer<CompoundTag, ExtendedCreature> {
        @NotNull
        public ExtendedCreature read(@NotNull IAttachmentHolder holder, @NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
         @NotNull HolderLookup.Provider provider) {
            if (holder instanceof PathfinderMob) {
                PathfinderMob mob = (PathfinderMob)holder;
                ExtendedCreature creature = new ExtendedCreature(mob);
                creature.deserializeNBT(provider, tag);
                return creature;
            }
            throw new IllegalArgumentException("Expected PathfinderMob, got " + holder.getClass().getSimpleName());
        }

        public CompoundTag write(ExtendedCreature attachment, // Could not load outer class - annotation placement on inner may be incorrect
         @NotNull HolderLookup.Provider provider) {
            return attachment.serializeNBT(provider);
        }
    }
}

