/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity;

import de.teamlapen.vampirism.api.items.IEntityCrossbowArrow;
import de.teamlapen.vampirism.api.items.IVampirismCrossbowArrow;
import de.teamlapen.vampirism.core.ModEntities;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.items.CrossbowArrowItem;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;

public class CrossbowArrowEntity
extends AbstractArrow
implements IEntityCrossbowArrow {
    @NotNull
    private ItemStack arrowStack = new ItemStack((ItemLike)ModItems.CROSSBOW_ARROW_NORMAL.get());
    private boolean ignoreHurtTimer = false;

    public CrossbowArrowEntity(@NotNull EntityType<? extends CrossbowArrowEntity> type, @NotNull Level world) {
        super(type, world);
    }

    public CrossbowArrowEntity(Level level, LivingEntity entity, ItemStack stack, ItemStack weapon) {
        super((EntityType)ModEntities.CROSSBOW_ARROW.get(), entity, level, stack, weapon);
        this.arrowStack = stack.copy();
        this.arrowStack.setCount(1);
    }

    public CrossbowArrowEntity(@NotNull Level worldIn, double x, double y, double z, @NotNull ItemStack arrow, ItemStack weapon) {
        super((EntityType)ModEntities.CROSSBOW_ARROW.get(), x, y, z, worldIn, arrow, weapon);
        this.setPos(x, y, z);
        this.arrowStack = arrow.copy();
        this.arrowStack.setCount(1);
    }

    public CrossbowArrowItem.EnumArrowType getArrowType() {
        return this.getPickupItem().getItem() instanceof CrossbowArrowItem ? ((CrossbowArrowItem)this.getPickupItem().getItem()).getType() : CrossbowArrowItem.EnumArrowType.NORMAL;
    }

    @NotNull
    public RandomSource getRNG() {
        return this.random;
    }

    @Override
    public void setIgnoreHurtTimer() {
        this.ignoreHurtTimer = true;
    }

    protected void doPostHurtEffects(@NotNull LivingEntity living) {
        super.doPostHurtEffects(living);
        Item item = this.arrowStack.getItem();
        if (item instanceof IVampirismCrossbowArrow) {
            if (this.ignoreHurtTimer && living.invulnerableTime > 0) {
                living.invulnerableTime = 0;
            }
            ((IVampirismCrossbowArrow)item).onHitEntity(this.arrowStack, living, this, this.getOwner());
        }
    }

    @NotNull
    protected ItemStack getPickupItem() {
        return this.arrowStack;
    }

    protected ItemStack getDefaultPickupItem() {
        return ModItems.CROSSBOW_ARROW_NORMAL.toStack();
    }

    protected void onHitBlock(@NotNull BlockHitResult blockRayTraceResult) {
        Item item = this.arrowStack.getItem();
        if (item instanceof IVampirismCrossbowArrow) {
            ((IVampirismCrossbowArrow)item).onHitBlock(this.arrowStack, blockRayTraceResult.getBlockPos(), this, this.getOwner());
        }
        super.onHitBlock(blockRayTraceResult);
    }

    public void setEffectsFromItem(ItemStack p_200887_2_) {
    }

    public void shoot(double pX, double pY, double pZ, float pVelocity, float pInaccuracy) {
        super.shoot(pX, pY, pZ, pVelocity, pInaccuracy);
    }
}

