/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.effects;

import de.teamlapen.lib.lib.util.LogUtil;
import de.teamlapen.vampirism.api.entity.factions.ISkillNode;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.api.entity.player.skills.ISkillHandler;
import de.teamlapen.vampirism.core.ModStats;
import de.teamlapen.vampirism.effects.VampirismEffect;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.entity.player.skills.SkillHandler;
import de.teamlapen.vampirism.misc.VampirismLogger;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.stats.StatType;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.common.EffectCure;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class OblivionEffect
extends VampirismEffect {
    private static final Logger LOGGER = LogManager.getLogger();

    public OblivionEffect() {
        super(MobEffectCategory.NEUTRAL, 5149489);
    }

    @Override
    public void fillEffectCures(Set<EffectCure> cures, MobEffectInstance effectInstance) {
    }

    @Override
    public boolean applyEffectTick(@NotNull LivingEntity entityLivingBaseIn, int amplifier) {
        if (!entityLivingBaseIn.getCommandSenderWorld().isClientSide && entityLivingBaseIn instanceof Player) {
            Player player = (Player)entityLivingBaseIn;
            entityLivingBaseIn.addEffect(new MobEffectInstance(MobEffects.CONFUSION, this.getTickDuration(amplifier), 5, false, false, false, null));
            return FactionPlayerHandler.getCurrentFactionPlayer((Player)entityLivingBaseIn).map(factionPlayer -> {
                ISkillHandler skillHandler = factionPlayer.getSkillHandler();
                Optional<ISkillNode> nodeOPT = ((SkillHandler)skillHandler).anyLastNode();
                if (nodeOPT.isPresent()) {
                    for (Holder<ISkill<?>> element : nodeOPT.get().skills()) {
                        skillHandler.disableSkill((ISkill)element.value());
                        player.awardStat(((StatType)ModStats.SKILL_FORGOTTEN.get()).get((Object)((ISkill)element.value())));
                    }
                    return true;
                }
                ((Player)entityLivingBaseIn).displayClientMessage((Component)Component.translatable((String)"text.vampirism.skill.skills_reset"), true);
                LOGGER.debug(LogUtil.FACTION, "Skills were reset for {}", (Object)entityLivingBaseIn.getName().getString());
                VampirismLogger.info(VampirismLogger.SKILLS, "Skills were reset for {}", entityLivingBaseIn.getName().getString());
                return false;
            }).orElse(true);
        }
        return true;
    }

    @Override
    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        return duration % this.getTickDuration(amplifier) == 0;
    }

    private int getTickDuration(int amplifier) {
        return 1000 / (amplifier + 1);
    }
}

