/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.data.provider;

import de.teamlapen.vampirism.api.datamaps.IConverterEntry;
import de.teamlapen.vampirism.api.datamaps.IEntityBlood;
import de.teamlapen.vampirism.api.datamaps.IFluidBloodConversion;
import de.teamlapen.vampirism.api.datamaps.IItemBlood;
import de.teamlapen.vampirism.api.util.VResourceLocation;
import de.teamlapen.vampirism.core.ModBlocks;
import de.teamlapen.vampirism.core.ModDataMaps;
import de.teamlapen.vampirism.core.ModEntities;
import de.teamlapen.vampirism.core.ModFluids;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.core.ModTags;
import de.teamlapen.vampirism.datamaps.ConverterEntry;
import de.teamlapen.vampirism.datamaps.EntityBloodEntry;
import de.teamlapen.vampirism.datamaps.FluidBloodConversion;
import de.teamlapen.vampirism.datamaps.ItemBlood;
import de.teamlapen.vampirism.entity.converted.converter.SpecialConverter;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.data.DataMapProvider;
import net.neoforged.neoforge.registries.datamaps.builtin.Compostable;
import net.neoforged.neoforge.registries.datamaps.builtin.NeoForgeDataMaps;

public class DataMapsProvider
extends DataMapProvider {
    public DataMapsProvider(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> lookupProvider) {
        super(packOutput, lookupProvider);
    }

    protected void gather() {
        this.gatherCompostables((DataMapProvider.Builder<Compostable, Item>)this.builder(NeoForgeDataMaps.COMPOSTABLES));
        this.gatherItemBlood((DataMapProvider.Builder<IItemBlood, Item>)this.builder(ModDataMaps.ITEM_BLOOD_MAP));
        this.gatherFluidBloodConversion((DataMapProvider.Builder<IFluidBloodConversion, Fluid>)this.builder(ModDataMaps.FLUID_BLOOD_CONVERSION_MAP));
        this.gatherEntityBlood(this.builder(ModDataMaps.ENTITY_BLOOD_MAP));
        this.gatherEntityConverter(this.builder(ModDataMaps.ENTITY_CONVERTER_MAP));
        this.gatherLiquidColors((DataMapProvider.Builder<Integer, Item>)this.builder(ModDataMaps.LIQUID_COLOR_MAP));
    }

    private void gatherLiquidColors(DataMapProvider.Builder<Integer, Item> builder) {
        builder.add(ModTags.Items.HOLY_WATER, (Object)0x6666FF, false, new ICondition[0]);
        builder.add(ModTags.Items.HOLY_WATER_SPLASH, (Object)0x6666FF, false, new ICondition[0]);
        builder.add(ModItems.PURE_BLOOD_0, (Object)8128517, false, new ICondition[0]);
        builder.add(ModItems.PURE_BLOOD_1, (Object)8193283, false, new ICondition[0]);
        builder.add(ModItems.PURE_BLOOD_2, (Object)0x830000, false, new ICondition[0]);
        builder.add(ModItems.PURE_BLOOD_3, (Object)0x7E0E0E, false, new ICondition[0]);
        builder.add(ModItems.PURE_BLOOD_4, (Object)0x8E0000, false, new ICondition[0]);
        builder.add(ModTags.Items.GARLIC, (Object)0xBBBBBB, false, new ICondition[0]);
    }

    protected void gatherCompostables(DataMapProvider.Builder<Compostable, Item> compostables) {
        compostables.add((Holder)ModBlocks.VAMPIRE_ORCHID, (Object)new Compostable(0.65f), false, new ICondition[0]);
        compostables.add((Holder)ModBlocks.GARLIC, (Object)new Compostable(0.65f), false, new ICondition[0]);
    }

    protected void gatherItemBlood(DataMapProvider.Builder<IItemBlood, Item> itemBlood) {
        itemBlood.add((Holder)Items.BEEF.builtInRegistryHolder(), (Object)new ItemBlood(200), false, new ICondition[0]);
        itemBlood.add((Holder)Items.MUTTON.builtInRegistryHolder(), (Object)new ItemBlood(100), false, new ICondition[0]);
        itemBlood.add((Holder)Items.PORKCHOP.builtInRegistryHolder(), (Object)new ItemBlood(100), false, new ICondition[0]);
        itemBlood.add((Holder)Items.RABBIT.builtInRegistryHolder(), (Object)new ItemBlood(100), false, new ICondition[0]);
        itemBlood.add((Holder)Items.CHICKEN.builtInRegistryHolder(), (Object)new ItemBlood(), false, new ICondition[0]);
        itemBlood.add((Holder)Items.COOKED_CHICKEN.builtInRegistryHolder(), (Object)new ItemBlood(), false, new ICondition[0]);
        itemBlood.add((Holder)Items.ROTTEN_FLESH.builtInRegistryHolder(), (Object)new ItemBlood(), false, new ICondition[0]);
        itemBlood.add((Holder)Items.COOKED_MUTTON.builtInRegistryHolder(), (Object)new ItemBlood(), false, new ICondition[0]);
        itemBlood.add((Holder)Items.COOKED_PORKCHOP.builtInRegistryHolder(), (Object)new ItemBlood(), false, new ICondition[0]);
        itemBlood.add((Holder)Items.COOKED_RABBIT.builtInRegistryHolder(), (Object)new ItemBlood(), false, new ICondition[0]);
        itemBlood.add(ModItems.HUMAN_HEART, (Object)new ItemBlood(200), false, new ICondition[0]);
        itemBlood.add(ModItems.WEAK_HUMAN_HEART, (Object)new ItemBlood(100), false, new ICondition[0]);
    }

    protected void gatherFluidBloodConversion(DataMapProvider.Builder<IFluidBloodConversion, Fluid> fluidConversions) {
        fluidConversions.add(ModFluids.IMPURE_BLOOD, (Object)new FluidBloodConversion(0.75f), false, new ICondition[0]);
    }

    protected void gatherEntityBlood(DataMapProvider.Builder<IEntityBlood, EntityType<?>> entityValues) {
        Function<EntityType, Holder> holder = arg_0 -> ((DefaultedRegistry)BuiltInRegistries.ENTITY_TYPE).wrapAsHolder(arg_0);
        entityValues.add(holder.apply(EntityType.COW), (Object)new EntityBloodEntry(10), false, new ICondition[0]);
        entityValues.add(holder.apply(EntityType.PIG), (Object)new EntityBloodEntry(5), false, new ICondition[0]);
        entityValues.add(holder.apply(EntityType.SHEEP), (Object)new EntityBloodEntry(5), false, new ICondition[0]);
        entityValues.add(holder.apply(EntityType.CHICKEN), (Object)EntityBloodEntry.EMPTY, false, new ICondition[0]);
        entityValues.add(holder.apply(EntityType.RABBIT), (Object)new EntityBloodEntry(2), false, new ICondition[0]);
        entityValues.add(holder.apply(EntityType.WOLF), (Object)new EntityBloodEntry(5), false, new ICondition[0]);
        entityValues.add(holder.apply(EntityType.MOOSHROOM), (Object)new EntityBloodEntry(10), false, new ICondition[0]);
        entityValues.add(holder.apply(EntityType.OCELOT), (Object)new EntityBloodEntry(4), false, new ICondition[0]);
        entityValues.add(holder.apply(EntityType.HORSE), (Object)new EntityBloodEntry(13), false, new ICondition[0]);
        entityValues.add(holder.apply(EntityType.DONKEY), (Object)new EntityBloodEntry(13), false, new ICondition[0]);
        entityValues.add(holder.apply(EntityType.MULE), (Object)new EntityBloodEntry(13), false, new ICondition[0]);
        entityValues.add(holder.apply(EntityType.PARROT), (Object)EntityBloodEntry.EMPTY, false, new ICondition[0]);
        entityValues.add(holder.apply(EntityType.LLAMA), (Object)new EntityBloodEntry(10), false, new ICondition[0]);
        entityValues.add(holder.apply(EntityType.BEE), (Object)EntityBloodEntry.EMPTY, false, new ICondition[0]);
        entityValues.add(holder.apply(EntityType.VILLAGER), (Object)new EntityBloodEntry(15), false, new ICondition[0]);
        entityValues.add(holder.apply(EntityType.POLAR_BEAR), (Object)new EntityBloodEntry(10), false, new ICondition[0]);
        entityValues.add(holder.apply(EntityType.TRADER_LLAMA), (Object)new EntityBloodEntry(10), false, new ICondition[0]);
        entityValues.add(holder.apply(EntityType.PANDA), (Object)new EntityBloodEntry(13), false, new ICondition[0]);
        entityValues.add(holder.apply(EntityType.CAT), (Object)new EntityBloodEntry(3), false, new ICondition[0]);
        entityValues.add(holder.apply(EntityType.TURTLE), (Object)new EntityBloodEntry(5), false, new ICondition[0]);
        entityValues.add(holder.apply(EntityType.FOX), (Object)new EntityBloodEntry(4), false, new ICondition[0]);
        entityValues.add(holder.apply(EntityType.SKELETON_HORSE), (Object)EntityBloodEntry.EMPTY, false, new ICondition[0]);
        entityValues.add(holder.apply(EntityType.ALLAY), (Object)EntityBloodEntry.EMPTY, false, new ICondition[0]);
        entityValues.add(holder.apply(EntityType.AXOLOTL), (Object)EntityBloodEntry.EMPTY, false, new ICondition[0]);
        entityValues.add(holder.apply(EntityType.FROG), (Object)EntityBloodEntry.EMPTY, false, new ICondition[0]);
        entityValues.add(holder.apply(EntityType.GOAT), (Object)new EntityBloodEntry(7), false, new ICondition[0]);
        entityValues.add(holder.apply(EntityType.CAMEL), (Object)new EntityBloodEntry(15), false, new ICondition[0]);
        entityValues.add(holder.apply(EntityType.SNIFFER), (Object)new EntityBloodEntry(20), false, new ICondition[0]);
    }

    protected void gatherEntityConverter(DataMapProvider.Builder<IConverterEntry, EntityType<?>> entityValues) {
        Function<String, ResourceLocation> overlay = name -> VResourceLocation.mod(String.format("textures/entity/vanilla/%s_overlay.png", name));
        Function<EntityType, Holder> holder = arg_0 -> ((DefaultedRegistry)BuiltInRegistries.ENTITY_TYPE).wrapAsHolder(arg_0);
        entityValues.add(holder.apply(EntityType.COW), (Object)new ConverterEntry(new SpecialConverter(ModEntities.CONVERTED_COW), overlay.apply("cow")), false, new ICondition[0]);
        entityValues.add(holder.apply(EntityType.SHEEP), (Object)new ConverterEntry(new SpecialConverter(ModEntities.CONVERTED_SHEEP), overlay.apply("sheep")), false, new ICondition[0]);
        entityValues.add(holder.apply(EntityType.HORSE), (Object)new ConverterEntry(new SpecialConverter(ModEntities.CONVERTED_HORSE), overlay.apply("horse")), false, new ICondition[0]);
        entityValues.add(holder.apply(EntityType.DONKEY), (Object)new ConverterEntry(new SpecialConverter(ModEntities.CONVERTED_DONKEY), overlay.apply("horse")), false, new ICondition[0]);
        entityValues.add(holder.apply(EntityType.MULE), (Object)new ConverterEntry(new SpecialConverter(ModEntities.CONVERTED_MULE), overlay.apply("horse")), false, new ICondition[0]);
        entityValues.add(holder.apply(EntityType.VILLAGER), (Object)new ConverterEntry(new SpecialConverter(ModEntities.VILLAGER_CONVERTED), overlay.apply("villager")), false, new ICondition[0]);
        entityValues.add(holder.apply(EntityType.FOX), (Object)new ConverterEntry(new SpecialConverter(ModEntities.CONVERTED_FOX), overlay.apply("fox")), false, new ICondition[0]);
        entityValues.add(holder.apply(EntityType.GOAT), (Object)new ConverterEntry(new SpecialConverter(ModEntities.CONVERTED_GOAT), overlay.apply("goat")), false, new ICondition[0]);
        entityValues.add(holder.apply(EntityType.CAMEL), (Object)new ConverterEntry(new SpecialConverter(ModEntities.CONVERTED_CAMEL), overlay.apply("camel")), false, new ICondition[0]);
        entityValues.add(holder.apply(EntityType.PIG), (Object)new ConverterEntry(overlay.apply("pig")), false, new ICondition[0]);
        entityValues.add(holder.apply(EntityType.RABBIT), (Object)new ConverterEntry(overlay.apply("rabbit")), false, new ICondition[0]);
        entityValues.add(holder.apply(EntityType.LLAMA), (Object)new ConverterEntry(overlay.apply("llama")), false, new ICondition[0]);
        entityValues.add(holder.apply(EntityType.POLAR_BEAR), (Object)new ConverterEntry(overlay.apply("polarbear")), false, new ICondition[0]);
        entityValues.add(holder.apply(EntityType.PANDA), (Object)new ConverterEntry(overlay.apply("panda")), false, new ICondition[0]);
        entityValues.add(holder.apply(EntityType.CAT), (Object)new ConverterEntry(overlay.apply("cat")), false, new ICondition[0]);
    }
}

