/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.core;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import de.teamlapen.vampirism.api.util.VResourceLocation;
import de.teamlapen.vampirism.mixin.accessor.LootTableAccessor;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.entries.NestedLootTable;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.neoforged.neoforge.event.LootTableLoadEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class ModLootTables {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Set<ResourceKey<LootTable>> LOOT_TABLES = Sets.newHashSet();
    public static final ResourceKey<LootTable> CHEST_HUNTER_TRAINER = ModLootTables.register("chests/village/hunter_trainer");
    public static final ResourceKey<LootTable> CHEST_VAMPIRE_DUNGEON = ModLootTables.register("chests/dungeon/vampire_dungeon");
    public static final ResourceKey<LootTable> CHEST_VAMPIRE_HUT = ModLootTables.register("chests/vampire_hut");
    public static final ResourceKey<LootTable> CHEST_VAMPIRE_ALTAR = ModLootTables.register("chests/vampire_altar");
    public static final ResourceKey<LootTable> CHEST_CRYPT = ModLootTables.register("chests/crypt");
    public static final ResourceKey<LootTable> CHEST_HUNTER_OUTPOST_SMITH = ModLootTables.register("chests/hunter_outpost_smith");
    public static final ResourceKey<LootTable> CHEST_HUNTER_OUTPOST_TENT = ModLootTables.register("chests/hunter_outpost_tent");
    public static final ResourceKey<LootTable> CHEST_HUNTER_OUTPOST_ALCHEMY = ModLootTables.register("chests/hunter_outpost_alchemy");
    public static final ResourceKey<LootTable> CHEST_HUNTER_OUTPOST_TOWER_FOOD = ModLootTables.register("chests/hunter_outpost_tower_food");
    public static final ResourceKey<LootTable> CHEST_HUNTER_OUTPOST_TOWER_BASIC = ModLootTables.register("chests/hunter_outpost_tower_basic");
    public static final ResourceKey<LootTable> CHEST_HUNTER_OUTPOST_TOWER_SPECIAL = ModLootTables.register("chests/hunter_outpost_tower_special");
    private static final Map<String, ResourceKey<LootTable>> INJECTION_TABLES = Maps.newHashMap();
    public static final ResourceKey<LootTable> ABANDONED_MINESHAFT = ModLootTables.registerInject("abandoned_mineshaft");
    public static final ResourceKey<LootTable> JUNGLE_TEMPLE = ModLootTables.registerInject("jungle_temple");
    public static final ResourceKey<LootTable> STRONGHOLD_CORRIDOR = ModLootTables.registerInject("stronghold_corridor");
    public static final ResourceKey<LootTable> DESERT_PYRAMID = ModLootTables.registerInject("desert_pyramid");
    public static final ResourceKey<LootTable> STRONGHOLD_LIBRARY = ModLootTables.registerInject("stronghold_library");
    private static int injected = 0;

    @NotNull
    static ResourceKey<LootTable> registerInject(String resourceName) {
        ResourceKey<LootTable> registryName = ModLootTables.register("inject/" + resourceName);
        INJECTION_TABLES.put(resourceName, registryName);
        return registryName;
    }

    @NotNull
    static ResourceKey<LootTable> register(@NotNull String resourceName) {
        return ModLootTables.register(VResourceLocation.mod(resourceName));
    }

    @NotNull
    static ResourceKey<LootTable> register(@NotNull ResourceLocation resourceLocation) {
        ResourceKey key = ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)resourceLocation);
        LOOT_TABLES.add((ResourceKey<LootTable>)key);
        return key;
    }

    @NotNull
    public static Set<ResourceKey<LootTable>> getLootTables() {
        return ImmutableSet.copyOf(LOOT_TABLES);
    }

    static void onLootLoad(@NotNull LootTableLoadEvent event) {
        String file;
        String prefix = "minecraft:chests/";
        String name = event.getName().toString();
        if (name.startsWith(prefix) && INJECTION_TABLES.containsKey(file = name.substring(name.indexOf(prefix) + prefix.length()))) {
            try {
                ((LootTableAccessor)event.getTable()).getPools().add(ModLootTables.getInjectPool(file));
                ++injected;
            }
            catch (NullPointerException e) {
                LOGGER.warn("Loottable {} is broken by some other mod. Cannot add Vampirism loot to it.", (Object)name);
            }
        }
    }

    @NotNull
    private static LootPool getInjectPool(String entryName) {
        LootPoolSingletonContainer.Builder entryBuilder = NestedLootTable.lootTableReference(INJECTION_TABLES.get(entryName)).setWeight(1);
        return LootPool.lootPool().setBonusRolls((NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f)).setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)entryBuilder).build();
    }

    public static int checkAndResetInsertedAll() {
        int i = injected;
        injected = 0;
        return Math.max(0, INJECTION_TABLES.size() - i);
    }
}

