/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.core;

import com.mojang.serialization.Codec;
import de.teamlapen.vampirism.advancements.critereon.FactionSubPredicate;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.VampirismDataComponents;
import de.teamlapen.vampirism.api.util.VResourceLocation;
import de.teamlapen.vampirism.core.ModTags;
import java.util.List;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.EntitySubPredicate;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.item.enchantment.ConditionalEffect;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.LevelBasedValue;
import net.minecraft.world.item.enchantment.effects.AddValue;
import net.minecraft.world.item.enchantment.effects.EnchantmentValueEffect;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.LootItemEntityPropertyCondition;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public class ModEnchantments {
    public static final DeferredRegister<DataComponentType<?>> ENCHANTMENT_DATA_COMPONENTS = DeferredRegister.create((ResourceKey)Registries.ENCHANTMENT_EFFECT_COMPONENT_TYPE, (String)"vampirism");
    public static final ResourceKey<Enchantment> VAMPIRE_SLAYER = ResourceKey.create((ResourceKey)Registries.ENCHANTMENT, (ResourceLocation)VResourceLocation.mod("vampire_slayer"));
    public static final ResourceKey<Enchantment> ARROW_FRUGALITY = ResourceKey.create((ResourceKey)Registries.ENCHANTMENT, (ResourceLocation)VResourceLocation.mod("arrow_frugality"));
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<List<ConditionalEffect<EnchantmentValueEffect>>>> FRUGALITY_DATA = ENCHANTMENT_DATA_COMPONENTS.register(VampirismDataComponents.Keys.FRUGALITY.getPath(), () -> DataComponentType.builder().persistent(ConditionalEffect.codec((Codec)EnchantmentValueEffect.CODEC, (LootContextParamSet)LootContextParamSets.ENCHANTED_DAMAGE).listOf()).build());

    static void register(IEventBus eventBus) {
        ENCHANTMENT_DATA_COMPONENTS.register(eventBus);
    }

    static void createEnchantments(BootstrapContext<Enchantment> context) {
        HolderGetter enchantments = context.lookup(Registries.ENCHANTMENT);
        HolderGetter items = context.lookup(Registries.ITEM);
        context.register(VAMPIRE_SLAYER, (Object)new Enchantment.Builder(Enchantment.definition((HolderSet)items.getOrThrow(ItemTags.WEAPON_ENCHANTABLE), (HolderSet)items.getOrThrow(ModTags.Items.VAMPIRE_SLAYER_ITEMS), (int)5, (int)5, (Enchantment.Cost)Enchantment.dynamicCost((int)3, (int)10), (Enchantment.Cost)Enchantment.dynamicCost((int)20, (int)10), (int)2, (EquipmentSlotGroup[])new EquipmentSlotGroup[]{EquipmentSlotGroup.MAINHAND})).exclusiveWith((HolderSet)enchantments.getOrThrow(EnchantmentTags.DAMAGE_EXCLUSIVE)).withEffect(EnchantmentEffectComponents.DAMAGE, (Object)new AddValue((LevelBasedValue)LevelBasedValue.perLevel((float)1.0f)), LootItemEntityPropertyCondition.hasProperties((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)EntityPredicate.Builder.entity().subPredicate((EntitySubPredicate)FactionSubPredicate.faction(VReference.VAMPIRE_FACTION)))).withEffect(EnchantmentEffectComponents.DAMAGE, (Object)new AddValue((LevelBasedValue)LevelBasedValue.constant((float)2.0f)), LootItemEntityPropertyCondition.hasProperties((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)EntityPredicate.Builder.entity().subPredicate((EntitySubPredicate)FactionSubPredicate.faction(VReference.VAMPIRE_FACTION)))).build(VAMPIRE_SLAYER.location()));
        context.register(ARROW_FRUGALITY, (Object)new Enchantment.Builder(Enchantment.definition((HolderSet)items.getOrThrow(ModTags.Items.CROSSBOW_ENCHANTABLE), (int)1, (int)2, (Enchantment.Cost)Enchantment.dynamicCost((int)10, (int)5), (Enchantment.Cost)Enchantment.constantCost((int)50), (int)2, (EquipmentSlotGroup[])new EquipmentSlotGroup[]{EquipmentSlotGroup.MAINHAND})).exclusiveWith((HolderSet)enchantments.getOrThrow(ModTags.Enchantments.CROSSBOW_INCOMPATIBLE)).withEffect((DataComponentType)FRUGALITY_DATA.get(), (Object)new AddValue((LevelBasedValue)LevelBasedValue.perLevel((float)1.0f))).build(ARROW_FRUGALITY.location()));
    }
}

