/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.core;

import de.teamlapen.vampirism.api.util.VResourceLocation;
import de.teamlapen.vampirism.core.ModTags;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.ArmorMaterials;
import net.minecraft.world.item.crafting.Ingredient;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public class ModArmorMaterials {
    public static final DeferredRegister<ArmorMaterial> ARMOR_MATERIALS = DeferredRegister.create((ResourceKey)Registries.ARMOR_MATERIAL, (String)"vampirism");
    public static final DeferredHolder<ArmorMaterial, ArmorMaterial> VAMPIRE_CLOTH = ModArmorMaterials.register("vampire_cloth", ModArmorMaterials.createReduction(1, 3, 2, 1), 15, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_LEATHER, () -> Ingredient.of(ModTags.Items.HEART), 0.0f, 0.0f);
    public static final DeferredHolder<ArmorMaterial, ArmorMaterial> VAMPIRE_CLOTH_CROWN = ModArmorMaterials.copyWithNewLayer("vampire_clothing_crown", VAMPIRE_CLOTH);
    public static final DeferredHolder<ArmorMaterial, ArmorMaterial> VAMPIRE_CLOTH_HAT = ModArmorMaterials.copyWithNewLayer("vampire_clothing_hat", VAMPIRE_CLOTH);
    public static final DeferredHolder<ArmorMaterial, ArmorMaterial> VAMPIRE_CLOTH_LEGS = ModArmorMaterials.copyWithNewLayer("vampire_clothing_legs", VAMPIRE_CLOTH);
    public static final DeferredHolder<ArmorMaterial, ArmorMaterial> VAMPIRE_CLOTH_BOOTS = ModArmorMaterials.copyWithNewLayer("vampire_clothing_boots", VAMPIRE_CLOTH);
    public static final DeferredHolder<ArmorMaterial, ArmorMaterial> VAMPIRE_CLOAK_BLACK_BLUE = ModArmorMaterials.copyWithNewLayer("vampire_cloak_black_blue", VAMPIRE_CLOTH);
    public static final DeferredHolder<ArmorMaterial, ArmorMaterial> VAMPIRE_CLOAK_BLACK_RED = ModArmorMaterials.copyWithNewLayer("vampire_cloak_black_red", VAMPIRE_CLOTH);
    public static final DeferredHolder<ArmorMaterial, ArmorMaterial> VAMPIRE_CLOAK_BLACK_WHITE = ModArmorMaterials.copyWithNewLayer("vampire_cloak_black_white", VAMPIRE_CLOTH);
    public static final DeferredHolder<ArmorMaterial, ArmorMaterial> VAMPIRE_CLOAK_RED_BLACK = ModArmorMaterials.copyWithNewLayer("vampire_cloak_red_black", VAMPIRE_CLOTH);
    public static final DeferredHolder<ArmorMaterial, ArmorMaterial> VAMPIRE_CLOAK_WHITE_BLACK = ModArmorMaterials.copyWithNewLayer("vampire_cloak_white_black", VAMPIRE_CLOTH);
    public static final DeferredHolder<ArmorMaterial, ArmorMaterial> NORMAL_HUNTER_COAT = ModArmorMaterials.register("hunter_coat", ModArmorMaterials.createReduction(3, 6, 5, 3), 10, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_IRON, () -> Ingredient.of((TagKey)Tags.Items.INGOTS_IRON), 2.0f, 0.0f);
    public static final DeferredHolder<ArmorMaterial, ArmorMaterial> ENHANCED_HUNTER_COAT = ModArmorMaterials.register("hunter_coat_enhanced", ModArmorMaterials.createReduction(4, 8, 6, 4), 10, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_IRON, () -> Ingredient.of((TagKey)Tags.Items.INGOTS_IRON), 2.0f, 0.0f);
    public static final DeferredHolder<ArmorMaterial, ArmorMaterial> ULTIMATE_HUNTER_COAT = ModArmorMaterials.register("hunter_coat_ultimate", ModArmorMaterials.createReduction(4, 9, 9, 4), 10, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_IRON, () -> Ingredient.of((TagKey)Tags.Items.GEMS_DIAMOND), 2.0f, 0.0f);
    public static final DeferredHolder<ArmorMaterial, ArmorMaterial> NORMAL_SWIFTNESS = ModArmorMaterials.registerWithOverlay("armor_of_swiftness_normal", ModArmorMaterials.createReduction(1, 3, 2, 1), 12, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_LEATHER, () -> Ingredient.of((TagKey)Tags.Items.LEATHERS), 0.0f, 0.0f);
    public static final DeferredHolder<ArmorMaterial, ArmorMaterial> ENHANCED_SWIFTNESS = ModArmorMaterials.registerWithOverlay("armor_of_swiftness_enhanced", ModArmorMaterials.createReduction(2, 6, 5, 2), 12, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_LEATHER, () -> Ingredient.of((TagKey)Tags.Items.LEATHERS), 0.0f, 0.0f);
    public static final DeferredHolder<ArmorMaterial, ArmorMaterial> ULTIMATE_SWIFTNESS = ModArmorMaterials.registerWithOverlay("armor_of_swiftness_ultimate", ModArmorMaterials.createReduction(3, 8, 6, 3), 12, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_LEATHER, () -> Ingredient.of((TagKey)Tags.Items.LEATHERS), 0.0f, 0.0f);
    public static final DeferredHolder<ArmorMaterial, ArmorMaterial> HUNTER_HAT_0 = ModArmorMaterials.copyWithNewLayer("hunter_hat_head_0", (Holder<ArmorMaterial>)ArmorMaterials.IRON);
    public static final DeferredHolder<ArmorMaterial, ArmorMaterial> HUNTER_HAT_1 = ModArmorMaterials.copyWithNewLayer("hunter_hat_head_1", (Holder<ArmorMaterial>)ArmorMaterials.IRON);

    static void register(IEventBus bus) {
        ARMOR_MATERIALS.register(bus);
    }

    private static DeferredHolder<ArmorMaterial, ArmorMaterial> copyWithNewLayer(String name, Holder<ArmorMaterial> sourceHolder) {
        return ARMOR_MATERIALS.register(name, () -> {
            ArmorMaterial source = (ArmorMaterial)sourceHolder.value();
            List<ArmorMaterial.Layer> layers = List.of(new ArmorMaterial.Layer(VResourceLocation.mod(name)));
            return new ArmorMaterial(source.defense(), source.enchantmentValue(), source.equipSound(), source.repairIngredient(), layers, source.toughness(), source.knockbackResistance());
        });
    }

    private static DeferredHolder<ArmorMaterial, ArmorMaterial> register(String name, Map<ArmorItem.Type, Integer> defense, int enchantmentValue, Holder<SoundEvent> equipSound, Supplier<Ingredient> repairIngredient, float toughness, float knockbackResistance) {
        return ARMOR_MATERIALS.register(name, () -> {
            List<ArmorMaterial.Layer> list = List.of(new ArmorMaterial.Layer(VResourceLocation.mod(name)));
            return new ArmorMaterial(defense, enchantmentValue, equipSound, repairIngredient, list, toughness, knockbackResistance);
        });
    }

    private static DeferredHolder<ArmorMaterial, ArmorMaterial> registerWithOverlay(String name, Map<ArmorItem.Type, Integer> defense, int enchantmentValue, Holder<SoundEvent> equipSound, Supplier<Ingredient> repairIngredient, float toughness, float knockbackResistance) {
        return ARMOR_MATERIALS.register(name, () -> {
            List<ArmorMaterial.Layer> list = List.of(new ArmorMaterial.Layer(VResourceLocation.mod(name), "", true), new ArmorMaterial.Layer(VResourceLocation.mod(name), "_overlay", false));
            return new ArmorMaterial(defense, enchantmentValue, equipSound, repairIngredient, list, toughness, knockbackResistance);
        });
    }

    private static EnumMap<ArmorItem.Type, Integer> createReduction(int helmet, int chestplate, int leggings, int boots) {
        return (EnumMap)Util.make(new EnumMap(ArmorItem.Type.class), map -> {
            map.put(ArmorItem.Type.BOOTS, boots);
            map.put(ArmorItem.Type.LEGGINGS, leggings);
            map.put(ArmorItem.Type.CHESTPLATE, chestplate);
            map.put(ArmorItem.Type.HELMET, helmet);
        });
    }
}

