/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.command.test;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import de.teamlapen.lib.lib.util.BasicCommand;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.entity.factions.IFaction;
import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import de.teamlapen.vampirism.api.entity.player.refinement.IRefinementSet;
import de.teamlapen.vampirism.api.items.IRefinementItem;
import de.teamlapen.vampirism.command.arguments.RefinementSetArgument;
import de.teamlapen.vampirism.entity.factions.PlayableFaction;
import de.teamlapen.vampirism.items.RefinementItem;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class GiveAccessoriesCommand
extends BasicCommand {
    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"giveAccessories").requires(context -> context.hasPermission(2))).then(Commands.argument((String)"slot", (ArgumentType)IntegerArgumentType.integer((int)1, (int)3)).then(Commands.argument((String)"set", (ArgumentType)RefinementSetArgument.set()).executes(context -> GiveAccessoriesCommand.give((CommandContext<CommandSourceStack>)context, ((CommandSourceStack)context.getSource()).getPlayerOrException(), IntegerArgumentType.getInteger((CommandContext)context, (String)"slot"), RefinementSetArgument.getSet((CommandContext<CommandSourceStack>)context, "set")))))).then(((LiteralArgumentBuilder)Commands.literal((String)"random").executes(context -> GiveAccessoriesCommand.random((CommandContext<CommandSourceStack>)context, ((CommandSourceStack)context.getSource()).getPlayerOrException(), 1))).then(Commands.argument((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(context -> GiveAccessoriesCommand.random((CommandContext<CommandSourceStack>)context, ((CommandSourceStack)context.getSource()).getPlayerOrException(), IntegerArgumentType.getInteger((CommandContext)context, (String)"amount")))))).then(Commands.literal((String)"help").executes(GiveAccessoriesCommand::help));
    }

    private static <Z extends Item> int give(@NotNull CommandContext<CommandSourceStack> context, @NotNull ServerPlayer asPlayer, int number, @NotNull IRefinementSet set) {
        IFaction<?> faction = set.getFaction();
        if (faction instanceof PlayableFaction) {
            ItemStack s;
            Object i = ((PlayableFaction)faction).getRefinementItem(IRefinementItem.AccessorySlotType.values()[number - 1]);
            if (((IRefinementItem)i).applyRefinementSet(s = new ItemStack(i), set)) {
                asPlayer.addItem(s);
                ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"command.vampirism.test.give_accessories.success"), false);
            } else {
                ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"command.vampirism.test.give_accessories.incompatible"), false);
            }
        }
        return 0;
    }

    private static int help(@NotNull CommandContext<CommandSourceStack> context) {
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"command.vampirism.test.give_accessories.help"), false);
        return 0;
    }

    private static <T extends IFactionPlayer<T>> int random(@NotNull CommandContext<CommandSourceStack> context, @NotNull ServerPlayer entity, int amount) {
        IFaction<?> faction = VampirismAPI.factionRegistry().getFaction((Entity)entity);
        if (faction instanceof PlayableFaction) {
            for (int i = 0; i < amount; ++i) {
                ItemStack stack = RefinementItem.getRandomRefinementItem((PlayableFaction)faction);
                if (stack.isEmpty()) {
                    ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"command.vampirism.test.give_accessories.no_item"), false);
                    return 0;
                }
                entity.addItem(stack);
            }
        }
        return 0;
    }
}

