/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.command.arguments;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import de.teamlapen.vampirism.api.entity.player.refinement.IRefinementSet;
import de.teamlapen.vampirism.core.ModRegistries;
import de.teamlapen.vampirism.util.RegUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class RefinementSetArgument
implements ArgumentType<IRefinementSet> {
    public static final DynamicCommandExceptionType REFINEMENT_NOT_FOUND = new DynamicCommandExceptionType(particle -> Component.translatable((String)"command.vampirism.argument.refinement_set.notfound", (Object[])new Object[]{particle}));
    private static final Collection<String> EXAMPLES = Arrays.asList("refinement_set", "modid:refinement_set");

    @NotNull
    public static RefinementSetArgument set() {
        return new RefinementSetArgument();
    }

    public static IRefinementSet getSet(@NotNull CommandContext<CommandSourceStack> context, String name) {
        return (IRefinementSet)context.getArgument(name, IRefinementSet.class);
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    @NotNull
    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, @NotNull SuggestionsBuilder builder) {
        return SharedSuggestionProvider.suggestResource((Iterable)ModRegistries.REFINEMENT_SETS.keySet(), (SuggestionsBuilder)builder);
    }

    @NotNull
    public IRefinementSet parse(@NotNull StringReader reader) throws CommandSyntaxException {
        ResourceLocation id = ResourceLocation.read((StringReader)reader);
        IRefinementSet set = RegUtil.getRefinementSet(id);
        if (set == null) {
            throw REFINEMENT_NOT_FOUND.create((Object)id);
        }
        return set;
    }
}

