/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.command.arguments;

import com.google.gson.JsonObject;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.entity.factions.IFaction;
import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class FactionArgument
implements ArgumentType<IFaction<?>> {
    private static final Collection<String> EXAMPLES = Arrays.asList("vampirism:vampire", "vampirism:hunter");
    private static final DynamicCommandExceptionType FACTION_NOT_FOUND = new DynamicCommandExceptionType(id -> Component.translatable((String)"command.vampirism.argument.faction.notfound", (Object[])new Object[]{id}));
    private static final DynamicCommandExceptionType FACTION_NOT_PLAYABLE = new DynamicCommandExceptionType(id -> Component.translatable((String)"command.vampirism.argument.faction.notplayable", (Object[])new Object[]{id}));
    public final boolean onlyPlayableFactions;

    public static IFaction<?> getFaction(@NotNull CommandContext<CommandSourceStack> context, String id) {
        return (IFaction)context.getArgument(id, IFaction.class);
    }

    public static IPlayableFaction<?> getPlayableFaction(@NotNull CommandContext<CommandSourceStack> context, String id) {
        return (IPlayableFaction)context.getArgument(id, IFaction.class);
    }

    @NotNull
    public static FactionArgument playableFactions() {
        return new FactionArgument(true);
    }

    @NotNull
    public static FactionArgument factions() {
        return new FactionArgument(false);
    }

    public FactionArgument(boolean onlyPlayableFactions) {
        this.onlyPlayableFactions = onlyPlayableFactions;
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    @NotNull
    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, @NotNull SuggestionsBuilder builder) {
        return SharedSuggestionProvider.suggest(Arrays.stream(this.onlyPlayableFactions ? VampirismAPI.factionRegistry().getPlayableFactions() : VampirismAPI.factionRegistry().getFactions()).map(i -> i.getID().toString()), (SuggestionsBuilder)builder);
    }

    @NotNull
    public IFaction<?> parse(@NotNull StringReader reader) throws CommandSyntaxException {
        ResourceLocation id = ResourceLocation.read((StringReader)reader);
        IFaction<?> faction = VampirismAPI.factionRegistry().getFactionByID(id);
        if (faction == null) {
            throw FACTION_NOT_FOUND.create((Object)id);
        }
        if (this.onlyPlayableFactions & !(faction instanceof IPlayableFaction)) {
            throw FACTION_NOT_PLAYABLE.create((Object)id);
        }
        return faction;
    }

    public static class Info
    implements ArgumentTypeInfo<FactionArgument, Template> {
        public void serializeToNetwork(@NotNull Template template, @NotNull FriendlyByteBuf buffer) {
            buffer.writeBoolean(template.onlyPlayableFaction);
        }

        @NotNull
        public Template deserializeFromNetwork(@NotNull FriendlyByteBuf buffer) {
            return new Template(buffer.readBoolean());
        }

        public void serializeToJson(@NotNull Template template, @NotNull JsonObject json) {
            json.addProperty("onlyPlayableFactions", Boolean.valueOf(template.onlyPlayableFaction));
        }

        @NotNull
        public Template unpack(@NotNull FactionArgument argument) {
            return new Template(argument.onlyPlayableFactions);
        }

        public class Template
        implements ArgumentTypeInfo.Template<FactionArgument> {
            final boolean onlyPlayableFaction;

            Template(boolean onlyPlayableFaction) {
                this.onlyPlayableFaction = onlyPlayableFaction;
            }

            @NotNull
            public FactionArgument instantiate(@NotNull CommandBuildContext context) {
                return new FactionArgument(this.onlyPlayableFaction);
            }

            @NotNull
            public ArgumentTypeInfo<FactionArgument, ?> type() {
                return Info.this;
            }
        }
    }
}

