/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.renderer.entity.layers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import de.teamlapen.vampirism.api.util.VResourceLocation;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.entity.player.VampirismPlayerAttributes;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;

public class VampirePlayerHeadLayer<T extends Player, Q extends HumanoidModel<T>>
extends RenderLayer<T, Q> {
    private final ResourceLocation @NotNull [] eyeOverlays = new ResourceLocation[17];
    private final ResourceLocation @NotNull [] fangOverlays;

    public VampirePlayerHeadLayer(@NotNull RenderLayerParent<T, Q> entityRendererIn) {
        super(entityRendererIn);
        int i;
        for (i = 0; i < this.eyeOverlays.length; ++i) {
            this.eyeOverlays[i] = VResourceLocation.mod("textures/entity/vanilla/eyes" + i + ".png");
        }
        this.fangOverlays = new ResourceLocation[7];
        for (i = 0; i < this.fangOverlays.length; ++i) {
            this.fangOverlays[i] = VResourceLocation.mod("textures/entity/vanilla/fangs" + i + ".png");
        }
    }

    public void render(@NotNull PoseStack stack, @NotNull MultiBufferSource iRenderTypeBuffer, int i, @NotNull T player, float v, float v1, float v2, float v3, float v4, float v5) {
        if (!((Boolean)VampirismConfig.CLIENT.renderVampireEyes.get()).booleanValue() || !player.isAlive()) {
            return;
        }
        VampirismPlayerAttributes atts = VampirismPlayerAttributes.get(player);
        if (atts.vampireLevel > 0 && !atts.getVampSpecial().disguised && !player.isInvisible()) {
            int eyeType = Math.max(0, Math.min(atts.getVampSpecial().eyeType, this.eyeOverlays.length - 1));
            int fangType = Math.max(0, Math.min(atts.getVampSpecial().fangType, this.fangOverlays.length - 1));
            RenderType eyeRenderType = atts.getVampSpecial().glowingEyes ? RenderType.eyes((ResourceLocation)this.eyeOverlays[eyeType]) : RenderType.entityCutoutNoCull((ResourceLocation)this.eyeOverlays[eyeType]);
            VertexConsumer vertexBuilderEye = iRenderTypeBuffer.getBuffer(eyeRenderType);
            int packerOverlay = LivingEntityRenderer.getOverlayCoords(player, (float)0.0f);
            ModelPart head = ((HumanoidModel)this.getParentModel()).head;
            head.render(stack, vertexBuilderEye, i, packerOverlay);
            VertexConsumer vertexBuilderFang = iRenderTypeBuffer.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)this.fangOverlays[fangType]));
            head.render(stack, vertexBuilderFang, i, packerOverlay);
        }
    }
}

