/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import de.teamlapen.vampirism.mixin.client.accessor.HumanoidArmorLayerAccessor;
import de.teamlapen.vampirism.util.TextureComparator;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.HumanoidMobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.client.resources.PlayerSkin;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import org.jetbrains.annotations.NotNull;

public abstract class DualBipedRenderer<T extends Mob, M extends HumanoidModel<T>>
extends HumanoidMobRenderer<T, M> {
    @NotNull
    private final M modelA;
    private final M modelB;
    private PlayerSkin playerSkin;

    public DualBipedRenderer(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull EntityRendererProvider.Context context, @NotNull M modelBipedInA, M modelBipedInB, float shadowSize) {
        super(context, modelBipedInA, shadowSize);
        this.modelA = modelBipedInA;
        this.modelB = modelBipedInB;
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull T entity) {
        return this.playerSkin != null ? this.playerSkin.texture() : DefaultPlayerSkin.getDefaultTexture();
    }

    public final void render(@NotNull T entityIn, float entityYaw, float partialTicks, @NotNull PoseStack matrixStackIn, @NotNull MultiBufferSource bufferIn, int packedLightIn) {
        this.playerSkin = this.determineTextureAndModel(entityIn);
        this.model = switch (this.playerSkin.model()) {
            default -> throw new MatchException(null, null);
            case PlayerSkin.Model.SLIM -> (HumanoidModel)this.modelB;
            case PlayerSkin.Model.WIDE -> (HumanoidModel)this.modelA;
        };
        this.renderSelected(entityIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
    }

    protected abstract PlayerSkin determineTextureAndModel(T var1);

    protected void renderSelected(@NotNull T entityIn, float entityYaw, float partialTicks, @NotNull PoseStack matrixStackIn, @NotNull MultiBufferSource bufferIn, int packedLightIn) {
        super.render(entityIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
    }

    @NotNull
    protected PlayerSkin[] separateSlimTextures(@NotNull Stream<ResourceLocation> set) {
        return (PlayerSkin[])set.map(r -> {
            PlayerSkin.Model b = r.getPath().endsWith("slim.png") ? PlayerSkin.Model.SLIM : PlayerSkin.Model.WIDE;
            return new PlayerSkin(r, null, null, null, b, false);
        }).sorted(this.alphaNumericComparator()).toArray(PlayerSkin[]::new);
    }

    @NotNull
    protected PlayerSkin[] gatherTextures(@NotNull String dirPath, boolean required) {
        ArrayList hunterTextures = new ArrayList(Minecraft.getInstance().getResourceManager().listResources(dirPath, s -> s.getPath().endsWith(".png")).keySet());
        PlayerSkin[] textures = this.separateSlimTextures(hunterTextures.stream().filter(r -> "vampirism".equals(r.getNamespace())));
        if (textures.length == 0 && required) {
            throw new IllegalStateException("Must have at least one hunter texture: vampirism:" + dirPath + "/texture.png");
        }
        return textures;
    }

    protected Comparator<PlayerSkin> alphaNumericComparator() {
        return (o1, o2) -> TextureComparator.alphaNumericComparator().compare(o1.texture(), o2.texture());
    }

    protected static class ArmorLayer<A extends HumanoidModel<T>>
    extends HumanoidArmorLayer<T, M, A> {
        private final A pInnerModel;
        private final A pInnerModelSlim;
        private final A pOuterModel;
        private final A pOuterModelSlim;
        final /* synthetic */ DualBipedRenderer this$0;

        public ArmorLayer(RenderLayerParent<T, M> pRenderer, A pInnerModel, A pInnerModelSlim, A pOuterModel, A pOuterModelSlim, ModelManager pModelManager) {
            this.this$0 = this$0;
            super(pRenderer, pInnerModel, pOuterModel, pModelManager);
            this.pInnerModel = pInnerModel;
            this.pInnerModelSlim = pInnerModelSlim;
            this.pOuterModel = pOuterModel;
            this.pOuterModelSlim = pOuterModelSlim;
        }

        public void render(@NotNull PoseStack pMatrixStack, @NotNull MultiBufferSource pBuffer, int pPackedLight, @NotNull T pLivingEntity, float pLimbSwing, float pLimbSwingAmount, float pPartialTicks, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
            PlayerSkin b = this.this$0.determineTextureAndModel(pLivingEntity);
            HumanoidModel innerModel = switch (b.model()) {
                default -> throw new MatchException(null, null);
                case PlayerSkin.Model.SLIM -> (HumanoidModel)this.pInnerModelSlim;
                case PlayerSkin.Model.WIDE -> (HumanoidModel)this.pInnerModel;
            };
            HumanoidModel outerModel = switch (b.model()) {
                default -> throw new MatchException(null, null);
                case PlayerSkin.Model.SLIM -> (HumanoidModel)this.pOuterModelSlim;
                case PlayerSkin.Model.WIDE -> (HumanoidModel)this.pOuterModel;
            };
            ((HumanoidArmorLayerAccessor)((Object)this)).invoke_renderArmorPiece(pMatrixStack, pBuffer, pLivingEntity, EquipmentSlot.CHEST, pPackedLight, this.getArmorModel(EquipmentSlot.CHEST, innerModel, outerModel));
            ((HumanoidArmorLayerAccessor)((Object)this)).invoke_renderArmorPiece(pMatrixStack, pBuffer, pLivingEntity, EquipmentSlot.LEGS, pPackedLight, this.getArmorModel(EquipmentSlot.LEGS, innerModel, outerModel));
            ((HumanoidArmorLayerAccessor)((Object)this)).invoke_renderArmorPiece(pMatrixStack, pBuffer, pLivingEntity, EquipmentSlot.FEET, pPackedLight, this.getArmorModel(EquipmentSlot.FEET, innerModel, outerModel));
            ((HumanoidArmorLayerAccessor)((Object)this)).invoke_renderArmorPiece(pMatrixStack, pBuffer, pLivingEntity, EquipmentSlot.HEAD, pPackedLight, this.getArmorModel(EquipmentSlot.HEAD, innerModel, outerModel));
        }

        private A getArmorModel(EquipmentSlot slot, A innerModel, A outerModel) {
            return ((HumanoidArmorLayerAccessor)((Object)this)).invoke_usesInnerModel(slot) ? innerModel : outerModel;
        }
    }
}

