/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.model.armor;

import com.google.common.collect.ImmutableList;
import de.teamlapen.vampirism.client.core.ModEntitiesRender;
import de.teamlapen.vampirism.client.model.armor.VampirismArmorModel;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import org.jetbrains.annotations.NotNull;

public class ClothingPantsModel
extends VampirismArmorModel {
    private static final String LEFT_LEG = "left_leg";
    private static final String RIGHT_LEG = "right_leg";
    private static final String BELT = "belt";
    private static ClothingPantsModel instance;
    @NotNull
    public final ModelPart rightLeg;
    @NotNull
    public final ModelPart leftLeg;
    @NotNull
    public final ModelPart belt;

    public static ClothingPantsModel getAdjustedInstance(HumanoidModel<?> wearerModel) {
        if (instance == null) {
            instance = new ClothingPantsModel(Minecraft.getInstance().getEntityModels().bakeLayer(ModEntitiesRender.CLOTHING_PANTS));
        }
        instance.copyFromHumanoid(wearerModel);
        return instance;
    }

    @NotNull
    public static LayerDefinition createLayer() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition part = mesh.getRoot();
        CubeDeformation def = new CubeDeformation(0.25f);
        part.addOrReplaceChild(LEFT_LEG, CubeListBuilder.create().texOffs(16, 0).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, def), PartPose.offset((float)-4.0f, (float)12.0f, (float)0.0f));
        part.addOrReplaceChild(RIGHT_LEG, CubeListBuilder.create().addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, def), PartPose.offset((float)1.9f, (float)12.0f, (float)0.0f));
        part.addOrReplaceChild(BELT, CubeListBuilder.create().texOffs(4, 16).addBox(-4.0f, 7.0f, -2.0f, 8.0f, 5.0f, 4.0f, def), PartPose.ZERO);
        return LayerDefinition.create((MeshDefinition)mesh, (int)32, (int)32);
    }

    public ClothingPantsModel(@NotNull ModelPart part) {
        this.belt = part.getChild(BELT);
        this.leftLeg = part.getChild(LEFT_LEG);
        this.rightLeg = part.getChild(RIGHT_LEG);
    }

    @Override
    @NotNull
    protected Iterable<ModelPart> getBodyModels() {
        return ImmutableList.of((Object)this.belt);
    }

    @Override
    @NotNull
    protected Iterable<ModelPart> getLeftLegModels() {
        return ImmutableList.of((Object)this.leftLeg);
    }

    @Override
    @NotNull
    protected Iterable<ModelPart> getRightLegModels() {
        return ImmutableList.of((Object)this.rightLeg);
    }
}

