/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.model.armor;

import com.google.common.collect.ImmutableList;
import de.teamlapen.vampirism.client.core.ModEntitiesRender;
import de.teamlapen.vampirism.client.model.armor.VampirismArmorModel;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import org.jetbrains.annotations.NotNull;

public class ClothingCrownModel
extends VampirismArmorModel {
    private static final String LEFT = "left";
    private static final String RIGHT = "right";
    private static final String FRONT = "front";
    private static final String BACK = "back";
    private static ClothingCrownModel instance;
    @NotNull
    public final ModelPart front;
    @NotNull
    public final ModelPart back;
    @NotNull
    public final ModelPart left;
    @NotNull
    public final ModelPart right;

    @NotNull
    public static LayerDefinition createLayer() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition part = mesh.getRoot();
        CubeDeformation def1 = new CubeDeformation(-0.2f, 0.1f, -0.1f);
        part.addOrReplaceChild(LEFT, CubeListBuilder.create().texOffs(0, 6).addBox(-5.0f, -7.7f, -4.0f, 1.0f, 1.0f, 8.0f, new CubeDeformation(-0.2f, 0.1f, 0.1f)).texOffs(12, 17).addBox(-5.0f, -8.8f, -3.7f, 1.0f, 1.0f, 2.0f, def1).texOffs(0, 17).addBox(-5.0f, -8.8f, 1.7f, 1.0f, 1.0f, 2.0f, def1).texOffs(6, 17).addBox(-5.0f, -8.8f, -1.0f, 1.0f, 1.0f, 2.0f, new CubeDeformation(-0.2f, 0.0f, 0.1f)).texOffs(13, 15).addBox(-5.0f, -9.8f, -3.25f, 1.0f, 1.0f, 1.0f, def1).texOffs(1, 15).addBox(-5.0f, -9.8f, 2.2f, 1.0f, 1.0f, 1.0f, def1).texOffs(7, 15).addBox(-5.0f, -9.8f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(-0.2f, 0.0f, -0.05f)), PartPose.ZERO);
        CubeDeformation def2 = new CubeDeformation(-0.1f, 0.0f, -0.2f);
        part.addOrReplaceChild(FRONT, CubeListBuilder.create().texOffs(0, 4).addBox(-4.0f, -7.7f, -5.0f, 8.0f, 1.0f, 1.0f, new CubeDeformation(0.1f, 0.1f, -0.2f)).texOffs(0, 2).addBox(-3.7f, -8.8f, -5.0f, 2.0f, 1.0f, 1.0f, def2).texOffs(12, 2).addBox(1.7f, -8.8f, -5.0f, 2.0f, 1.0f, 1.0f, def2).texOffs(6, 2).addBox(-1.0f, -8.8f, -5.0f, 2.0f, 1.0f, 1.0f, new CubeDeformation(0.1f, 0.0f, -0.2f)).texOffs(1, 0).addBox(-3.25f, -9.8f, -5.0f, 1.0f, 1.0f, 1.0f, def2).texOffs(13, 0).addBox(2.2f, -9.8f, -5.0f, 1.0f, 1.0f, 1.0f, def2).texOffs(7, 0).addBox(-0.5f, -9.8f, -5.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(-0.05f, 0.0f, -0.2f)), PartPose.ZERO);
        part.addOrReplaceChild(BACK, CubeListBuilder.create().texOffs(18, 4).addBox(-4.0f, -7.7f, 4.0f, 8.0f, 1.0f, 1.0f, new CubeDeformation(0.1f, 0.1f, -0.2f)).texOffs(30, 2).addBox(-3.7f, -8.8f, 4.0f, 2.0f, 1.0f, 1.0f, def2).texOffs(18, 2).addBox(1.7f, -8.8f, 4.0f, 2.0f, 1.0f, 1.0f, def2).texOffs(24, 2).addBox(-1.0f, -8.8f, 4.0f, 2.0f, 1.0f, 1.0f, new CubeDeformation(0.1f, 0.0f, -0.2f)).texOffs(31, 0).addBox(-3.25f, -9.8f, 4.0f, 1.0f, 1.0f, 1.0f, def2).texOffs(19, 0).addBox(2.2f, -9.8f, 4.0f, 1.0f, 1.0f, 1.0f, def2).texOffs(25, 0).addBox(-0.5f, -9.8f, 4.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(-0.05f, 0.0f, -0.2f)), PartPose.ZERO);
        part.addOrReplaceChild(RIGHT, CubeListBuilder.create().texOffs(18, 6).addBox(4.0f, -7.7f, -4.0f, 1.0f, 1.0f, 8.0f, new CubeDeformation(-0.2f, 0.1f, 0.1f)).texOffs(18, 17).addBox(4.0f, -8.8f, -3.7f, 1.0f, 1.0f, 2.0f, def1).texOffs(30, 17).addBox(4.0f, -8.8f, 1.7f, 1.0f, 1.0f, 2.0f, def1).texOffs(24, 17).addBox(4.0f, -8.8f, -1.0f, 1.0f, 1.0f, 2.0f, new CubeDeformation(-0.2f, 0.0f, 0.1f)).texOffs(19, 15).addBox(4.0f, -9.8f, -3.25f, 1.0f, 1.0f, 1.0f, def1).texOffs(31, 15).addBox(4.0f, -9.8f, 2.2f, 1.0f, 1.0f, 1.0f, def1).texOffs(25, 15).addBox(4.0f, -9.8f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(-0.2f, 0.0f, -0.05f)), PartPose.ZERO);
        return LayerDefinition.create((MeshDefinition)mesh, (int)64, (int)32);
    }

    public static ClothingCrownModel getAdjustedInstance(HumanoidModel<?> wearerModel) {
        if (instance == null) {
            instance = new ClothingCrownModel(Minecraft.getInstance().getEntityModels().bakeLayer(ModEntitiesRender.CLOTHING_CROWN));
        }
        instance.copyFromHumanoid(wearerModel);
        return instance;
    }

    public ClothingCrownModel(@NotNull ModelPart part) {
        this.front = part.getChild(FRONT);
        this.back = part.getChild(BACK);
        this.left = part.getChild(LEFT);
        this.right = part.getChild(RIGHT);
    }

    @Override
    @NotNull
    protected Iterable<ModelPart> getHeadModels() {
        return ImmutableList.of((Object)this.front, (Object)this.back, (Object)this.right, (Object)this.left);
    }
}

