/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import de.teamlapen.vampirism.client.model.BaronModel;
import de.teamlapen.vampirism.client.model.BaronessModel;
import de.teamlapen.vampirism.entity.vampire.VampireBaronEntity;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.NotNull;

public class BaronWrapperModel
extends EntityModel<VampireBaronEntity> {
    private final BaronModel baron;
    private final BaronessModel baroness;
    private boolean lady = false;

    public BaronWrapperModel(BaronModel baron, BaronessModel baroness) {
        this.baron = baron;
        this.baroness = baroness;
    }

    @NotNull
    public ModelPart getBodyPart(@NotNull VampireBaronEntity entityIn) {
        return entityIn.isLady() ? this.baroness.body : this.baron.body;
    }

    public void prepareMobModel(@NotNull VampireBaronEntity entityIn, float limbSwing, float limbSwingAmount, float partialTick) {
        this.lady = entityIn.isLady();
        AgeableListModel model = this.lady ? this.baroness : this.baron;
        this.copyPropertiesTo((EntityModel)model);
        model.prepareMobModel((Entity)entityIn, limbSwing, limbSwingAmount, partialTick);
    }

    public void renderToBuffer(@NotNull PoseStack matrixStackIn, @NotNull VertexConsumer bufferIn, int packedLightIn, int packedOverlayIn, int color) {
        AgeableListModel model = this.lady ? this.baroness : this.baron;
        model.renderToBuffer(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, color);
    }

    public void setupAnim(@NotNull VampireBaronEntity entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        AgeableListModel model = entityIn.isLady() ? this.baroness : this.baron;
        model.setupAnim((Entity)entityIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
    }
}

