/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.gui.screens.taskboard;

import com.google.common.collect.Lists;
import de.teamlapen.lib.lib.client.gui.components.ContainerObjectSelectionListWithDummy;
import de.teamlapen.lib.lib.util.MultilineTooltip;
import de.teamlapen.vampirism.api.VampirismRegistries;
import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import de.teamlapen.vampirism.api.entity.player.task.ITaskInstance;
import de.teamlapen.vampirism.api.entity.player.task.ITaskRewardInstance;
import de.teamlapen.vampirism.api.entity.player.task.Task;
import de.teamlapen.vampirism.api.entity.player.task.TaskRequirement;
import de.teamlapen.vampirism.api.util.VResourceLocation;
import de.teamlapen.vampirism.entity.player.tasks.req.ItemRequirement;
import de.teamlapen.vampirism.entity.player.tasks.reward.ItemReward;
import de.teamlapen.vampirism.inventory.TaskMenu;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.inventory.tooltip.DefaultTooltipPositioner;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TaskList
extends ContainerObjectSelectionListWithDummy<ITaskInstance, TaskEntry, DummyEntry> {
    protected static final ResourceLocation TASKMASTER_GUI_TEXTURE = VResourceLocation.mod("textures/gui/taskmaster.png");
    private static final WidgetSprites ACCEPT = new WidgetSprites(VResourceLocation.mod("widget/task_action_accept"), VResourceLocation.mod("widget/task_action_accept_highlighted"));
    private static final WidgetSprites COMPLETE = new WidgetSprites(VResourceLocation.mod("widget/task_action_complete"), VResourceLocation.mod("widget/task_action_complete_highlighted"));
    private static final WidgetSprites ABORT = new WidgetSprites(VResourceLocation.mod("widget/task_action_abort"), VResourceLocation.mod("widget/task_action_abort_highlighted"));
    protected final TaskMenu menu;
    protected final IFactionPlayer<?> factionPlayer;
    protected final Registry<Task> registry;

    public TaskList(Minecraft minecraft, TaskMenu menu, IFactionPlayer<?> factionPlayer, int x, int y, int width, int height, Supplier<List<ITaskInstance>> itemSupplier) {
        super(minecraft, width, height, y, 21, itemSupplier);
        this.menu = menu;
        this.factionPlayer = factionPlayer;
        this.registry = factionPlayer.asEntity().level().registryAccess().registryOrThrow(VampirismRegistries.Keys.TASK);
        this.setX(x);
    }

    @Override
    protected TaskEntry createItem(ITaskInstance item) {
        return new TaskEntry(item);
    }

    @Override
    protected DummyEntry createDummy(ITaskInstance item) {
        return new DummyEntry(item);
    }

    protected void renderListSeparators(GuiGraphics p_331248_) {
    }

    @Override
    protected boolean isEquivalent(ITaskInstance item1, ITaskInstance item2) {
        return Objects.equals(item1.getId(), item2.getId());
    }

    public class TaskEntry
    extends ContainerObjectSelectionListWithDummy.ItemEntry {
        private final Task task;
        private final Tooltip tooltip;

        public TaskEntry(ITaskInstance item) {
            super(TaskList.this, item);
            this.task = (Task)TaskList.this.registry.get(item.getTask());
            this.tooltip = this.generateTaskToolTip();
        }

        @NotNull
        public List<? extends NarratableEntry> narratables() {
            return Collections.emptyList();
        }

        public void renderBackground(GuiGraphics graphics, Minecraft minecraft, int pTop, int pLeft, int pWidth, int pHeight, int mouseX, int mouseY, float partialTicks) {
            if (TaskList.this.menu.isCompleted((ITaskInstance)this.getItem())) {
                graphics.setColor(0.4f, 0.4f, 0.4f, 1.0f);
            } else {
                boolean remainsTime;
                boolean isUnique = ((ITaskInstance)this.getItem()).isUnique(TaskList.this.menu.getRegistry());
                boolean bl = remainsTime = ((ITaskInstance)this.getItem()).getTaskTimeStamp() - minecraft.level.getGameTime() > 0L;
                if (TaskList.this.menu.canCompleteTask((ITaskInstance)this.getItem())) {
                    if (isUnique) {
                        graphics.setColor(1.0f, 0.8558594f, 0.0f, 1.0f);
                    } else {
                        graphics.setColor(0.0f, 0.9f, 0.0f, 1.0f);
                    }
                } else if (TaskList.this.menu.isTaskNotAccepted((ITaskInstance)this.getItem())) {
                    if (isUnique) {
                        graphics.setColor(0.64f, 0.57f, 0.5f, 1.0f);
                    } else {
                        graphics.setColor(0.55f, 0.55f, 0.55f, 1.0f);
                    }
                } else if (!isUnique && !remainsTime) {
                    graphics.setColor(1.0f, 0.33333334f, 0.33333334f, 1.0f);
                } else if (isUnique) {
                    graphics.setColor(1.0f, 0.9f, 0.6f, 1.0f);
                } else {
                    graphics.setColor(0.85f, 1.0f, 0.85f, 1.0f);
                }
            }
            graphics.blit(TASKMASTER_GUI_TEXTURE, pLeft, pTop, 0, 17.0f, 187.0f, Math.min(pWidth - 1, 135), pHeight, 256, 256);
            graphics.blit(TASKMASTER_GUI_TEXTURE, pLeft + pWidth - Math.min(pWidth - 1, 135), pTop, 0, (float)(17 + (135 - Math.min(pWidth - 1, 134))), 187.0f, Math.min(pWidth - 1, 135), pHeight, 256, 256);
            graphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        }

        public void render(GuiGraphics graphics, int pIndex, int pTop, int pLeft, int pWidth, int pHeight, int pMouseX, int pMouseY, boolean pIsMouseOver, float pPartialTick) {
            Minecraft mc = Minecraft.getInstance();
            this.renderBackground(graphics, mc, pTop, pLeft, pWidth, pHeight + 4, pMouseX, pMouseY, pPartialTick);
            Optional<FormattedCharSequence> text = Optional.ofNullable((FormattedCharSequence)mc.font.split((FormattedText)this.task.getTitle(), 131).getFirst());
            text.ifPresent(t -> graphics.drawString(mc.font, t, pLeft + 2, pTop + 4, 3419941, false));
            if (!TaskList.this.menu.isTaskNotAccepted((ITaskInstance)this.getItem()) && !((ITaskInstance)this.getItem()).isUnique(TaskList.this.menu.getRegistry())) {
                MutableComponent msg;
                long remainingTime = ((ITaskInstance)this.getItem()).getTaskTimeStamp() - Minecraft.getInstance().level.getGameTime();
                if (remainingTime >= 0L) {
                    long hours = (remainingTime /= 20L) / 60L / 60L;
                    long minutes = remainingTime / 60L % 60L;
                    long seconds = remainingTime % 60L;
                    String time = hours + ":";
                    if (minutes < 10L) {
                        time = time + "0";
                    }
                    time = time + minutes + ":";
                    if (seconds < 10L) {
                        time = time + "0";
                    }
                    time = time + seconds;
                    msg = Component.literal((String)time);
                } else {
                    msg = Component.translatable((String)"text.vampirism.task_failed");
                }
                int width = mc.font.width((FormattedText)msg);
                int color = 0xAAAAAA;
                if ((float)remainingTime < (float)((ITaskInstance)this.getItem()).getTaskDuration() / 20.0f * 0.1f) {
                    color = 0xFF5555;
                }
                graphics.drawString(mc.font, (Component)msg, pLeft + pWidth - width - 1, pTop + 12, color, true);
            }
            if (this.isMouseOver(pMouseX, pMouseY + 3)) {
                this.renderToolTips(mc, pMouseX, pMouseY);
            }
        }

        protected void renderToolTips(Minecraft minecraft, int mouseX, int mouseY) {
            minecraft.screen.setTooltipForNextRenderPass(this.tooltip, DefaultTooltipPositioner.INSTANCE, this.isFocused());
        }

        @NotNull
        public List<? extends GuiEventListener> children() {
            return Collections.emptyList();
        }

        private Tooltip generateTaskToolTip() {
            Task task = TaskList.this.menu.getTask(((ITaskInstance)this.getItem()).getTask());
            ArrayList<Component> toolTips = new ArrayList<Component>();
            toolTips.add((Component)this.task.getTitle().plainCopy().withStyle(style -> style.withColor(TaskList.this.menu.getFactionColor())));
            task.getDescription().ifPresent(component -> {
                toolTips.add((Component)component);
                toolTips.add((Component)Component.literal((String)" "));
            });
            if (TaskList.this.menu.isTaskNotAccepted((ITaskInstance)this.getItem())) {
                toolTips.add((Component)Component.translatable((String)"gui.vampirism.taskmaster.not_accepted"));
            } else {
                for (List<TaskRequirement.Requirement<?>> requirements : task.getRequirement().requirements().values()) {
                    if (requirements == null) continue;
                    TaskRequirement.Type type = requirements.getFirst().getType();
                    boolean completed = TaskList.this.menu.areRequirementsCompleted((ITaskInstance)this.getItem(), type);
                    MutableComponent title = Component.translatable((String)type.getTranslationKey()).append(":");
                    if (completed) {
                        title.withStyle(ChatFormatting.STRIKETHROUGH);
                    }
                    toolTips.add((Component)title);
                    for (TaskRequirement.Requirement<?> requirement : requirements) {
                        int completedAmount = TaskList.this.menu.getRequirementStatus((ITaskInstance)this.getItem(), requirement);
                        MutableComponent desc = switch (type) {
                            case TaskRequirement.Type.ITEMS -> ((Item)requirement.getStat(TaskList.this.factionPlayer)).getDescription().plainCopy();
                            default -> requirement.description().plainCopy();
                        };
                        desc = desc.append(" " + completedAmount + "/" + requirement.getAmount(TaskList.this.factionPlayer));
                        if (completed || TaskList.this.menu.isRequirementCompleted((ITaskInstance)this.getItem(), requirement)) {
                            desc.withStyle(ChatFormatting.STRIKETHROUGH);
                        }
                        toolTips.add((Component)Component.literal((String)"  ").append((Component)desc));
                    }
                }
            }
            return new MultilineTooltip(toolTips);
        }
    }

    public class DummyEntry
    extends ContainerObjectSelectionListWithDummy.DummyEntry {
        private final List<AbstractWidget> children;

        public DummyEntry(ITaskInstance item) {
            super(TaskList.this, item);
            this.children = new ArrayList<AbstractWidget>();
            List<TaskRequirement.Requirement<?>> all = TaskList.this.menu.getTask(item.getTask()).getRequirement().getAll();
            for (int i = 0; i < all.size(); ++i) {
                this.children.add(new RequirementWidget(6 + i * 20, 3, item, all.get(i)));
            }
            this.children.add(new RewardWidget(this, 3 + TaskList.this.getRowWidth() - 45, 3, item));
            this.children.add((AbstractWidget)new TaskActionButton(TaskList.this.getRowWidth() - 25, 4));
        }

        @NotNull
        public List<? extends NarratableEntry> narratables() {
            return this.children;
        }

        public void render(@NotNull GuiGraphics graphics, int pIndex, int pTop, int pLeft, int pWidth, int pHeight, int pMouseX, int pMouseY, boolean pIsMouseOver, float pPartialTick) {
            this.renderBg(graphics, pIndex, pTop, pLeft, pWidth, pHeight + 4, pMouseX, pMouseY, pIsMouseOver, pPartialTick);
            this.children.forEach(w -> ((MovableWidget)w).setOffset(pLeft, pTop));
            this.children.forEach(a -> a.render(graphics, pMouseX, pMouseY, pPartialTick));
            this.children.stream().filter(x -> x.isMouseOver((double)pMouseX, (double)pMouseY)).findFirst().ifPresent(w -> {
                if (w.getTooltip() != null) {
                    ((TaskList)TaskList.this).minecraft.screen.setTooltipForNextRenderPass(w.getTooltip(), DefaultTooltipPositioner.INSTANCE, w.isFocused());
                }
            });
        }

        protected void renderBg(@NotNull GuiGraphics graphics, int pIndex, int pTop, int pLeft, int pWidth, int pHeight, int pMouseX, int pMouseY, boolean pIsMouseOver, float pPartialTick) {
            graphics.blitWithBorder(TASKMASTER_GUI_TEXTURE, pLeft + 2, pTop, 17, 229, pWidth - 4, pHeight, 136, 21, 1, 2, 3, 2);
            graphics.blitWithBorder(TASKMASTER_GUI_TEXTURE, pLeft + pWidth - 40, pTop, 17, 229, 38, pHeight, 136, 21, 1, 2, 3, 2);
        }

        @NotNull
        public List<? extends GuiEventListener> children() {
            return this.children;
        }

        private class RequirementWidget
        extends ItemWidget {
            protected static final Component REQUIREMENT = Component.translatable((String)"gui.vampirism.taskmaster.requirement").withStyle(ChatFormatting.UNDERLINE);
            protected static final Component REQUIREMENT_STRIKE = REQUIREMENT.plainCopy().withStyle(ChatFormatting.STRIKETHROUGH);
            private final TaskRequirement.Requirement<?> requirement;
            private final ITaskInstance instance;
            protected static final ItemStack SKULL_ITEM = new ItemStack((ItemLike)Blocks.SKELETON_SKULL);

            public RequirementWidget(int pX, int pY, @NotNull ITaskInstance instance, TaskRequirement.Requirement<?> requirement) {
                super(pX, pY, switch (requirement.getType()) {
                    case TaskRequirement.Type.ITEMS -> ((ItemRequirement)requirement).getItemStack();
                    case TaskRequirement.Type.ENTITY, TaskRequirement.Type.ENTITY_TAG -> SKULL_ITEM;
                    default -> PAPER;
                });
                this.requirement = requirement;
                this.instance = instance;
                this.setTooltip(new MultilineTooltip(this.createTooltip(Item.TooltipContext.of((Level)Minecraft.getInstance().level))));
            }

            @Override
            protected List<Component> createTooltip(Item.TooltipContext tooltipContext) {
                boolean notAccepted = TaskList.this.menu.isTaskNotAccepted(this.instance);
                boolean completed = TaskList.this.menu.isRequirementCompleted(this.instance, this.requirement);
                int completedAmount = TaskList.this.menu.getRequirementStatus(this.instance, this.requirement);
                return switch (this.requirement.getType()) {
                    case TaskRequirement.Type.ITEMS -> this.renderItemTooltip(((ItemRequirement)this.requirement).getItemStack(), completed ? REQUIREMENT_STRIKE : REQUIREMENT, tooltipContext, completed, notAccepted ? null : completedAmount + "/");
                    case TaskRequirement.Type.ENTITY, TaskRequirement.Type.ENTITY_TAG, TaskRequirement.Type.STATS -> this.renderGenericRequirementTooltip(this.requirement.getType(), this.requirement.description().plainCopy().append((String)(notAccepted ? " " : " " + completedAmount + "/") + this.requirement.getAmount(TaskList.this.factionPlayer)), completed);
                    default -> this.renderDefaultRequirementToolTip(this.instance, this.requirement, completed);
                };
            }

            private List<Component> renderDefaultRequirementToolTip(@NotNull ITaskInstance task,  @NotNull TaskRequirement.Requirement<?> requirement, boolean strikeThrough) {
                ArrayList tooltips = Lists.newArrayList();
                tooltips.add(strikeThrough ? REQUIREMENT_STRIKE : REQUIREMENT);
                MutableComponent text = requirement.description().plainCopy();
                if (strikeThrough) {
                    text.withStyle(ChatFormatting.STRIKETHROUGH);
                }
                tooltips.add(text);
                return tooltips;
            }

            private List<Component> renderGenericRequirementTooltip( @NotNull TaskRequirement.Type type, @NotNull MutableComponent text, boolean strikeThrough) {
                ArrayList tooltips = Lists.newArrayList();
                MutableComponent title = Component.translatable((String)type.getTranslationKey()).append(":");
                if (strikeThrough) {
                    text.withStyle(ChatFormatting.STRIKETHROUGH);
                    title.withStyle(ChatFormatting.STRIKETHROUGH);
                }
                tooltips.add(strikeThrough ? REQUIREMENT_STRIKE : REQUIREMENT);
                tooltips.add(title.withStyle(ChatFormatting.ITALIC));
                tooltips.add(Component.literal((String)"  ").append((Component)text));
                return tooltips;
            }
        }

        private class RewardWidget
        extends ItemWidget {
            protected static final Component REWARD = Component.translatable((String)"gui.vampirism.taskmaster.reward").withStyle(ChatFormatting.UNDERLINE);
            private final ITaskInstance rewardInstance;
            private final Component reward;

            public RewardWidget(DummyEntry dummyEntry, int pX, @NotNull int pY, ITaskInstance rewardInstance) {
                ItemStack itemStack;
                ITaskRewardInstance iTaskRewardInstance = rewardInstance.getReward();
                if (iTaskRewardInstance instanceof ItemReward.Instance) {
                    ItemReward.Instance items = (ItemReward.Instance)iTaskRewardInstance;
                    itemStack = items.reward();
                } else {
                    itemStack = PAPER;
                }
                super(pX, pY, itemStack);
                this.rewardInstance = rewardInstance;
                this.reward = Component.translatable((String)(Util.makeDescriptionId((String)"task", (ResourceLocation)rewardInstance.getTask().location()) + ".reward"));
                this.setTooltip(new MultilineTooltip(this.createTooltip(Item.TooltipContext.of((Level)Minecraft.getInstance().level))));
            }

            @Override
            protected List<Component> createTooltip(Item.TooltipContext tooltipContext) {
                Item.TooltipContext context = Item.TooltipContext.of((Level)Minecraft.getInstance().level);
                ITaskRewardInstance iTaskRewardInstance = this.rewardInstance.getReward();
                if (iTaskRewardInstance instanceof ItemReward.Instance) {
                    ItemReward.Instance item = (ItemReward.Instance)iTaskRewardInstance;
                    return this.renderItemTooltip(item.reward(), REWARD, context, false, null);
                }
                return this.renderItemTooltip(context);
            }

            private List<Component> renderItemTooltip(Item.TooltipContext context) {
                ArrayList tooltips = Lists.newArrayList((Object[])new Component[]{REWARD});
                tooltips.add(this.reward);
                return tooltips;
            }
        }

        private class TaskActionButton
        extends ImageButton
        implements MovableWidget {
            private int xOffset;
            private int yOffset;

            public TaskActionButton(int xPos, int yPos) {
                super(xPos, yPos, 14, 13, ACCEPT, a -> de$teamlapen$vampirism$client$gui$screens$taskboard$TaskList$this.menu.pressButton((ITaskInstance)DummyEntry.this.getItem()), (Component)Component.literal((String)""));
            }

            @Override
            public void setOffset(int x, int y) {
                this.xOffset = x;
                this.yOffset = y;
            }

            public int getX() {
                return super.getX() + this.xOffset;
            }

            public int getY() {
                return super.getY() + this.yOffset;
            }

            public void onClick(double mouseX, double mouseY) {
                if (mouseX > (double)this.getX() && mouseX < (double)(this.getX() + this.width) && mouseY > (double)this.getY() && mouseY < (double)(this.getY() + this.height)) {
                    super.onClick(mouseX, mouseY);
                }
            }

            public void renderWidget(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float p_renderButton_3_) {
                TaskMenu.TaskAction action = TaskList.this.menu.buttonAction((ITaskInstance)DummyEntry.this.getItem());
                WidgetSprites sprites = switch (action) {
                    case TaskMenu.TaskAction.ACCEPT -> ACCEPT;
                    case TaskMenu.TaskAction.COMPLETE -> COMPLETE;
                    default -> ABORT;
                };
                graphics.blitSprite(sprites.get(this.active, this.isHovered), this.getX(), this.getY(), this.width, this.height);
                if (this.isHovered) {
                    this.setTooltip(Tooltip.create((Component)Component.translatable((String)action.getTranslationKey())));
                }
            }
        }

        private static interface MovableWidget {
            public void setOffset(int var1, int var2);
        }

        private static abstract class ItemWidget
        extends AbstractWidget
        implements MovableWidget {
            protected static final ItemStack PAPER = new ItemStack((ItemLike)Items.PAPER);
            private final ItemStack stack;
            private int xOffset;
            private int yOffset;

            public ItemWidget(int pX, int pY, ItemStack stack) {
                super(pX, pY, 16, 16, (Component)Component.empty());
                this.stack = stack;
            }

            @Override
            public void setOffset(int x, int y) {
                this.xOffset = x;
                this.yOffset = y;
            }

            public int getX() {
                return super.getX() + this.xOffset;
            }

            public int getY() {
                return super.getY() + this.yOffset;
            }

            public void renderWidget(@NotNull GuiGraphics graphics, int pMouseX, int pMouseY, float pPartialTick) {
                graphics.renderFakeItem(this.stack, this.getX(), this.getY());
            }

            public void setX(int p_254495_) {
                super.setX(p_254495_);
            }

            protected void updateWidgetNarration(@NotNull NarrationElementOutput output) {
            }

            protected abstract List<Component> createTooltip(Item.TooltipContext var1);

            protected List<Component> renderItemTooltip(@NotNull ItemStack stack, Component text, Item.TooltipContext context, boolean strikeThrough, @Nullable String bonus) {
                List<Component> tooltips = this.getTooltipFromItem2(context, stack, strikeThrough, bonus);
                tooltips.addFirst(text);
                return tooltips;
            }

            @NotNull
            protected List<Component> getTooltipFromItem2(Item.TooltipContext context, @NotNull ItemStack itemStack, boolean strikeThough, @Nullable String bonus) {
                List list = itemStack.getTooltipLines(context, (Player)Minecraft.getInstance().player, (TooltipFlag)(Minecraft.getInstance().options.advancedItemTooltips ? TooltipFlag.Default.ADVANCED : TooltipFlag.Default.NORMAL));
                ArrayList list1 = Lists.newArrayList();
                for (int i = 0; i < list.size(); ++i) {
                    if (i == 0) {
                        MutableComponent t = ((Component)list.getFirst()).copy().append(" " + (bonus != null ? bonus : "") + itemStack.getCount());
                        if (strikeThough) {
                            t.withStyle(ChatFormatting.STRIKETHROUGH);
                        }
                        list1.add(t);
                        continue;
                    }
                    list1.add(strikeThough ? ((Component)list.get(i)).copy().withStyle(ChatFormatting.STRIKETHROUGH) : (Component)list.get(i));
                }
                return list1;
            }
        }
    }
}

