/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.gui.screens;

import de.teamlapen.lib.lib.client.gui.components.HoverList;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.client.gui.screens.AppearanceScreen;
import de.teamlapen.vampirism.client.renderer.entity.VampireMinionRenderer;
import de.teamlapen.vampirism.entity.minion.VampireMinionEntity;
import de.teamlapen.vampirism.entity.minion.management.MinionData;
import de.teamlapen.vampirism.network.ServerboundAppearancePacket;
import java.util.stream.IntStream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Checkbox;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.neoforged.neoforge.client.gui.widget.ExtendedButton;

public class VampireMinionAppearanceScreen
extends AppearanceScreen<VampireMinionEntity> {
    private static final Component NAME = Component.translatable((String)"gui.vampirism.minion_appearance");
    private int skinType;
    private boolean useLordSkin;
    private boolean isMinionSpecificSkin;
    private HoverList<?> typeList;
    private ExtendedButton typeButton;
    private Checkbox lordSkinButton;
    private EditBox nameWidget;
    private int normalSkinCount;
    private int minionSkinCount;

    public VampireMinionAppearanceScreen(VampireMinionEntity minion, Screen backScreen) {
        super(NAME, minion, backScreen);
    }

    public void removed() {
        Object name = this.nameWidget.getValue();
        if (((String)name).isEmpty()) {
            name = Component.translatable((String)"text.vampirism.minion").getString() + String.valueOf(((VampireMinionEntity)this.entity).getMinionId().orElse(0));
        }
        VampirismMod.proxy.sendToServer(new ServerboundAppearancePacket(((VampireMinionEntity)this.entity).getId(), (String)name, this.skinType, (this.isMinionSpecificSkin ? 2 : 0) | (this.useLordSkin ? 1 : 0)));
        super.removed();
    }

    @Override
    protected void init() {
        super.init();
        this.nameWidget = (EditBox)this.addRenderableWidget((GuiEventListener)new EditBox(this.font, this.guiLeft + 21, this.guiTop + 29, 98, 12, (Component)Component.translatable((String)"gui.vampirism.minion_appearance.name")));
        this.nameWidget.setValue(((VampireMinionEntity)this.entity).getMinionData().map(MinionData::getName).orElse("Minion"));
        this.nameWidget.setTextColorUneditable(-1);
        this.nameWidget.setTextColor(-1);
        this.nameWidget.setMaxLength(15);
        this.nameWidget.setResponder(this::onNameChanged);
        this.normalSkinCount = ((VampireMinionRenderer)Minecraft.getInstance().getEntityRenderDispatcher().getRenderer((Entity)((VampireMinionEntity)this.entity))).getVampireTextureCount();
        this.minionSkinCount = ((VampireMinionRenderer)Minecraft.getInstance().getEntityRenderDispatcher().getRenderer((Entity)((VampireMinionEntity)this.entity))).getMinionSpecificTextureCount();
        this.skinType = ((VampireMinionEntity)this.entity).getVampireType();
        this.isMinionSpecificSkin = ((VampireMinionEntity)this.entity).hasMinionSpecificSkin();
        if (this.isMinionSpecificSkin && this.minionSkinCount > 0) {
            this.skinType %= this.minionSkinCount;
        } else {
            this.skinType %= this.normalSkinCount;
            this.isMinionSpecificSkin = false;
        }
        this.useLordSkin = ((VampireMinionEntity)this.entity).shouldRenderLordSkin();
        this.lordSkinButton = (Checkbox)this.addRenderableWidget((GuiEventListener)Checkbox.builder((Component)Component.translatable((String)"gui.vampirism.minion_appearance.use_lord_skin"), (Font)this.minecraft.font).pos(this.guiLeft + 20, this.guiTop + 64).selected(this.useLordSkin).onValueChange((button, selected) -> {
            this.useLordSkin = selected;
            ((VampireMinionEntity)this.entity).setUseLordSkin(this.useLordSkin);
        }).build());
        this.typeList = (HoverList)this.addRenderableWidget((GuiEventListener)HoverList.builder(this.guiLeft + 20, this.guiTop + 43 + 19, 99, 80).componentsWithClickAndHover(IntStream.range(0, this.normalSkinCount + this.minionSkinCount).mapToObj(type -> Component.translatable((String)"gui.vampirism.minion_appearance.skin").append(" " + (type + 1))).toList(), this::skin, this::previewSkin).build());
        this.typeButton = (ExtendedButton)this.addRenderableWidget((GuiEventListener)new ExtendedButton(this.typeList.getX(), this.typeList.getY() - 20, this.typeList.getWidth(), 20, (Component)Component.literal((String)""), button1 -> this.setListVisibility(!this.typeList.visible)));
        this.setListVisibility(false);
    }

    private void onNameChanged(String newName) {
        ((VampireMinionEntity)this.entity).changeMinionName(newName);
    }

    private void previewSkin(int type, boolean hovered) {
        boolean minionSpecific;
        boolean bl = minionSpecific = type >= this.normalSkinCount;
        if (hovered) {
            ((VampireMinionEntity)this.entity).setVampireType(type, minionSpecific);
        } else if (((VampireMinionEntity)this.entity).getVampireType() == type && ((VampireMinionEntity)this.entity).hasMinionSpecificSkin() == minionSpecific) {
            ((VampireMinionEntity)this.entity).setVampireType(this.skinType, this.isMinionSpecificSkin);
        }
    }

    private void setListVisibility(boolean show) {
        this.typeButton.setMessage((Component)Component.translatable((String)"gui.vampirism.minion_appearance.skin").append(" " + (this.skinType + 1)));
        this.typeList.visible = show;
        this.lordSkinButton.visible = !show;
    }

    private void skin(int type) {
        boolean minionSpecific = type >= this.normalSkinCount;
        this.skinType = type;
        this.isMinionSpecificSkin = minionSpecific;
        ((VampireMinionEntity)this.entity).setVampireType(this.skinType, this.isMinionSpecificSkin);
        this.setListVisibility(false);
    }
}

