/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.gui.screens;

import de.teamlapen.lib.lib.client.gui.screens.radialmenu.GuiRadialMenu;
import de.teamlapen.lib.lib.client.gui.screens.radialmenu.IRadialMenuSlot;
import de.teamlapen.lib.lib.client.gui.screens.radialmenu.RadialMenu;
import de.teamlapen.lib.lib.client.gui.screens.radialmenu.RadialMenuSlot;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.items.IVampirismCrossbow;
import de.teamlapen.vampirism.api.util.VResourceLocation;
import de.teamlapen.vampirism.items.crossbow.CrossbowArrowHandler;
import de.teamlapen.vampirism.network.ServerboundSelectAmmoTypePacket;
import de.teamlapen.vampirism.util.Helper;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class SelectAmmoScreen
extends GuiRadialMenu<AmmoType> {
    private static final ResourceLocation NO_RESTRICTION = VResourceLocation.mc("spectator/close");

    public SelectAmmoScreen(Collection<AmmoType> ammoTypes) {
        super(SelectAmmoScreen.getRadialMenu(ammoTypes), true);
    }

    public static void show() {
        IVampirismCrossbow crossbow;
        Item item;
        LocalPlayer player = Minecraft.getInstance().player;
        ItemStack crossbowStack = player.getMainHandItem();
        if (Helper.isHunter((Player)player) && (item = crossbowStack.getItem()) instanceof IVampirismCrossbow && (crossbow = (IVampirismCrossbow)item).canSelectAmmunition(crossbowStack)) {
            List<AmmoType> ammoTypes = CrossbowArrowHandler.getCrossbowArrows().stream().map(arg_0 -> SelectAmmoScreen.lambda$show$0((Player)player, arg_0)).collect(Collectors.toList());
            ammoTypes.add(new AmmoType(null, 0));
            Minecraft.getInstance().setScreen((Screen)new SelectAmmoScreen(ammoTypes));
        }
    }

    private static RadialMenu<AmmoType> getRadialMenu(Collection<AmmoType> ammoTypes) {
        List parts = ammoTypes.stream().map(a -> new RadialMenuSlot<AmmoType>(a.getDisplayName(), (AmmoType)a)).toList();
        return new RadialMenu<AmmoType>(i -> VampirismMod.proxy.sendToServer(ServerboundSelectAmmoTypePacket.of((AmmoType)((IRadialMenuSlot)parts.get(i)).primarySlotIcon())), parts, SelectAmmoScreen::drawAmmoTypePart, 0);
    }

    private static void drawAmmoTypePart(AmmoType action, GuiGraphics graphics, int posX, int posY, int size, boolean transparent) {
        if (action.renderStack != null) {
            graphics.renderItem(action.renderStack, posX, posY);
            graphics.renderItemDecorations(Minecraft.getInstance().screen.font, action.renderStack, posX, posY, String.valueOf(action.count));
        } else {
            graphics.blitSprite(NO_RESTRICTION, posX, posY, 16, 16);
        }
    }

    @Override
    public void drawSliceName(GuiGraphics graphics, String sliceName, ItemStack stack, int posX, int posY) {
    }

    private static /* synthetic */ AmmoType lambda$show$0(Player player, Item item) {
        return new AmmoType(item, player.getInventory().countItem(item));
    }

    public static class AmmoType {
        public final ItemStack renderStack;
        public final int count;

        public AmmoType(@Nullable Item item, int count) {
            this.count = count;
            this.renderStack = item == null ? null : item.getDefaultInstance();
        }

        public Component getDisplayName() {
            return this.renderStack != null ? this.renderStack.getHoverName() : Component.translatable((String)"text.vampirism.crossbow.no_restriction");
        }
    }
}

