/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.gui.screens;

import de.teamlapen.vampirism.api.util.VResourceLocation;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.entity.player.hunter.HunterLeveling;
import de.teamlapen.vampirism.inventory.HunterTableMenu;
import de.teamlapen.vampirism.items.PureBloodItem;
import de.teamlapen.vampirism.items.VampireBookItem;
import de.teamlapen.vampirism.items.VampireFangItem;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.CyclingSlotBackground;
import net.minecraft.client.gui.screens.inventory.ItemCombinerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.ItemCombinerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import org.jetbrains.annotations.NotNull;

public class HunterTableScreen
extends ItemCombinerScreen<HunterTableMenu> {
    private static final ResourceLocation BACKGROUND = VResourceLocation.mod("textures/gui/container/hunter_table.png");
    private static final ResourceLocation EMPTY_BOOK = VResourceLocation.mod("item/empty_book");
    private static final ResourceLocation EMPTY_FANG = VResourceLocation.mod("item/empty_vampire_fang");
    private static final ResourceLocation EMPTY_PURE_BLOOD = VResourceLocation.mod("item/empty_pure_blood");
    private static final ResourceLocation EMPTY_VAMPIRE_BOOK = VResourceLocation.mod("item/empty_vampire_book");
    private final CyclingSlotBackground bookIcon = new CyclingSlotBackground(0);
    private final CyclingSlotBackground fangsIcon = new CyclingSlotBackground(1);
    private final CyclingSlotBackground bloodIcon = new CyclingSlotBackground(2);
    private final CyclingSlotBackground vampireBookIcon = new CyclingSlotBackground(3);

    public HunterTableScreen(@NotNull HunterTableMenu inventorySlotsIn, @NotNull Inventory playerInventory, @NotNull Component name) {
        super((ItemCombinerMenu)inventorySlotsIn, playerInventory, name, BACKGROUND);
    }

    protected void containerTick() {
        super.containerTick();
        Optional<HunterLeveling.HunterTableRequirement> requirement = ((HunterTableMenu)this.menu).getTableRequirement();
        this.bookIcon.tick(requirement.filter(s -> s.bookQuantity() > 0).map(s -> List.of(EMPTY_BOOK)).orElse(List.of()));
        this.fangsIcon.tick(requirement.filter(s -> s.vampireFangQuantity() > 0).map(s -> List.of(EMPTY_FANG)).orElse(List.of()));
        this.bloodIcon.tick(requirement.filter(s -> s.pureBloodQuantity() > 0).map(s -> List.of(EMPTY_PURE_BLOOD)).orElse(List.of()));
        this.vampireBookIcon.tick(requirement.filter(s -> s.vampireBookQuantity() > 0).map(s -> List.of(EMPTY_VAMPIRE_BOOK)).orElse(List.of()));
    }

    public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.render(graphics, mouseX, mouseY, partialTicks);
        this.renderOnBoardingTooltips(graphics, mouseX, mouseY);
    }

    private void renderOnBoardingTooltips(GuiGraphics graphics, int pMouseX, int pMouseY) {
        if (this.hoveredSlot != null && this.hoveredSlot.index < 4) {
            ItemStack stack;
            Optional<Object> optional = Optional.empty();
            Optional<HunterLeveling.HunterTableRequirement> req = ((HunterTableMenu)this.menu).getTableRequirement();
            Integer missing = req.map(arg_0 -> this.lambda$renderOnBoardingTooltips$8(stack = this.hoveredSlot.getItem(), arg_0)).orElse(0);
            if (missing > 0) {
                Object[] objectArray = new Object[2];
                objectArray[0] = missing;
                objectArray[1] = switch (this.hoveredSlot.index) {
                    case 0 -> Items.BOOK.getDefaultInstance().getHoverName();
                    case 1 -> ((VampireFangItem)((Object)ModItems.VAMPIRE_FANG.get())).getDefaultInstance().getHoverName();
                    case 2 -> req.map(HunterLeveling.HunterTableRequirement::pureBloodLevel).map(PureBloodItem::getBloodItemForLevel).map(PureBloodItem::getCustomName).orElseGet(Component::empty);
                    case 3 -> ((VampireBookItem)ModItems.VAMPIRE_BOOK.get()).getDefaultInstance().getHoverName();
                    default -> throw new IllegalStateException("Unexpected value: " + this.hoveredSlot.index);
                };
                optional = Optional.of(Component.translatable((String)"text.vampirism.hunter_table.ritual_missing_items", (Object[])objectArray));
            }
            optional.ifPresent(component -> graphics.renderTooltip(this.font, this.font.split((FormattedText)component, 115), pMouseX, pMouseY));
        }
    }

    protected void renderBg(@NotNull GuiGraphics graphics, float pPartialTick, int pX, int pY) {
        super.renderBg(graphics, pPartialTick, pX, pY);
        this.bookIcon.render(this.menu, graphics, pPartialTick, this.leftPos, this.topPos);
        this.fangsIcon.render(this.menu, graphics, pPartialTick, this.leftPos, this.topPos);
        this.bloodIcon.render(this.menu, graphics, pPartialTick, this.leftPos, this.topPos);
        this.vampireBookIcon.render(this.menu, graphics, pPartialTick, this.leftPos, this.topPos);
    }

    protected void renderErrorIcon(@NotNull GuiGraphics graphics, int mouseX, int mouseY) {
        Optional<Object> component = Optional.empty();
        Optional<HunterLeveling.HunterTableRequirement> requirement = ((HunterTableMenu)this.menu).getRequirement();
        if (requirement.isEmpty()) {
            component = Optional.of(Component.translatable((String)"container.vampirism.hunter_table.level_wrong"));
        } else if (requirement.filter(((HunterTableMenu)this.menu)::doesTableFulfillRequirement).isEmpty()) {
            component = Optional.of(Component.translatable((String)"container.vampirism.hunter_table.structure_level_wrong"));
        }
        component.ifPresent(c -> graphics.renderTooltip(this.font, this.font.split((FormattedText)c, 115), this.leftPos + 10, this.topPos + 60));
    }

    private /* synthetic */ Integer lambda$renderOnBoardingTooltips$8(ItemStack stack, HunterLeveling.HunterTableRequirement r) {
        return switch (this.hoveredSlot.index) {
            case 0 -> r.bookQuantity() - stack.getCount();
            case 1 -> r.vampireFangQuantity() - stack.getCount();
            case 2 -> r.pureBloodQuantity() - stack.getCount();
            case 3 -> r.vampireBookQuantity() - stack.getCount();
            default -> 0;
        };
    }
}

