/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.gui.screens;

import de.teamlapen.lib.lib.client.gui.components.HoverList;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.client.gui.screens.AppearanceScreen;
import de.teamlapen.vampirism.client.renderer.entity.HunterMinionRenderer;
import de.teamlapen.vampirism.entity.minion.HunterMinionEntity;
import de.teamlapen.vampirism.entity.minion.management.MinionData;
import de.teamlapen.vampirism.network.ServerboundAppearancePacket;
import java.util.stream.IntStream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Checkbox;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.gui.widget.ExtendedButton;

@OnlyIn(value=Dist.CLIENT)
public class HunterMinionAppearanceScreen
extends AppearanceScreen<HunterMinionEntity> {
    private static final Component NAME = Component.translatable((String)"gui.vampirism.minion_appearance");
    private int skinType;
    private int hatType;
    private boolean useLordSkin;
    private boolean isMinionSpecificSkin;
    private HoverList<?> skinList;
    private HoverList<?> hatList;
    private ExtendedButton skinButton;
    private ExtendedButton hatButton;
    private Checkbox useLordSkinButton;
    private EditBox nameWidget;
    private int normalSkinCount;
    private int minionSkinCount;

    public HunterMinionAppearanceScreen(HunterMinionEntity minion, Screen backScreen) {
        super(NAME, minion, backScreen);
    }

    public void removed() {
        Object name = this.nameWidget.getValue();
        if (((String)name).isEmpty()) {
            name = Component.translatable((String)"text.vampirism.minion").toString() + String.valueOf(((HunterMinionEntity)this.entity).getMinionId().orElse(0));
        }
        VampirismMod.proxy.sendToServer(new ServerboundAppearancePacket(((HunterMinionEntity)this.entity).getId(), (String)name, this.skinType, this.hatType, (this.isMinionSpecificSkin ? 2 : 0) | (this.useLordSkin ? 1 : 0)));
        super.removed();
    }

    @Override
    protected void init() {
        super.init();
        this.nameWidget = (EditBox)this.addRenderableWidget((GuiEventListener)new EditBox(this.font, this.guiLeft + 21, this.guiTop + 29, 98, 12, (Component)Component.translatable((String)"gui.vampirism.minion_appearance.name")));
        this.nameWidget.setValue(((HunterMinionEntity)this.entity).getMinionData().map(MinionData::getName).orElse("Minion"));
        this.nameWidget.setTextColorUneditable(-1);
        this.nameWidget.setTextColor(-1);
        this.nameWidget.setMaxLength(15);
        this.nameWidget.setResponder(this::onNameChanged);
        this.normalSkinCount = ((HunterMinionRenderer)Minecraft.getInstance().getEntityRenderDispatcher().getRenderer((Entity)((HunterMinionEntity)this.entity))).getHunterTextureCount();
        this.minionSkinCount = ((HunterMinionRenderer)Minecraft.getInstance().getEntityRenderDispatcher().getRenderer((Entity)((HunterMinionEntity)this.entity))).getMinionSpecificTextureCount();
        this.isMinionSpecificSkin = ((HunterMinionEntity)this.entity).hasMinionSpecificSkin();
        if (this.isMinionSpecificSkin && this.minionSkinCount > 0) {
            this.skinType %= this.minionSkinCount;
        } else {
            this.skinType %= this.normalSkinCount;
            this.isMinionSpecificSkin = false;
        }
        this.hatType = ((HunterMinionEntity)this.entity).getHatType();
        this.useLordSkin = ((HunterMinionEntity)this.entity).shouldRenderLordSkin();
        this.useLordSkinButton = (Checkbox)this.addRenderableWidget((GuiEventListener)Checkbox.builder((Component)Component.translatable((String)"gui.vampirism.minion_appearance.use_lord_skin"), (Font)this.font).pos(this.guiLeft + 20, this.guiTop + 86).selected(this.useLordSkin).onValueChange((checkBox, selected) -> {
            this.useLordSkin = selected;
            ((HunterMinionEntity)this.entity).setUseLordSkin(selected);
        }).build());
        this.hatList = (HoverList)this.addRenderableWidget((GuiEventListener)HoverList.builder(this.guiLeft + 20, this.guiTop + 64 + 19, 99, 60).componentsWithClickAndHover(IntStream.range(0, 3).mapToObj(id -> Component.translatable((String)"gui.vampirism.minion_appearance.hat").append(" " + (id + 1))).toList(), this::hat, this::previewHat).build());
        this.hatButton = (ExtendedButton)this.addRenderableWidget((GuiEventListener)new ExtendedButton(this.hatList.getX(), this.hatList.getY() - 20, this.hatList.getWidth(), 20, (Component)Component.literal((String)""), b -> this.setHatListVisibility(!this.hatList.visible)));
        this.skinList = (HoverList)this.addRenderableWidget((GuiEventListener)HoverList.builder(this.guiLeft + 20, this.guiTop + 43 + 19, 99, 80).componentsWithClickAndHover(IntStream.range(0, this.normalSkinCount + this.minionSkinCount).mapToObj(id -> Component.translatable((String)"gui.vampirism.minion_appearance.skin").append(" " + (id + 1))).toList(), this::skin, this::previewSkin).build());
        this.skinButton = (ExtendedButton)this.addRenderableWidget((GuiEventListener)new ExtendedButton(this.skinList.getX(), this.skinList.getY() - 20, this.skinList.getWidth(), 20, (Component)Component.literal((String)""), b -> this.setSkinListVisibility(!this.skinList.visible)));
        this.setSkinListVisibility(false);
        this.setHatListVisibility(false);
    }

    private void hat(int type) {
        this.hatType = type;
        ((HunterMinionEntity)this.entity).setHatType(this.hatType);
        this.setHatListVisibility(false);
    }

    private void onNameChanged(String newName) {
        ((HunterMinionEntity)this.entity).changeMinionName(newName);
    }

    private void previewHat(int type, boolean hovered) {
        if (hovered) {
            ((HunterMinionEntity)this.entity).setHatType(type);
        } else if (((HunterMinionEntity)this.entity).getHatType() == type) {
            ((HunterMinionEntity)this.entity).setHatType(this.hatType);
        }
    }

    private void previewSkin(int type, boolean hovered) {
        boolean minionSpecific;
        boolean bl = minionSpecific = type >= this.normalSkinCount;
        if (hovered) {
            ((HunterMinionEntity)this.entity).setHunterType(type, minionSpecific);
        } else if (((HunterMinionEntity)this.entity).getHunterType() == type && ((HunterMinionEntity)this.entity).hasMinionSpecificSkin() == minionSpecific) {
            ((HunterMinionEntity)this.entity).setHunterType(this.skinType, this.isMinionSpecificSkin);
        }
    }

    private void setHatListVisibility(boolean show) {
        this.hatButton.setMessage((Component)Component.translatable((String)"gui.vampirism.minion_appearance.hat").append(" " + (this.hatType + 1)));
        this.hatList.visible = show;
        if (show) {
            this.skinList.visible = false;
        }
        this.useLordSkinButton.visible = !show;
    }

    private void setSkinListVisibility(boolean show) {
        this.skinButton.setMessage((Component)Component.translatable((String)"gui.vampirism.minion_appearance.skin").append(" " + (this.skinType + 1)));
        this.skinList.visible = show;
        this.hatButton.visible = !show;
        boolean bl = this.useLordSkinButton.visible = !show;
        if (show) {
            this.hatList.visible = false;
        }
    }

    private void skin(int type) {
        boolean minionSpecific = type >= this.normalSkinCount;
        this.skinType = type;
        this.isMinionSpecificSkin = minionSpecific;
        ((HunterMinionEntity)this.entity).setHunterType(this.skinType, this.isMinionSpecificSkin);
        this.setSkinListVisibility(false);
    }
}

