/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.gui.screens;

import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.util.VResourceLocation;
import de.teamlapen.vampirism.inventory.HunterBasicMenu;
import de.teamlapen.vampirism.network.ServerboundSimpleInputEvent;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.neoforge.client.gui.widget.ExtendedButton;
import org.jetbrains.annotations.NotNull;

public class HunterBasicScreen
extends AbstractContainerScreen<HunterBasicMenu> {
    private static final ResourceLocation guiTexture = VResourceLocation.mod("textures/gui/container/basic_hunter.png");
    private Button buttonLevelup;
    private int missing = 0;
    private int timer = 0;

    public HunterBasicScreen(@NotNull HunterBasicMenu inventorySlotsIn, @NotNull Inventory playerInventory, @NotNull Component name) {
        super((AbstractContainerMenu)inventorySlotsIn, playerInventory, name);
    }

    public void init() {
        super.init();
        MutableComponent name = Component.translatable((String)"text.vampirism.level_up");
        int wid = this.font.width((FormattedText)name) + 5;
        int i = (this.imageWidth - wid) / 2;
        int j = (this.height - this.imageHeight) / 2;
        this.buttonLevelup = new ExtendedButton(this.leftPos + i, j + 50, wid, 20, (Component)name, context -> {
            VampirismMod.proxy.sendToServer(new ServerboundSimpleInputEvent(ServerboundSimpleInputEvent.Event.BASIC_HUNTER_LEVELUP));
            this.onClose();
        });
        this.addRenderableWidget((GuiEventListener)this.buttonLevelup);
        this.buttonLevelup.active = false;
    }

    public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.renderBackground(graphics, mouseX, mouseY, partialTicks);
        super.render(graphics, mouseX, mouseY, partialTicks);
        this.renderTooltip(graphics, mouseX, mouseY);
    }

    protected void containerTick() {
        this.timer = (this.timer + 1) % 10;
        if (this.timer == 0) {
            this.missing = ((HunterBasicMenu)this.menu).getMissingCount();
            this.buttonLevelup.active = this.missing == 0;
        }
    }

    protected void renderBg(@NotNull GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        graphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        graphics.blit(guiTexture, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
    }

    protected void renderLabels(@NotNull GuiGraphics graphics, int mouseX, int mouseY) {
        super.renderLabels(graphics, mouseX, mouseY);
        MutableComponent text = null;
        if (this.missing == 0) {
            text = Component.translatable((String)"text.vampirism.basic_hunter.i_will_train_you");
        } else if (this.missing > 0) {
            text = Component.translatable((String)"text.vampirism.basic_hunter.pay_n_vampire_blood_more", (Object[])new Object[]{this.missing});
        }
        if (text != null) {
            graphics.drawWordWrap(this.font, (FormattedText)text, 50, 12, 120, 0);
        }
    }
}

