/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.gui.screens;

import de.teamlapen.vampirism.api.util.VResourceLocation;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.neoforge.client.gui.widget.ExtendedButton;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AppearanceScreen<T extends LivingEntity>
extends Screen {
    private static final ResourceLocation BACKGROUND = VResourceLocation.mod("textures/gui/appearance.png");
    protected final T entity;
    protected final int xSize = 256;
    protected final int ySize = 177;
    @Nullable
    private final Screen backScreen;
    protected int guiLeft;
    protected int guiTop;

    public AppearanceScreen(@NotNull Component titleIn, T entity, @Nullable Screen backScreen) {
        super(titleIn);
        this.entity = entity;
        this.backScreen = backScreen;
    }

    public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.render(graphics, mouseX, mouseY, partialTicks);
        this.drawTitle(graphics);
        InventoryScreen.renderEntityInInventoryFollowsMouse((GuiGraphics)graphics, (int)(this.guiLeft + 150), (int)(this.guiTop + 30), (int)(this.guiLeft + 250), (int)(this.guiTop + 30 + 110), (int)50, (float)0.0625f, (float)mouseX, (float)mouseY, this.entity);
    }

    protected void init() {
        this.guiLeft = (this.width - this.xSize) / 2;
        this.guiTop = (this.height - this.ySize) / 2;
        this.addRenderableWidget((GuiEventListener)new ExtendedButton(this.guiLeft + this.xSize - 80 - 10, this.guiTop + 152, 80, 20, (Component)Component.translatable((String)"gui.done"), context -> this.onClose()));
        if (this.backScreen != null) {
            this.addRenderableWidget((GuiEventListener)new ExtendedButton(this.guiLeft + 10, this.guiTop + 152, 80, 20, (Component)Component.translatable((String)"gui.back"), context -> {
                if (this.minecraft != null) {
                    this.minecraft.setScreen(this.backScreen);
                }
            }));
        }
    }

    public void renderBackground(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        super.renderBackground(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
        this.renderGuiBackground(pGuiGraphics);
    }

    protected void renderGuiBackground(@NotNull GuiGraphics graphics) {
        graphics.blit(BACKGROUND, this.guiLeft, this.guiTop, 0, 0.0f, 0.0f, this.xSize, this.ySize, 300, 256);
    }

    private void drawTitle(@NotNull GuiGraphics graphics) {
        graphics.drawString(this.font, this.title, this.guiLeft + 15, this.guiTop + 5, -1, true);
    }
}

