/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.gui.overlay;

import com.mojang.blaze3d.systems.RenderSystem;
import de.teamlapen.lib.util.Color;
import de.teamlapen.vampirism.api.util.VResourceLocation;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.mixin.client.accessor.BossHealthOverlayAccessor;
import de.teamlapen.vampirism.mixin.client.accessor.BossOverlayGuiAccessor;
import de.teamlapen.vampirism.network.ClientboundUpdateMultiBossEventPacket;
import de.teamlapen.vampirism.world.MultiBossEvent;
import java.lang.runtime.SwitchBootstraps;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.BossEvent;
import org.jetbrains.annotations.NotNull;

public class CustomBossEventOverlay
implements LayeredDraw.Layer {
    private static final ResourceLocation BAR_PROGRESS_SPRITE = VResourceLocation.mc("boss_bar/white_progress");
    @NotNull
    private final Minecraft client;
    private final Map<UUID, MultiBossEvent> bossInfoMap = new LinkedHashMap<UUID, MultiBossEvent>();

    public CustomBossEventOverlay() {
        this.client = Minecraft.getInstance();
    }

    public void clear() {
        this.bossInfoMap.clear();
    }

    public void read(@NotNull ClientboundUpdateMultiBossEventPacket packet) {
        ClientboundUpdateMultiBossEventPacket.Operation operation = packet.operation();
        Objects.requireNonNull(operation);
        ClientboundUpdateMultiBossEventPacket.Operation operation2 = operation;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ClientboundUpdateMultiBossEventPacket.AddOperation.class, ClientboundUpdateMultiBossEventPacket.RemoveOperation.class}, (Object)operation2, n)) {
            case 0: {
                ClientboundUpdateMultiBossEventPacket.AddOperation operation3 = (ClientboundUpdateMultiBossEventPacket.AddOperation)operation2;
                this.bossInfoMap.put(operation3.uniqueId(), new MultiBossEvent(operation3));
                break;
            }
            case 1: {
                ClientboundUpdateMultiBossEventPacket.RemoveOperation operation4 = (ClientboundUpdateMultiBossEventPacket.RemoveOperation)operation2;
                this.bossInfoMap.remove(operation4.uniqueId());
                break;
            }
            default: {
                this.bossInfoMap.get(packet.operation().uniqueId()).updateFromPackage(packet.operation());
            }
        }
    }

    public void render(GuiGraphics graphics, DeltaTracker partialTicks) {
        if (!((Boolean)VampirismConfig.CLIENT.enableVillageRaidOverlayRendering.get()).booleanValue()) {
            return;
        }
        int i = Minecraft.getInstance().getWindow().getGuiScaledWidth();
        int n = ((BossOverlayGuiAccessor)this.client.gui.getBossOverlay()).getMapBossInfos().size();
        Objects.requireNonNull(this.client.font);
        int j = 12 + n * (10 + 9);
        for (MultiBossEvent value : this.bossInfoMap.values()) {
            int k = i / 2 - 91;
            this.render(graphics, k, j, value);
            Component itextcomponent = value.getName();
            int l = this.client.font.width((FormattedText)itextcomponent);
            int i1 = i / 2 - l / 2;
            int j1 = j - 9;
            graphics.drawString(this.client.font, itextcomponent, i1, j1, 0xFFFFFF, true);
            if (j < graphics.guiHeight() / 3) continue;
            break;
        }
    }

    private void render(@NotNull GuiGraphics graphics, int k, int j, @NotNull MultiBossEvent value) {
        int width;
        int textureStart = 0;
        List<Color> s = value.getColors();
        Map<Color, Float> perc = value.getEntries();
        for (int i = 0; i < s.size() && textureStart < 182; textureStart += width, ++i) {
            Color color = s.get(i);
            width = (int)(perc.getOrDefault(color, Float.valueOf(0.0f)).floatValue() * 182.0f);
            if (i == s.size() - 1 && textureStart + width < 182) {
                width = 182 - textureStart;
            }
            graphics.setColor(color.getRedF(), color.getGreenF(), color.getBlueF(), color.getAlphaF());
            graphics.blitSprite(BAR_PROGRESS_SPRITE, 182, 5, textureStart, 0, k + textureStart, j, width, 5);
            graphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        }
        if (value.getOverlay() != BossEvent.BossBarOverlay.PROGRESS) {
            graphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
            RenderSystem.enableBlend();
            graphics.blitSprite(BossHealthOverlayAccessor.getOVERLAY_BACKGROUND_SPRITES()[value.getOverlay().ordinal() - 1], k, j, 182, 5);
            RenderSystem.disableBlend();
        }
    }
}

