/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.gui.components;

import de.teamlapen.vampirism.api.entity.player.actions.IAction;
import de.teamlapen.vampirism.api.entity.player.actions.ILastingAction;
import de.teamlapen.vampirism.api.entity.player.skills.IActionSkill;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.api.util.SkillCallbacks;
import de.teamlapen.vampirism.api.util.VResourceLocation;
import de.teamlapen.vampirism.core.ModRegistries;
import de.teamlapen.vampirism.core.ModStats;
import de.teamlapen.vampirism.mixin.client.accessor.StatsScreenAccessor;
import de.teamlapen.vampirism.util.RegUtil;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.screens.achievement.StatsScreen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stat;
import net.minecraft.stats.StatType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import org.jetbrains.annotations.NotNull;

public class ActionStatisticsList
extends ObjectSelectionList<SkillRow> {
    protected final List<StatType<ISkill<?>>> skillColumns;
    protected final List<StatType<IAction<?>>> actionColumns;
    private final ResourceLocation[] iconSprites = new ResourceLocation[]{VResourceLocation.mod("statistics/skills_unlocked"), VResourceLocation.mod("statistics/skills_forgotten"), VResourceLocation.mc("statistics/item_used"), VResourceLocation.mod("statistics/time"), null};
    private final ItemStack[] itemSprites = new ItemStack[]{null, null, null, null, Items.RED_BED.getDefaultInstance()};
    protected int headerPressed = -1;
    private final StatsScreenAccessor screen;
    private final Font font;
    protected final Comparator<SkillRow> itemStatSorter = new ActionRowComparator();
    @Nullable
    protected StatType<?> sortColumn;
    protected int sortOrder;

    public ActionStatisticsList(Minecraft minecraft, StatsScreen screen, int width, int height) {
        super(minecraft, width, height, 32, 20);
        this.skillColumns = List.of((StatType)ModStats.SKILL_UNLOCKED.get(), (StatType)ModStats.SKILL_FORGOTTEN.get());
        this.actionColumns = List.of((StatType)ModStats.ACTION_USED.get(), (StatType)ModStats.ACTION_TIME.get(), (StatType)ModStats.ACTION_COOLDOWN_TIME.get());
        this.font = screen.font;
        this.screen = (StatsScreenAccessor)screen;
        this.setRenderHeader(true, 20);
        HashSet<ISkill> skills = new HashSet<ISkill>();
        skills.addAll(ModRegistries.SKILLS.stream().filter(x -> this.skillColumns.stream().mapToInt(y -> this.screen.getStats().getValue(y.get(x))).sum() > 0).collect(Collectors.toSet()));
        skills.addAll(ModRegistries.ACTIONS.stream().filter(x -> this.actionColumns.stream().mapToInt(y -> this.screen.getStats().getValue(y.get(x))).sum() > 0).map(IAction::asSkill).toList());
        skills.forEach(s -> this.addEntry((AbstractSelectionList.Entry)new SkillRow((ISkill<?>)s)));
    }

    int getColumnX(int p_331965_) {
        return 75 + 40 * p_331965_;
    }

    protected void renderHeader(@NotNull GuiGraphics pGuiGraphics, int pX, int pY) {
        if (!this.minecraft.mouseHandler.isLeftPressed()) {
            this.headerPressed = -1;
        }
        for (int i = 0; i < this.iconSprites.length; ++i) {
            ResourceLocation loc = this.headerPressed == i ? StatsScreenAccessor.getSLOT_SPRITE() : StatsScreenAccessor.getHEADER_SPRITE();
            pGuiGraphics.blitSprite(loc, pX + this.getColumnX(i) - 18, pY + 1, 0, 18, 18);
        }
        if (this.sortColumn != null) {
            int j = this.getColumnX(this.getColumnIndex(this.sortColumn)) - 36;
            ResourceLocation resourcelocation1 = this.sortOrder == 1 ? StatsScreenAccessor.getSORT_UP_SPRITE() : StatsScreenAccessor.getSORT_DOWN_SPRITE();
            pGuiGraphics.blitSprite(resourcelocation1, pX + j, pY + 1, 0, 18, 18);
        }
        for (int k = 0; k < this.iconSprites.length; ++k) {
            int l = this.headerPressed == k ? 1 : 0;
            ResourceLocation iconSprite = this.iconSprites[k];
            if (iconSprite != null) {
                pGuiGraphics.blitSprite(this.iconSprites[k], pX + this.getColumnX(k) - 18 + l, pY + 1 + l, 0, 18, 18);
                continue;
            }
            ItemStack itemSprite = this.itemSprites[k];
            if (itemSprite == null) continue;
            pGuiGraphics.renderFakeItem(itemSprite, pX + this.getColumnX(k) - 18 + l, pY + 1 + l);
        }
    }

    public int getRowWidth() {
        return 375;
    }

    protected int getScrollbarPosition() {
        return this.width / 2 + 140;
    }

    protected boolean clickedHeader(int p_97036_, int p_97037_) {
        this.headerPressed = -1;
        for (int i = 0; i < this.iconSprites.length; ++i) {
            int j = p_97036_ - this.getColumnX(i);
            if (j < -36 || j > 0) continue;
            this.headerPressed = i;
            break;
        }
        if (this.headerPressed >= 0) {
            this.sortByColumn(this.getColumn(this.headerPressed));
            this.minecraft.getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
            return true;
        }
        return super.clickedHeader(p_97036_, p_97037_);
    }

    private StatType<?> getColumn(int pIndex) {
        return pIndex < this.skillColumns.size() ? this.skillColumns.get(pIndex) : this.actionColumns.get(pIndex - this.skillColumns.size());
    }

    private int getColumnIndex(StatType<?> pStatType) {
        int i = this.skillColumns.indexOf(pStatType);
        if (i >= 0) {
            return i;
        }
        int j = this.actionColumns.indexOf(pStatType);
        return j >= 0 ? j + this.skillColumns.size() : -1;
    }

    protected void renderDecorations(@NotNull GuiGraphics pGuiGraphics, int pMouseX, int pMouseY) {
        if (pMouseY >= this.getY() && pMouseY <= this.getBottom()) {
            SkillRow statsscreen$itemstatisticslist$itemrow = (SkillRow)this.getHovered();
            int i = (this.width - this.getRowWidth()) / 2;
            if (statsscreen$itemstatisticslist$itemrow != null) {
                if (pMouseX < i + 40 || pMouseX > i + 40 + 20) {
                    return;
                }
                ISkill<?> item = statsscreen$itemstatisticslist$itemrow.getSkill();
                pGuiGraphics.renderTooltip(this.font, this.getString(item), pMouseX, pMouseY);
            } else {
                Component component = null;
                int j = pMouseX - i;
                for (int k = 0; k < this.iconSprites.length; ++k) {
                    int l = this.getColumnX(k);
                    if (j < l - 18 || j > l) continue;
                    component = this.getColumn(k).getDisplayName();
                    break;
                }
                if (component != null) {
                    pGuiGraphics.renderTooltip(this.font, component, pMouseX, pMouseY);
                }
            }
        }
    }

    protected Component getString(ISkill<?> pItem) {
        return pItem.getName();
    }

    protected void sortByColumn(StatType<?> pStatType) {
        if (pStatType != this.sortColumn) {
            this.sortColumn = pStatType;
            this.sortOrder = -1;
        } else if (this.sortOrder == -1) {
            this.sortOrder = 1;
        } else {
            this.sortColumn = null;
            this.sortOrder = 0;
        }
        this.children().sort(this.itemStatSorter);
    }

    public class ActionRowComparator
    implements Comparator<SkillRow> {
        @Override
        public int compare(SkillRow pRow1, SkillRow pRow2) {
            int j;
            int i;
            ISkill<?> item = pRow1.getSkill();
            ISkill<?> item1 = pRow2.getSkill();
            if (ActionStatisticsList.this.sortColumn == null) {
                i = 0;
                j = 0;
            } else if (ActionStatisticsList.this.actionColumns.contains(ActionStatisticsList.this.sortColumn)) {
                int n;
                IActionSkill actionSkill;
                StatType<?> stattype1 = ActionStatisticsList.this.sortColumn;
                if (item instanceof IActionSkill) {
                    actionSkill = (IActionSkill)item;
                    v0 = ActionStatisticsList.this.screen.getStats().getValue(stattype1, actionSkill.action());
                } else {
                    v0 = i = -1;
                }
                if (item1 instanceof IActionSkill) {
                    actionSkill = (IActionSkill)item1;
                    n = ActionStatisticsList.this.screen.getStats().getValue(stattype1, actionSkill.action());
                } else {
                    n = -1;
                }
                j = n;
            } else {
                StatType<?> stattype1 = ActionStatisticsList.this.sortColumn;
                i = ActionStatisticsList.this.screen.getStats().getValue(stattype1, item);
                j = ActionStatisticsList.this.screen.getStats().getValue(stattype1, item1);
            }
            return i == j ? ActionStatisticsList.this.sortOrder * Integer.compare(this.getId(item), this.getId(item1)) : ActionStatisticsList.this.sortOrder * Integer.compare(i, j);
        }

        private int getId(ISkill<?> action) {
            return ModRegistries.SKILLS.getId(action);
        }
    }

    public class SkillRow
    extends ObjectSelectionList.Entry<SkillRow> {
        static final ResourceLocation SLOT_SPRITE = VResourceLocation.mc("container/slot");
        private final ISkill<?> skill;

        public SkillRow(ISkill<?> action) {
            this.skill = action;
        }

        public ISkill<?> getSkill() {
            return this.skill;
        }

        public Component getNarration() {
            return Component.translatable((String)"narrator.select", (Object[])new Object[]{this.skill.getName()});
        }

        public void render(GuiGraphics pGuiGraphics, int pIndex, int pTop, int pLeft, int pWidth, int pHeight, int pMouseX, int pMouseY, boolean pHovering, float pPartialTick) {
            Object stat;
            ISkill<?> iSkill;
            pGuiGraphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
            pGuiGraphics.blitSprite(SLOT_SPRITE, pLeft + 40 + 1, pTop + 1, 0, 18, 18);
            this.renderSkill(pGuiGraphics, pTop, pLeft);
            for (int i = 0; i < ActionStatisticsList.this.skillColumns.size(); ++i) {
                iSkill = this.getSkill();
                if (iSkill instanceof SkillCallbacks.EmptyActionSkill) {
                    SkillCallbacks.EmptyActionSkill empty = (SkillCallbacks.EmptyActionSkill)iSkill;
                    stat = null;
                } else {
                    stat = this.getSkill() instanceof ISkill ? ActionStatisticsList.this.skillColumns.get(i).get(this.getSkill()) : null;
                }
                this.renderStat(pGuiGraphics, (Stat<?>)stat, pLeft + ActionStatisticsList.this.getColumnX(i), pTop, pIndex % 2 == 0);
            }
            for (int j = 0; j < ActionStatisticsList.this.actionColumns.size(); ++j) {
                iSkill = this.skill;
                if (iSkill instanceof IActionSkill) {
                    IActionSkill actionSkill = (IActionSkill)iSkill;
                    StatType<IAction<?>> stats = ActionStatisticsList.this.actionColumns.get(j);
                    IAction action = actionSkill.action();
                    stat = stats != ModStats.ACTION_TIME.get() || action instanceof ILastingAction ? ActionStatisticsList.this.actionColumns.get(j).get(actionSkill.action()) : null;
                } else {
                    stat = null;
                }
                this.renderStat(pGuiGraphics, (Stat<?>)stat, pLeft + ActionStatisticsList.this.getColumnX(j + ActionStatisticsList.this.skillColumns.size()), pTop, pIndex % 2 == 0);
            }
        }

        public void renderSkill(GuiGraphics pGuiGraphics, int pTop, int pLeft) {
            ResourceLocation texture;
            ISkill<?> iSkill = this.skill;
            if (iSkill instanceof IActionSkill) {
                IActionSkill actionSkill = (IActionSkill)iSkill;
                id = RegUtil.id(actionSkill.action());
                texture = id.withPath("textures/actions/" + id.getPath() + ".png");
            } else {
                id = RegUtil.id(this.skill);
                texture = id.withPath("textures/skills/" + id.getPath() + ".png");
            }
            pGuiGraphics.blit(texture, pLeft + 40 + 1 + 1, pTop + 1 + 1, 0, 0.0f, 0.0f, 16, 16, 16, 16);
        }

        protected void renderStat(GuiGraphics pGuiGraphics, @Nullable Stat<?> pStat, int pX, int pY, boolean pEvenRow) {
            Component component = pStat == null ? StatsScreenAccessor.getNO_VALUE_DISPLAY() : Component.literal((String)pStat.format(ActionStatisticsList.this.screen.getStats().getValue(pStat)));
            pGuiGraphics.drawString(ActionStatisticsList.this.font, component, pX - ActionStatisticsList.this.font.width((FormattedText)component), pY + 5, pEvenRow ? 0xFFFFFF : 0x909090);
        }
    }
}

