/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.blocks;

import de.teamlapen.lib.lib.util.UtilLib;
import net.minecraft.core.Holder;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import org.jetbrains.annotations.NotNull;

public class VampirismFlowerBlock
extends FlowerBlock {
    @NotNull
    private final TYPE type;

    public VampirismFlowerBlock(@NotNull TYPE type) {
        super(type.effect, (float)type.duration, BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).isViewBlocking(UtilLib::never).pushReaction(PushReaction.DESTROY).instabreak().noCollission().sound(SoundType.GRASS));
        this.type = type;
    }

    public static enum TYPE implements StringRepresentable
    {
        ORCHID("vampire_orchid", (Holder<MobEffect>)MobEffects.BLINDNESS, 7);

        private final String name;
        private final Holder<MobEffect> effect;
        private final int duration;

        private TYPE(String name, Holder<MobEffect> effect, int duration) {
            this.name = name;
            this.effect = effect;
            this.duration = duration;
        }

        @NotNull
        public String getName() {
            return this.getSerializedName();
        }

        @NotNull
        public String getSerializedName() {
            return this.name;
        }
    }
}

