/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.blocks;

import net.minecraft.core.BlockPos;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public abstract class VampirismBlockContainer
extends BaseEntityBlock {
    public VampirismBlockContainer(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull BlockBehaviour.Properties properties) {
        super(properties);
    }

    public void onRemove(@NotNull BlockState state, @NotNull Level worldIn, @NotNull BlockPos pos, @NotNull BlockState newState, boolean isMoving) {
        if (state.hasBlockEntity() && (state.is(newState.getBlock()) || !newState.hasBlockEntity())) {
            this.clearContainer(state, worldIn, pos);
            super.onRemove(state, worldIn, pos, newState, isMoving);
        }
    }

    protected void clearContainer(BlockState state, Level worldIn, BlockPos pos) {
    }

    protected void dropInventoryTileEntityItems(@NotNull Level world, @NotNull BlockPos pos) {
        BlockEntity tileEntity = world.getBlockEntity(pos);
        if (!(tileEntity instanceof Container)) {
            return;
        }
        Container inventory = (Container)tileEntity;
        for (int i = 0; i < inventory.getContainerSize(); ++i) {
            ItemStack item = inventory.getItem(i);
            if (item.isEmpty()) continue;
            this.dropItem(world, pos, item);
            inventory.setItem(i, ItemStack.EMPTY);
        }
    }

    protected void dropItem(@NotNull Level world, @NotNull BlockPos pos, @NotNull ItemStack stack) {
        Containers.dropItemStack((Level)world, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)stack);
    }
}

