/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.blocks;

import de.teamlapen.vampirism.blocks.VampirismSplitBlock;
import de.teamlapen.vampirism.core.ModStats;
import de.teamlapen.vampirism.sit.SitEntity;
import de.teamlapen.vampirism.sit.SitHandler;
import de.teamlapen.vampirism.sit.SitUtil;
import de.teamlapen.vampirism.util.BlockVoxelshapes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;

public class ThroneBlock
extends VampirismSplitBlock {
    public ThroneBlock() {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.WOOD).ignitedByLava().pushReaction(PushReaction.DESTROY).strength(2.0f, 3.0f), BlockVoxelshapes.throneBottom, BlockVoxelshapes.throneTop, true);
        this.markDecorativeBlock();
    }

    @NotNull
    public InteractionResult useWithoutItem(@NotNull BlockState state, Level world, BlockPos pos, Player player, BlockHitResult traceResult) {
        VampirismSplitBlock.Part part = (VampirismSplitBlock.Part)((Object)state.getValue((Property)PART));
        Direction oppFacing = ((Direction)state.getValue((Property)FACING)).getOpposite();
        player.awardStat((ResourceLocation)ModStats.INTERACT_WITH_THRONE.get());
        if (part == VampirismSplitBlock.Part.MAIN && (traceResult.getDirection() == Direction.UP || traceResult.getDirection() == oppFacing)) {
            SitHandler.startSitting(player, world, pos, 0.5);
            return InteractionResult.sidedSuccess((boolean)world.isClientSide);
        }
        if (part == VampirismSplitBlock.Part.SUB && traceResult.getDirection() == oppFacing && world.getBlockState(pos.below()).is((Block)this)) {
            SitHandler.startSitting(player, world, pos.below(), 0.5);
            return InteractionResult.sidedSuccess((boolean)world.isClientSide);
        }
        return InteractionResult.PASS;
    }

    public void onRemove(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pIsMoving) {
        super.onRemove(pState, pLevel, pPos, pNewState, pIsMoving);
        SitEntity entity = SitUtil.getSitEntity(pLevel, pPos);
        if (entity != null) {
            entity.discard();
        }
    }
}

