/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.blocks;

import de.teamlapen.vampirism.blocks.LogBlock;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.common.ItemAbility;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StrippableLogBlock
extends LogBlock {
    @NotNull
    private final Supplier<? extends LogBlock> strippedBlock;

    public StrippableLogBlock(@NotNull BlockBehaviour.Properties properties, @NotNull Supplier<? extends LogBlock> strippedLog) {
        super(properties);
        this.strippedBlock = strippedLog;
    }

    public StrippableLogBlock(MapColor color1, MapColor color2, @NotNull Supplier<? extends LogBlock> strippedLog) {
        super(color1, color2);
        this.strippedBlock = strippedLog;
    }

    @Nullable
    public BlockState getToolModifiedState(BlockState state, UseOnContext context, ItemAbility toolAction, boolean simulate) {
        if (toolAction == ItemAbilities.AXE_STRIP) {
            return this.getStrippedState(state, context.getLevel(), context.getClickedPos());
        }
        return super.getToolModifiedState(state, context, toolAction, simulate);
    }

    private BlockState getStrippedState(BlockState state, Level level, BlockPos clickedPos) {
        LogBlock strippedBlock = this.strippedBlock.get();
        return (BlockState)strippedBlock.defaultBlockState().setValue((Property)RotatedPillarBlock.AXIS, (Comparable)((Direction.Axis)state.getValue((Property)RotatedPillarBlock.AXIS)));
    }
}

