/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.blocks;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import de.teamlapen.vampirism.blocks.CursedBarkBlock;
import de.teamlapen.vampirism.blocks.CursedSpruceBlock;
import de.teamlapen.vampirism.core.ModBlocks;
import de.teamlapen.vampirism.util.Helper;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;

public class DiagonalCursedBarkBlock
extends CursedBarkBlock {
    public static final Table<Direction, Direction, BooleanProperty> PROPERTY_TABLE = HashBasedTable.create();
    private static final Map<BooleanProperty, Pair<Direction, Direction>> DIRECTION_MAP = new HashMap<BooleanProperty, Pair<Direction, Direction>>();
    public static final BooleanProperty UP_WEST = DiagonalCursedBarkBlock.createProperty(Direction.UP, Direction.WEST);
    public static final BooleanProperty UP_NORTH = DiagonalCursedBarkBlock.createProperty(Direction.UP, Direction.NORTH);
    public static final BooleanProperty UP_EAST = DiagonalCursedBarkBlock.createProperty(Direction.UP, Direction.EAST);
    public static final BooleanProperty UP_SOUTH = DiagonalCursedBarkBlock.createProperty(Direction.UP, Direction.SOUTH);
    public static final BooleanProperty DOWN_WEST = DiagonalCursedBarkBlock.createProperty(Direction.DOWN, Direction.WEST);
    public static final BooleanProperty DOWN_NORTH = DiagonalCursedBarkBlock.createProperty(Direction.DOWN, Direction.NORTH);
    public static final BooleanProperty DOWN_EAST = DiagonalCursedBarkBlock.createProperty(Direction.DOWN, Direction.EAST);
    public static final BooleanProperty DOWN_SOUTH = DiagonalCursedBarkBlock.createProperty(Direction.DOWN, Direction.SOUTH);
    public static final BooleanProperty NORTH_WEST = DiagonalCursedBarkBlock.createProperty(Direction.NORTH, Direction.WEST);
    public static final BooleanProperty WEST_SOUTH = DiagonalCursedBarkBlock.createProperty(Direction.WEST, Direction.SOUTH);
    public static final BooleanProperty SOUTH_EAST = DiagonalCursedBarkBlock.createProperty(Direction.SOUTH, Direction.EAST);
    public static final BooleanProperty EAST_NORTH = DiagonalCursedBarkBlock.createProperty(Direction.EAST, Direction.NORTH);

    public DiagonalCursedBarkBlock() {
        super(BlockBehaviour.Properties.of().sound(SoundType.EMPTY));
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)UP_WEST, (Comparable)Boolean.valueOf(false))).setValue((Property)UP_NORTH, (Comparable)Boolean.valueOf(false))).setValue((Property)UP_EAST, (Comparable)Boolean.valueOf(false))).setValue((Property)UP_SOUTH, (Comparable)Boolean.valueOf(false))).setValue((Property)DOWN_WEST, (Comparable)Boolean.valueOf(false))).setValue((Property)DOWN_NORTH, (Comparable)Boolean.valueOf(false))).setValue((Property)DOWN_EAST, (Comparable)Boolean.valueOf(false))).setValue((Property)DOWN_SOUTH, (Comparable)Boolean.valueOf(false))).setValue((Property)NORTH_WEST, (Comparable)Boolean.valueOf(false))).setValue((Property)WEST_SOUTH, (Comparable)Boolean.valueOf(false))).setValue((Property)SOUTH_EAST, (Comparable)Boolean.valueOf(false))).setValue((Property)EAST_NORTH, (Comparable)Boolean.valueOf(false)));
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        return DIRECTION_MAP.entrySet().stream().filter(entry -> (Boolean)state.getValue((Property)entry.getKey())).anyMatch(e -> level.getBlockState(pos.relative((Direction)((Pair)e.getValue()).getKey()).relative((Direction)((Pair)e.getValue()).getValue())).getBlock() instanceof CursedSpruceBlock);
    }

    @NotNull
    public BlockState updateShape(@NotNull BlockState state, @NotNull Direction direction, @NotNull BlockState otherState, @NotNull LevelAccessor levelAccessor, @NotNull BlockPos pos, @NotNull BlockPos otherPos) {
        if (!otherState.is((Block)ModBlocks.DIRECT_CURSED_BARK.get())) {
            for (Map.Entry entry : PROPERTY_TABLE.column((Object)direction).entrySet()) {
                state = (BlockState)state.setValue((Property)entry.getValue(), (Comparable)Boolean.valueOf(false));
            }
            if (!this.anyProperty(state)) {
                state = Blocks.AIR.defaultBlockState();
            }
        } else {
            for (Map.Entry entry : PROPERTY_TABLE.row((Object)direction).entrySet()) {
                if (!levelAccessor.getBlockState(pos.relative((Direction)entry.getKey())).is((Block)ModBlocks.DIRECT_CURSED_BARK.get())) continue;
                state.setValue((Property)entry.getValue(), (Comparable)Boolean.valueOf(true));
            }
        }
        return state;
    }

    public void entityInside(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Entity entity) {
        if (Helper.isVampire(entity) || entity instanceof Player && ((Player)entity).getAbilities().invulnerable) {
            return;
        }
        BlockPos targetPos = pos;
        for (Map.Entry<BooleanProperty, Pair<Direction, Direction>> entry : DIRECTION_MAP.entrySet()) {
            if (!((Boolean)state.getValue((Property)entry.getKey())).booleanValue()) continue;
            targetPos = targetPos.relative((Direction)entry.getValue().getLeft()).relative((Direction)entry.getValue().getRight());
        }
        this.moveEntityTo(level, entity, targetPos);
    }

    private boolean anyProperty(BlockState state) {
        for (BooleanProperty property : PROPERTY_TABLE.values()) {
            if (!((Boolean)state.getValue((Property)property)).booleanValue()) continue;
            return true;
        }
        return false;
    }

    private static BooleanProperty createProperty(Direction direction1, Direction direction2) {
        BooleanProperty property = BooleanProperty.create((String)(direction1.getSerializedName() + "_" + direction2.getSerializedName()));
        PROPERTY_TABLE.put((Object)direction1, (Object)direction2, (Object)property);
        PROPERTY_TABLE.put((Object)direction2, (Object)direction1, (Object)property);
        DIRECTION_MAP.put(property, (Pair<Direction, Direction>)Pair.of((Object)direction1, (Object)direction2));
        return property;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{UP_WEST, UP_NORTH, UP_EAST, UP_SOUTH, DOWN_WEST, DOWN_NORTH, DOWN_EAST, DOWN_SOUTH, NORTH_WEST, WEST_SOUTH, SOUTH_EAST, EAST_NORTH});
    }
}

