/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.blocks;

import de.teamlapen.vampirism.blocks.VampirismHorizontalBlock;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CandelabraWallBlock
extends VampirismHorizontalBlock {
    @NotNull
    private static VoxelShape makeWallCandelabraShape() {
        return Stream.of(Block.box((double)6.0, (double)1.0, (double)15.0, (double)10.0, (double)5.0, (double)16.0), Block.box((double)6.5, (double)1.5, (double)14.0, (double)9.5, (double)4.5, (double)15.0), Block.box((double)7.0, (double)2.0, (double)12.0, (double)9.0, (double)9.0, (double)14.0), Block.box((double)9.0, (double)4.0, (double)12.0, (double)14.0, (double)6.0, (double)14.0), Block.box((double)12.0, (double)6.0, (double)12.0, (double)14.0, (double)7.0, (double)14.0), Block.box((double)2.0, (double)4.0, (double)12.0, (double)7.0, (double)6.0, (double)14.0), Block.box((double)2.0, (double)6.0, (double)12.0, (double)4.0, (double)7.0, (double)14.0), Block.box((double)6.5, (double)9.0, (double)11.5, (double)9.5, (double)10.0, (double)14.5), Block.box((double)7.0, (double)10.0, (double)12.0, (double)9.0, (double)14.0, (double)14.0), Block.box((double)2.0, (double)8.0, (double)12.0, (double)4.0, (double)12.0, (double)14.0), Block.box((double)1.5, (double)7.0, (double)11.5, (double)4.5, (double)8.0, (double)14.5), Block.box((double)12.0, (double)8.0, (double)12.0, (double)14.0, (double)12.0, (double)14.0), Block.box((double)11.5, (double)7.0, (double)11.5, (double)14.5, (double)8.0, (double)14.5)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).orElseGet(Shapes::empty);
    }

    public CandelabraWallBlock() {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.METAL).lightLevel(s -> 14).noOcclusion(), CandelabraWallBlock.makeWallCandelabraShape());
    }

    public boolean canSurvive(@NotNull BlockState state, @NotNull LevelReader worldIn, @NotNull BlockPos pos) {
        Direction direction = (Direction)state.getValue((Property)FACING);
        BlockPos blockpos = pos.relative(direction.getOpposite());
        BlockState blockstate = worldIn.getBlockState(blockpos);
        return blockstate.isFaceSturdy((BlockGetter)worldIn, blockpos, direction);
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(@NotNull BlockPlaceContext context) {
        Direction[] adirection;
        BlockState blockstate = this.defaultBlockState();
        Level iworldreader = context.getLevel();
        BlockPos blockpos = context.getClickedPos();
        for (Direction direction : adirection = context.getNearestLookingDirections()) {
            Direction direction1;
            if (!direction.getAxis().isHorizontal() || !(blockstate = (BlockState)blockstate.setValue((Property)FACING, (Comparable)(direction1 = direction.getOpposite()))).canSurvive((LevelReader)iworldreader, blockpos)) continue;
            return blockstate;
        }
        return null;
    }

    @NotNull
    public BlockState updateShape(@NotNull BlockState stateIn, @NotNull Direction facing, @NotNull BlockState facingState, @NotNull LevelAccessor worldIn, @NotNull BlockPos currentPos, @NotNull BlockPos facingPos) {
        return facing.getOpposite() == stateIn.getValue((Property)FACING) && !stateIn.canSurvive((LevelReader)worldIn, currentPos) ? Blocks.AIR.defaultBlockState() : stateIn;
    }
}

