/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.blockentity;

import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.entity.player.hunter.IHunterPlayer;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.api.entity.player.skills.ISkillHandler;
import de.teamlapen.vampirism.api.items.IExtendedBrewingRecipeRegistry;
import de.teamlapen.vampirism.core.ModSounds;
import de.teamlapen.vampirism.core.ModTiles;
import de.teamlapen.vampirism.entity.player.hunter.HunterPlayer;
import de.teamlapen.vampirism.entity.player.hunter.skills.HunterSkills;
import de.teamlapen.vampirism.inventory.PotionTableMenu;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.ICapabilityProvider;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.wrapper.SidedInvWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PotionTableBlockEntity
extends BaseContainerBlockEntity
implements WorldlyContainer,
MenuProvider,
ICapabilityProvider<PotionTableBlockEntity, Direction, IItemHandler> {
    private static final int[] SLOTS_FOR_UP = new int[]{0, 1, 2};
    private static final int[] SLOTS_FOR_DOWN = new int[]{3, 4, 5, 1, 2};
    private static final int[] SLOTS_FOR_DOWN_EXTENDED = new int[]{3, 4, 5, 6, 7, 1, 2};
    private static final int[] OUTPUT_SLOTS = new int[]{3, 4, 5, 0};
    private static final int[] OUTPUT_SLOTS_EXTENDED = new int[]{3, 4, 5, 6, 7, 0};
    private final BrewingCapabilities config = new BrewingCapabilities();
    @Nullable
    private UUID ownerID;
    @Nullable
    private Component ownerName;
    @NotNull
    private NonNullList<ItemStack> brewingItemStacks = NonNullList.withSize((int)8, (Object)ItemStack.EMPTY);
    private int brewTime;
    private Item ingredientID;
    private Item extraIngredientID;
    private int fuel;
    protected final ContainerData syncedProperties = new ContainerData(){

        public int get(int index) {
            return switch (index) {
                case 0 -> PotionTableBlockEntity.this.brewTime;
                case 1 -> PotionTableBlockEntity.this.fuel;
                default -> 0;
            };
        }

        public void set(int index, int value) {
            switch (index) {
                case 0: {
                    PotionTableBlockEntity.this.brewTime = value;
                    break;
                }
                case 1: {
                    PotionTableBlockEntity.this.fuel = value;
                }
            }
        }

        public int getCount() {
            return 2;
        }
    };

    public PotionTableBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        super((BlockEntityType)ModTiles.POTION_TABLE.get(), pos, state);
    }

    public boolean canOpen(@NotNull Player player) {
        if (super.canOpen(player)) {
            HunterPlayer hunter = HunterPlayer.get(player);
            if (hunter.getLevel() > 0) {
                if (this.ownerID == null) {
                    this.setOwnerID(player);
                    this.config.deriveFromHunter(hunter);
                    return true;
                }
                if (this.ownerID.equals(player.getUUID())) {
                    this.config.deriveFromHunter(hunter);
                    return true;
                }
                player.displayClientMessage((Component)Component.translatable((String)"text.vampirism.potion_table.other", (Object[])new Object[]{this.getOwnerName()}), true);
            } else {
                player.displayClientMessage((Component)Component.translatable((String)"text.vampirism.unfamiliar"), true);
            }
            return false;
        }
        return false;
    }

    protected NonNullList<ItemStack> getItems() {
        return this.brewingItemStacks;
    }

    protected void setItems(NonNullList<ItemStack> p_332640_) {
        this.brewingItemStacks = p_332640_;
    }

    public boolean canPlaceItem(int index, @NotNull ItemStack stack) {
        if (index == 2) {
            return this.level.potionBrewing().isIngredient(stack);
        }
        Item item = stack.getItem();
        if (index == 0) {
            return item == Items.BLAZE_POWDER;
        }
        return this.level.potionBrewing().isInput(stack) && this.getItem(index).isEmpty();
    }

    public boolean canPlaceItemThroughFace(int index, @NotNull ItemStack itemStackIn, @Nullable Direction direction) {
        return this.canPlaceItem(index, itemStackIn);
    }

    public boolean canTakeItemThroughFace(int index, @NotNull ItemStack stack, @NotNull Direction direction) {
        if (index == 1 || index == 2) {
            return stack.getItem() == Items.GLASS_BOTTLE;
        }
        return true;
    }

    public void clearContent() {
        this.brewingItemStacks.clear();
    }

    @Nullable
    public IItemHandler getCapability(PotionTableBlockEntity object, Direction context) {
        return new SidedInvWrapper((WorldlyContainer)this, context);
    }

    @NotNull
    public Component getDisplayName() {
        return Component.translatable((String)"tile.vampirism.potion_table.display", (Object[])new Object[]{this.ownerName, Component.translatable((String)"tile.vampirism.potion_table")});
    }

    @NotNull
    public Component getOwnerName() {
        return this.ownerName == null ? Component.literal((String)"Unknown") : this.ownerName;
    }

    public int getContainerSize() {
        return this.brewingItemStacks.size();
    }

    @NotNull
    public int[] getSlotsForFace(@NotNull Direction side) {
        if (side == Direction.UP) {
            return SLOTS_FOR_UP;
        }
        return side == Direction.DOWN ? (this.config.multiTaskBrewing ? SLOTS_FOR_DOWN_EXTENDED : SLOTS_FOR_DOWN) : (this.config.multiTaskBrewing ? OUTPUT_SLOTS_EXTENDED : OUTPUT_SLOTS);
    }

    @NotNull
    public ItemStack getItem(int index) {
        return index >= 0 && index < this.brewingItemStacks.size() ? (ItemStack)this.brewingItemStacks.get(index) : ItemStack.EMPTY;
    }

    public boolean isEmpty() {
        for (ItemStack itemstack : this.brewingItemStacks) {
            if (itemstack.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public boolean isExtended() {
        return this.config.isMultiTaskBrewing();
    }

    public void loadAdditional(@NotNull CompoundTag compound, HolderLookup.Provider provider) {
        super.loadAdditional(compound, provider);
        this.brewingItemStacks = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
        ContainerHelper.loadAllItems((CompoundTag)compound, this.brewingItemStacks, (HolderLookup.Provider)provider);
        this.brewTime = compound.getShort("BrewTime");
        this.fuel = compound.getByte("Fuel");
        this.config.fromByte(compound.getByte("config"));
        this.ownerID = compound.hasUUID("owner") ? compound.getUUID("owner") : null;
        this.ownerName = compound.contains("owner_name") ? Component.Serializer.fromJsonLenient((String)compound.getString("owner_name"), (HolderLookup.Provider)provider) : null;
    }

    @NotNull
    public ItemStack removeItem(int index, int count) {
        return ContainerHelper.removeItem(this.brewingItemStacks, (int)index, (int)count);
    }

    @NotNull
    public ItemStack removeItemNoUpdate(int index) {
        return ContainerHelper.takeItem(this.brewingItemStacks, (int)index);
    }

    public void saveAdditional(@NotNull CompoundTag compound, HolderLookup.Provider provider) {
        super.saveAdditional(compound, provider);
        compound.putShort("BrewTime", (short)this.brewTime);
        ContainerHelper.saveAllItems((CompoundTag)compound, this.brewingItemStacks, (HolderLookup.Provider)provider);
        compound.putByte("Fuel", (byte)this.fuel);
        compound.putByte("config", this.config.toByte());
        if (this.ownerID != null) {
            compound.putUUID("owner", this.ownerID);
            compound.putString("owner_name", Component.Serializer.toJson((Component)this.ownerName, (HolderLookup.Provider)provider));
        }
    }

    public void setItem(int index, @NotNull ItemStack stack) {
        if (index >= 0 && index < this.brewingItemStacks.size()) {
            this.brewingItemStacks.set(index, (Object)stack);
        }
    }

    public void setOwnerID(@NotNull Player player) {
        this.ownerID = player.getUUID();
        this.ownerName = player.getName();
        this.setChanged();
    }

    public boolean stillValid(@NotNull Player player) {
        if (!this.hasLevel()) {
            return false;
        }
        if (this.level.getBlockEntity(this.worldPosition) != this) {
            return false;
        }
        return !(player.distanceToSqr((double)this.worldPosition.getX() + 0.5, (double)this.worldPosition.getY() + 0.5, (double)this.worldPosition.getZ() + 0.5) > 64.0);
    }

    public static void tick(@NotNull Level level, BlockPos pos, BlockState state, @NotNull PotionTableBlockEntity blockEntity) {
        boolean isBrewing;
        Player owner;
        ItemStack itemstack = (ItemStack)blockEntity.brewingItemStacks.getFirst();
        if (blockEntity.fuel <= 0 && itemstack.getItem() == Items.BLAZE_POWDER) {
            blockEntity.fuel = 20;
            itemstack.shrink(1);
            blockEntity.setChanged();
        }
        if (blockEntity.ownerID != null && level.getGameTime() % 64L == 0L && (owner = level.getPlayerByUUID(blockEntity.ownerID)) != null) {
            blockEntity.config.deriveFromHunter(HunterPlayer.get(owner));
        }
        boolean canBrew = blockEntity.canBrew();
        boolean bl = isBrewing = blockEntity.brewTime > 0;
        if (isBrewing) {
            --blockEntity.brewTime;
            if (blockEntity.brewTime == 0 && canBrew) {
                blockEntity.brewPotions();
                blockEntity.setChanged();
            } else if (!canBrew || blockEntity.ingredientID != ((ItemStack)blockEntity.brewingItemStacks.get(2)).getItem() || blockEntity.extraIngredientID != ((ItemStack)blockEntity.brewingItemStacks.get(1)).getItem()) {
                blockEntity.brewTime = 0;
                blockEntity.setChanged();
            }
        } else if (canBrew && blockEntity.fuel > 0) {
            --blockEntity.fuel;
            blockEntity.brewTime = blockEntity.config.isSwiftBrewing() ? 400 : 200;
            blockEntity.ingredientID = ((ItemStack)blockEntity.brewingItemStacks.get(2)).getItem();
            blockEntity.extraIngredientID = ((ItemStack)blockEntity.brewingItemStacks.get(1)).getItem();
            blockEntity.setChanged();
        }
    }

    @NotNull
    protected AbstractContainerMenu createMenu(int id, @NotNull Inventory player) {
        return new PotionTableMenu(id, player, ContainerLevelAccess.create((Level)this.level, (BlockPos)this.getBlockPos()), (Container)this, this.config.multiTaskBrewing, this.syncedProperties);
    }

    @NotNull
    protected Component getDefaultName() {
        return Component.translatable((String)"container.brewing");
    }

    private void brewPotions() {
        ItemStack itemstack1;
        ItemStack ingredientStack = (ItemStack)this.brewingItemStacks.get(2);
        ItemStack extraIngredient = (ItemStack)this.brewingItemStacks.get(1);
        boolean brewed = VampirismAPI.extendedBrewingRecipeRegistry().brewPotions(this.level, this.brewingItemStacks, ingredientStack, extraIngredient, this.config, this.config.multiTaskBrewing ? OUTPUT_SLOTS_EXTENDED : OUTPUT_SLOTS, true);
        if (!brewed) {
            NonNullList copiedBrewingItemStack = NonNullList.of((Object)ItemStack.EMPTY, (Object[])new ItemStack[]{((ItemStack)this.brewingItemStacks.get(3)).copy(), ((ItemStack)this.brewingItemStacks.get(4)).copy(), ((ItemStack)this.brewingItemStacks.get(5)).copy(), ((ItemStack)this.brewingItemStacks.get(2)).copy(), ((ItemStack)this.brewingItemStacks.get(0)).copy()});
            if (EventHooks.onPotionAttemptBrew((NonNullList)copiedBrewingItemStack)) {
                this.brewingItemStacks.set(3, (Object)((ItemStack)copiedBrewingItemStack.get(0)));
                this.brewingItemStacks.set(4, (Object)((ItemStack)copiedBrewingItemStack.get(1)));
                this.brewingItemStacks.set(5, (Object)((ItemStack)copiedBrewingItemStack.get(2)));
                this.brewingItemStacks.set(2, (Object)((ItemStack)copiedBrewingItemStack.get(3)));
                this.brewingItemStacks.set(0, (Object)((ItemStack)copiedBrewingItemStack.get(4)));
                return;
            }
            VampirismAPI.extendedBrewingRecipeRegistry().brewPotions(this.level, this.brewingItemStacks, ingredientStack, extraIngredient, this.config, this.config.multiTaskBrewing ? OUTPUT_SLOTS_EXTENDED : OUTPUT_SLOTS, false);
            copiedBrewingItemStack = NonNullList.of((Object)ItemStack.EMPTY, (Object[])new ItemStack[]{((ItemStack)this.brewingItemStacks.get(3)).copy(), ((ItemStack)this.brewingItemStacks.get(4)).copy(), ((ItemStack)this.brewingItemStacks.get(5)).copy(), ((ItemStack)this.brewingItemStacks.get(2)).copy(), ((ItemStack)this.brewingItemStacks.get(0)).copy()});
            EventHooks.onPotionBrewed(this.brewingItemStacks);
            this.brewingItemStacks.set(3, (Object)((ItemStack)copiedBrewingItemStack.get(0)));
            this.brewingItemStacks.set(4, (Object)((ItemStack)copiedBrewingItemStack.get(1)));
            this.brewingItemStacks.set(5, (Object)((ItemStack)copiedBrewingItemStack.get(2)));
            this.brewingItemStacks.set(2, (Object)((ItemStack)copiedBrewingItemStack.get(3)));
            this.brewingItemStacks.set(0, (Object)((ItemStack)copiedBrewingItemStack.get(4)));
        }
        BlockPos blockpos = this.getBlockPos();
        if (ingredientStack.hasCraftingRemainingItem()) {
            itemstack1 = ingredientStack.getCraftingRemainingItem();
            if (ingredientStack.isEmpty()) {
                ingredientStack = itemstack1;
            } else if (!this.level.isClientSide) {
                Containers.dropItemStack((Level)this.level, (double)blockpos.getX(), (double)blockpos.getY(), (double)blockpos.getZ(), (ItemStack)itemstack1);
            }
        }
        if (extraIngredient.hasCraftingRemainingItem()) {
            itemstack1 = extraIngredient.getCraftingRemainingItem();
            if (extraIngredient.isEmpty()) {
                extraIngredient = itemstack1;
            } else if (!this.level.isClientSide) {
                Containers.dropItemStack((Level)this.level, (double)blockpos.getX(), (double)blockpos.getY(), (double)blockpos.getZ(), (ItemStack)itemstack1);
            }
        }
        this.brewingItemStacks.set(2, (Object)ingredientStack);
        this.brewingItemStacks.set(1, (Object)extraIngredient);
        this.level.playSound(null, (double)blockpos.getX(), (double)blockpos.getY(), (double)blockpos.getZ(), (SoundEvent)ModSounds.POTION_TABLE_CRAFTING.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
        this.level.levelEvent(1035, blockpos, 0);
    }

    private boolean canBrew() {
        ItemStack extraStack = (ItemStack)this.brewingItemStacks.get(1);
        ItemStack ingredientStack = (ItemStack)this.brewingItemStacks.get(2);
        if (!ingredientStack.isEmpty()) {
            return VampirismAPI.extendedBrewingRecipeRegistry().canBrew(this.level, this.brewingItemStacks, ingredientStack, extraStack, this.config, this.config.multiTaskBrewing ? OUTPUT_SLOTS_EXTENDED : OUTPUT_SLOTS);
        }
        return false;
    }

    protected static class BrewingCapabilities
    implements IExtendedBrewingRecipeRegistry.IExtendedBrewingCapabilities {
        boolean durableBrewing;
        boolean concentratedBrewing;
        boolean swiftBrewing;
        boolean masterBrewing;
        boolean efficientBrewing;
        boolean multiTaskBrewing;

        protected BrewingCapabilities() {
        }

        public void deriveFromHunter(@NotNull IHunterPlayer player) {
            ISkillHandler manager = player.getSkillHandler();
            this.durableBrewing = manager.isSkillEnabled((ISkill)HunterSkills.DURABLE_BREWING.get()) || manager.isSkillEnabled((ISkill)HunterSkills.CONCENTRATED_DURABLE_BREWING.get());
            this.concentratedBrewing = manager.isSkillEnabled((ISkill)HunterSkills.CONCENTRATED_BREWING.get()) || manager.isSkillEnabled((ISkill)HunterSkills.CONCENTRATED_DURABLE_BREWING.get());
            this.swiftBrewing = manager.isSkillEnabled((ISkill)HunterSkills.SWIFT_BREWING.get());
            this.masterBrewing = manager.isSkillEnabled((ISkill)HunterSkills.MASTER_BREWER.get());
            this.efficientBrewing = manager.isSkillEnabled((ISkill)HunterSkills.EFFICIENT_BREWING.get());
            this.multiTaskBrewing = manager.isSkillEnabled((ISkill)HunterSkills.MULTITASK_BREWING.get());
        }

        public void fromByte(byte d) {
            this.durableBrewing = (d & 1) > 0;
            this.concentratedBrewing = (d & 2) > 0;
            this.swiftBrewing = (d & 4) > 0;
            this.masterBrewing = (d & 8) > 0;
            this.efficientBrewing = (d & 0x10) > 0;
            this.multiTaskBrewing = (d & 0x20) > 0;
        }

        @Override
        public boolean isConcentratedBrewing() {
            return this.concentratedBrewing;
        }

        @Override
        public boolean isDurableBrewing() {
            return this.durableBrewing;
        }

        @Override
        public boolean isEfficientBrewing() {
            return this.efficientBrewing;
        }

        @Override
        public boolean isMasterBrewing() {
            return this.masterBrewing;
        }

        @Override
        public boolean isMultiTaskBrewing() {
            return this.multiTaskBrewing;
        }

        @Override
        public boolean isSwiftBrewing() {
            return this.swiftBrewing;
        }

        public void reset() {
            this.multiTaskBrewing = false;
            this.efficientBrewing = false;
            this.masterBrewing = false;
            this.swiftBrewing = false;
            this.concentratedBrewing = false;
            this.durableBrewing = false;
        }

        public byte toByte() {
            byte d = 0;
            if (this.durableBrewing) {
                d = (byte)(d | 1);
            }
            if (this.concentratedBrewing) {
                d = (byte)(d | 2);
            }
            if (this.swiftBrewing) {
                d = (byte)(d | 4);
            }
            if (this.masterBrewing) {
                d = (byte)(d | 8);
            }
            if (this.efficientBrewing) {
                d = (byte)(d | 0x10);
            }
            if (this.multiTaskBrewing) {
                d = (byte)(d | 0x20);
            }
            return d;
        }
    }
}

