/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.blockentity;

import com.mojang.datafixers.util.Either;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.api.entity.player.skills.ISkillHandler;
import de.teamlapen.vampirism.blocks.AlchemicalCauldronBlock;
import de.teamlapen.vampirism.core.ModDataMaps;
import de.teamlapen.vampirism.core.ModRecipes;
import de.teamlapen.vampirism.core.ModTiles;
import de.teamlapen.vampirism.entity.player.hunter.HunterPlayer;
import de.teamlapen.vampirism.entity.player.hunter.skills.HunterSkills;
import de.teamlapen.vampirism.inventory.AlchemicalCauldronMenu;
import de.teamlapen.vampirism.recipes.AlchemicalCauldronRecipe;
import de.teamlapen.vampirism.recipes.AlchemicalCauldronRecipeInput;
import de.teamlapen.vampirism.util.Helper;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.RecipeCraftingHolder;
import net.minecraft.world.inventory.StackedContentsCompatible;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractFurnaceBlock;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AlchemicalCauldronBlockEntity
extends BaseContainerBlockEntity
implements WorldlyContainer,
RecipeCraftingHolder,
StackedContentsCompatible {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final int[] SLOTS_DOWN = new int[]{0, 1, 2};
    private static final int[] SLOTS_UP = new int[]{0};
    private static final int[] SLOTS_WEST = new int[]{1};
    private static final int[] SLOTS_FUEL = new int[]{3};
    @Nullable
    private UUID ownerID;
    @Nullable
    private String ownerName;
    @Nullable
    private RecipeHolder<AlchemicalCauldronRecipe> recipeChecked;
    private final RecipeType<? extends AlchemicalCauldronRecipe> recipeType;
    protected NonNullList<ItemStack> items = NonNullList.withSize((int)3, (Object)ItemStack.EMPTY);
    protected int litTime;
    protected int litDuration;
    protected int cookingProgress;
    protected int cookingTotalTime;
    protected final ContainerData dataAccess = new ContainerData(){

        public int get(int p_58431_) {
            switch (p_58431_) {
                case 0: {
                    if (AlchemicalCauldronBlockEntity.this.litDuration > Short.MAX_VALUE) {
                        return Mth.floor((double)((double)AlchemicalCauldronBlockEntity.this.litTime / (double)AlchemicalCauldronBlockEntity.this.litDuration * 32767.0));
                    }
                    return AlchemicalCauldronBlockEntity.this.litTime;
                }
                case 1: {
                    return Math.min(AlchemicalCauldronBlockEntity.this.litDuration, Short.MAX_VALUE);
                }
                case 2: {
                    return AlchemicalCauldronBlockEntity.this.cookingProgress;
                }
                case 3: {
                    return AlchemicalCauldronBlockEntity.this.cookingTotalTime;
                }
            }
            return 0;
        }

        public void set(int p_58433_, int p_58434_) {
            switch (p_58433_) {
                case 0: {
                    AlchemicalCauldronBlockEntity.this.litTime = p_58434_;
                    break;
                }
                case 1: {
                    AlchemicalCauldronBlockEntity.this.litDuration = p_58434_;
                    break;
                }
                case 2: {
                    AlchemicalCauldronBlockEntity.this.cookingProgress = p_58434_;
                    break;
                }
                case 3: {
                    AlchemicalCauldronBlockEntity.this.cookingTotalTime = p_58434_;
                }
            }
        }

        public int getCount() {
            return 4;
        }
    };
    private final Object2IntOpenHashMap<ResourceLocation> recipesUsed = new Object2IntOpenHashMap();
    private final RecipeManager.CachedCheck<AlchemicalCauldronRecipeInput, AlchemicalCauldronRecipe> quickCheck;

    public AlchemicalCauldronBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        super((BlockEntityType)ModTiles.ALCHEMICAL_CAULDRON.get(), pos, state);
        this.recipeType = (RecipeType)ModRecipes.ALCHEMICAL_CAULDRON_TYPE.get();
        this.items = NonNullList.withSize((int)4, (Object)ItemStack.EMPTY);
        this.quickCheck = RecipeManager.createCheck((RecipeType)((RecipeType)ModRecipes.ALCHEMICAL_CAULDRON_TYPE.get()));
    }

    public ItemStack getFluid() {
        return (ItemStack)this.items.get(0);
    }

    public ItemStack getIngredient() {
        return (ItemStack)this.items.get(1);
    }

    public boolean canOpen(@NotNull Player player) {
        if (super.canOpen(player)) {
            if (!Helper.isHunter(player)) {
                player.displayClientMessage((Component)Component.translatable((String)"text.vampirism.unfamiliar"), true);
                return false;
            }
            if (HunterPlayer.get(player).getSkillHandler().isSkillEnabled((ISkill)HunterSkills.BASIC_ALCHEMY.get())) {
                if (this.ownerID == null) {
                    this.setOwnerID(player);
                    return true;
                }
                if (this.ownerID.equals(player.getUUID())) {
                    return true;
                }
                player.displayClientMessage((Component)Component.translatable((String)"text.vampirism.alchemical_cauldron.other", (Object[])new Object[]{this.getOwnerName()}), true);
            } else {
                player.displayClientMessage((Component)Component.translatable((String)"text.vampirism.not_learned"), true);
            }
        }
        return false;
    }

    protected void setItems(NonNullList<ItemStack> pItems) {
        this.items = pItems;
    }

    protected NonNullList<ItemStack> getItems() {
        return this.items;
    }

    @NotNull
    public Component getCustomName() {
        return Component.translatable((String)"tile.vampirism.alchemical_cauldron");
    }

    @NotNull
    public Component getDisplayName() {
        return Component.translatable((String)"tile.vampirism.alchemical_cauldron.display", (Object[])new Object[]{this.ownerName, Component.translatable((String)"tile.vampirism.alchemical_cauldron")});
    }

    public int getLiquidColorClient() {
        ItemStack liquidItem = (ItemStack)this.items.getFirst();
        return FluidUtil.getFluidContained((ItemStack)liquidItem).map(fluidStack -> IClientFluidTypeExtensions.of((Fluid)fluidStack.getFluid()).getTintColor(fluidStack)).orElseGet(() -> {
            Integer color = (Integer)liquidItem.getItemHolder().getData(ModDataMaps.LIQUID_COLOR_MAP);
            return color != null ? color : 59;
        });
    }

    @NotNull
    public Component getOwnerName() {
        return Component.literal((String)(this.ownerName == null ? "Unknown" : this.ownerName));
    }

    @NotNull
    public int[] getSlotsForFace(@NotNull Direction side) {
        if (side == Direction.DOWN) {
            return SLOTS_DOWN;
        }
        return side == Direction.UP ? SLOTS_UP : (side == Direction.WEST ? SLOTS_WEST : SLOTS_FUEL);
    }

    public boolean canPlaceItemThroughFace(int pIndex, ItemStack pItemStack, @Nullable Direction pDirection) {
        return false;
    }

    public boolean canTakeItemThroughFace(int pIndex, ItemStack pStack, Direction pDirection) {
        return false;
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    @NotNull
    public CompoundTag getUpdateTag(HolderLookup.Provider holderProvider) {
        CompoundTag compound = super.getUpdateTag(holderProvider);
        if (this.ownerID != null) {
            compound.putUUID("owner", this.ownerID);
        }
        if (this.ownerName != null) {
            compound.putString("owner_name", this.ownerName);
        }
        ContainerHelper.saveAllItems((CompoundTag)compound, this.items, (HolderLookup.Provider)holderProvider);
        return compound;
    }

    public void handleUpdateTag(@NotNull CompoundTag compound, HolderLookup.Provider holderProvider) {
        super.handleUpdateTag(compound, holderProvider);
        this.ownerID = compound.hasUUID("owner") ? compound.getUUID("owner") : null;
        this.ownerName = compound.contains("owner_name") ? compound.getString("owner_name") : null;
        ContainerHelper.loadAllItems((CompoundTag)compound, this.items, (HolderLookup.Provider)holderProvider);
    }

    protected int getBurnDuration(ItemStack pFuel) {
        if (pFuel.isEmpty()) {
            return 0;
        }
        return pFuel.getBurnTime(this.recipeType);
    }

    protected void loadAdditional(CompoundTag pTag, HolderLookup.Provider holderProvider) {
        super.loadAdditional(pTag, holderProvider);
        this.ownerID = pTag.hasUUID("owner") ? pTag.getUUID("owner") : null;
        this.ownerName = pTag.contains("owner_name") ? pTag.getString("owner_name") : null;
        this.items = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
        ContainerHelper.loadAllItems((CompoundTag)pTag, this.items, (HolderLookup.Provider)holderProvider);
        this.litTime = pTag.getInt("BurnTime");
        this.cookingProgress = pTag.getInt("CookTime");
        this.cookingTotalTime = pTag.getInt("CookTimeTotal");
        this.litDuration = this.getBurnDuration((ItemStack)this.items.get(1));
        CompoundTag compoundtag = pTag.getCompound("RecipesUsed");
        for (String s : compoundtag.getAllKeys()) {
            this.recipesUsed.put((Object)ResourceLocation.parse((String)s), compoundtag.getInt(s));
        }
    }

    private boolean isLit() {
        return this.litTime > 0;
    }

    public void onDataPacket(@NotNull Connection net, @NotNull ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider holderProvider) {
        CompoundTag nbt = pkt.getTag();
        if (this.hasLevel()) {
            this.handleUpdateTag(nbt, holderProvider);
        }
    }

    public void saveAdditional(@NotNull CompoundTag pTag, HolderLookup.Provider holderProvider) {
        super.saveAdditional(pTag, holderProvider);
        pTag.putInt("BurnTime", this.litTime);
        pTag.putInt("CookTime", this.cookingProgress);
        pTag.putInt("CookTimeTotal", this.cookingTotalTime);
        ContainerHelper.saveAllItems((CompoundTag)pTag, this.items, (HolderLookup.Provider)holderProvider);
        CompoundTag compoundtag = new CompoundTag();
        this.recipesUsed.forEach((p_187449_, p_187450_) -> compoundtag.putInt(p_187449_.toString(), p_187450_.intValue()));
        pTag.put("RecipesUsed", (Tag)compoundtag);
        if (this.ownerID != null) {
            pTag.putUUID("owner", this.ownerID);
        }
        if (this.ownerName != null) {
            pTag.putString("owner_name", this.ownerName);
        }
    }

    public void setChanged() {
        if (this.level != null) {
            super.setChanged();
            BlockState old = this.level.getBlockState(this.worldPosition);
            BlockState state = (BlockState)((BlockState)old.setValue((Property)AbstractFurnaceBlock.LIT, (Comparable)Boolean.valueOf(this.isBurning()))).setValue((Property)AlchemicalCauldronBlock.LIQUID, (Comparable)Integer.valueOf(((ItemStack)this.items.getFirst()).isEmpty() ? 0 : (this.isBurning() ? 2 : 1)));
            if (old.equals(state)) {
                this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 2);
            } else {
                this.level.setBlock(this.worldPosition, state, 3);
            }
        }
    }

    public int getContainerSize() {
        return this.items.size();
    }

    public void setItem(int pIndex, ItemStack pStack) {
        ItemStack itemstack = (ItemStack)this.items.get(pIndex);
        boolean flag = !pStack.isEmpty() && ItemStack.isSameItemSameComponents((ItemStack)itemstack, (ItemStack)pStack);
        this.items.set(pIndex, (Object)pStack);
        pStack.limitSize(this.getMaxStackSize(pStack));
        if (!(pIndex != 0 && pIndex != 1 || flag)) {
            this.cookingTotalTime = AlchemicalCauldronBlockEntity.getTotalCookTime(this.level, this);
            this.cookingProgress = 0;
            this.setChanged();
        }
    }

    public void setOwnerID(@NotNull Player player) {
        this.ownerID = player.getUUID();
        this.ownerName = player.getGameProfile().getName();
        this.setChanged();
    }

    public Optional<ISkillHandler<?>> getPlayerSkillHandler() {
        return Optional.ofNullable(this.level.getPlayerByUUID(this.ownerID)).map(HunterPlayer::get).map(HunterPlayer::getSkillHandler);
    }

    public static void serverTick(@NotNull Level pLevel, BlockPos pPos, BlockState pState, @NotNull AlchemicalCauldronBlockEntity pBlockEntity) {
        boolean flag4;
        boolean flag = pBlockEntity.isLit();
        boolean flag1 = false;
        if (pBlockEntity.isLit()) {
            --pBlockEntity.litTime;
        }
        ItemStack fuel = (ItemStack)pBlockEntity.items.get(3);
        ItemStack ingredient = (ItemStack)pBlockEntity.items.get(1);
        ItemStack fluid = (ItemStack)pBlockEntity.items.get(0);
        boolean flag2 = !ingredient.isEmpty();
        boolean flag3 = !fuel.isEmpty();
        boolean bl = flag4 = !fluid.isEmpty();
        if (pBlockEntity.isLit() || flag3 && flag2 && flag4) {
            RecipeHolder recipeholder = flag2 && flag4 ? (RecipeHolder)pBlockEntity.quickCheck.getRecipeFor((RecipeInput)new AlchemicalCauldronRecipeInput(ingredient, fluid, pBlockEntity.getPlayerSkillHandler()), pLevel).orElse(null) : null;
            int i = pBlockEntity.getMaxStackSize();
            if (!pBlockEntity.isLit() && AlchemicalCauldronBlockEntity.canBurn(pLevel.registryAccess(), recipeholder, pBlockEntity.items, i, pBlockEntity) && pBlockEntity.canPlayerCook((RecipeHolder<AlchemicalCauldronRecipe>)recipeholder)) {
                pBlockEntity.litDuration = pBlockEntity.litTime = pBlockEntity.getBurnDuration(fuel);
                if (pBlockEntity.isLit()) {
                    flag1 = true;
                    if (fuel.hasCraftingRemainingItem()) {
                        pBlockEntity.items.set(3, (Object)fuel.getCraftingRemainingItem());
                    } else if (flag3) {
                        Item item = fuel.getItem();
                        fuel.shrink(1);
                        if (fuel.isEmpty()) {
                            pBlockEntity.items.set(3, (Object)fuel.getCraftingRemainingItem());
                        }
                    }
                }
            }
            if (pBlockEntity.isLit() && AlchemicalCauldronBlockEntity.canBurn(pLevel.registryAccess(), recipeholder, pBlockEntity.items, i, pBlockEntity) && pBlockEntity.canPlayerCook((RecipeHolder<AlchemicalCauldronRecipe>)recipeholder)) {
                ++pBlockEntity.cookingProgress;
                if (pBlockEntity.cookingProgress == pBlockEntity.cookingTotalTime) {
                    pBlockEntity.cookingProgress = 0;
                    pBlockEntity.cookingTotalTime = AlchemicalCauldronBlockEntity.getTotalCookTime(pLevel, pBlockEntity);
                    if (AlchemicalCauldronBlockEntity.burn(pLevel.registryAccess(), recipeholder, pBlockEntity.items, i, pBlockEntity)) {
                        pBlockEntity.setRecipeUsed(recipeholder);
                    }
                    flag1 = true;
                }
            } else {
                pBlockEntity.cookingProgress = 0;
            }
        } else if (!pBlockEntity.isLit() && pBlockEntity.cookingProgress > 0) {
            pBlockEntity.cookingProgress = Mth.clamp((int)(pBlockEntity.cookingProgress - 2), (int)0, (int)pBlockEntity.cookingTotalTime);
        }
        if (flag != pBlockEntity.isLit()) {
            flag1 = true;
            pState = (BlockState)pState.setValue((Property)AbstractFurnaceBlock.LIT, (Comparable)Boolean.valueOf(pBlockEntity.isLit()));
            pLevel.setBlock(pPos, pState, 3);
        }
        if (flag1) {
            AlchemicalCauldronBlockEntity.setChanged((Level)pLevel, (BlockPos)pPos, (BlockState)pState);
        }
    }

    @NotNull
    protected AbstractContainerMenu createMenu(int id, @NotNull Inventory player) {
        return new AlchemicalCauldronMenu(id, player, (Container)this, this.dataAccess);
    }

    @NotNull
    protected Component getDefaultName() {
        return Component.translatable((String)"tile.vampirism.alchemical_cauldron");
    }

    private boolean canPlayerCook(@Nullable RecipeHolder<AlchemicalCauldronRecipe> recipe) {
        if (recipe == null) {
            return false;
        }
        if (this.level == null) {
            return false;
        }
        if (this.recipeChecked == recipe) {
            return true;
        }
        if (this.ownerID == null) {
            return false;
        }
        Player playerEntity = this.level.getPlayerByUUID(this.ownerID);
        if (playerEntity == null || !playerEntity.isAlive()) {
            return false;
        }
        HunterPlayer hunter = HunterPlayer.get(playerEntity);
        boolean canCook = ((AlchemicalCauldronRecipe)recipe.value()).canBeCooked(hunter.getLevel(), hunter.getSkillHandler());
        if (canCook) {
            this.recipeChecked = recipe;
            return true;
        }
        this.recipeChecked = null;
        return false;
    }

    private void finishCooking(RegistryAccess access, @Nullable RecipeHolder<AlchemicalCauldronRecipe> recipe) {
        if (recipe != null && AlchemicalCauldronBlockEntity.canBurn(access, recipe, this.items, this.getMaxStackSize(), this) && this.canPlayerCook(recipe)) {
            ItemStack itemstackfluid = (ItemStack)this.items.get(0);
            ItemStack itemstackingredient = (ItemStack)this.items.get(1);
            ItemStack itemstack1result = ((AlchemicalCauldronRecipe)recipe.value()).getResultItem((HolderLookup.Provider)access);
            ItemStack itemstackoutput = (ItemStack)this.items.get(2);
            if (itemstackoutput.isEmpty()) {
                this.items.set(2, (Object)itemstack1result.copy());
            } else if (itemstackoutput.getItem() == itemstack1result.getItem()) {
                itemstackoutput.grow(itemstack1result.getCount());
            }
            if (this.level != null && !this.level.isClientSide) {
                this.setRecipeUsed(recipe);
            }
            Either<Ingredient, FluidStack> fluid = ((AlchemicalCauldronRecipe)recipe.value()).getFluid();
            fluid.ifLeft(ingredient -> itemstackfluid.shrink(1));
            fluid.ifRight(fluidStack -> this.items.set(0, (Object)FluidUtil.getFluidHandler((ItemStack)itemstackfluid).map(handler -> {
                FluidStack drained = handler.drain(fluidStack, IFluidHandler.FluidAction.EXECUTE);
                if (drained.getAmount() < fluidStack.getAmount()) {
                    handler.drain(new FluidStack(fluidStack.getFluid(), 1000), IFluidHandler.FluidAction.EXECUTE);
                }
                return handler.getContainer();
            }).orElse(ItemStack.EMPTY)));
            itemstackingredient.shrink(1);
            this.recipeChecked = null;
        }
    }

    private static boolean canBurn(RegistryAccess pRegistryAccess, @Nullable RecipeHolder<?> pRecipe, NonNullList<ItemStack> pInventory, int pMaxStackSize, AlchemicalCauldronBlockEntity furnace) {
        if (!((ItemStack)pInventory.get(0)).isEmpty() && pRecipe != null) {
            ItemStack itemstack = ((AlchemicalCauldronRecipe)pRecipe.value()).assemble(new AlchemicalCauldronRecipeInput(furnace.getIngredient(), furnace.getFluid()), (HolderLookup.Provider)pRegistryAccess);
            if (itemstack.isEmpty()) {
                return false;
            }
            ItemStack itemstack1 = (ItemStack)pInventory.get(2);
            if (itemstack1.isEmpty()) {
                return true;
            }
            if (!ItemStack.isSameItemSameComponents((ItemStack)itemstack1, (ItemStack)itemstack)) {
                return false;
            }
            return itemstack1.getCount() + itemstack.getCount() <= pMaxStackSize && itemstack1.getCount() + itemstack.getCount() <= itemstack1.getMaxStackSize() ? true : itemstack1.getCount() + itemstack.getCount() <= itemstack.getMaxStackSize();
        }
        return false;
    }

    private static boolean burn(RegistryAccess pRegistryAccess, @javax.annotation.Nullable RecipeHolder<?> pRecipe, NonNullList<ItemStack> pInventory, int pMaxStackSize, AlchemicalCauldronBlockEntity furnace) {
        if (pRecipe != null && AlchemicalCauldronBlockEntity.canBurn(pRegistryAccess, pRecipe, pInventory, pMaxStackSize, furnace)) {
            ItemStack fluid = (ItemStack)pInventory.get(0);
            ItemStack ingredient = (ItemStack)pInventory.get(1);
            ItemStack newResult = ((AlchemicalCauldronRecipe)pRecipe.value()).assemble(new AlchemicalCauldronRecipeInput(furnace.getIngredient(), furnace.getFluid()), (HolderLookup.Provider)pRegistryAccess);
            ItemStack currentResult = (ItemStack)pInventory.get(2);
            if (currentResult.isEmpty()) {
                pInventory.set(2, (Object)newResult.copy());
            } else if (ItemStack.isSameItemSameComponents((ItemStack)currentResult, (ItemStack)newResult)) {
                currentResult.grow(newResult.getCount());
            }
            fluid.shrink(1);
            ingredient.shrink(1);
            return true;
        }
        return false;
    }

    private static int getTotalCookTime(Level pLevel, AlchemicalCauldronBlockEntity pBlockEntity) {
        AlchemicalCauldronRecipeInput brewingRecipeInput = new AlchemicalCauldronRecipeInput(pBlockEntity.getIngredient(), pBlockEntity.getFluid());
        return pBlockEntity.quickCheck.getRecipeFor((RecipeInput)brewingRecipeInput, pLevel).map(p_300840_ -> ((AlchemicalCauldronRecipe)p_300840_.value()).getCookingTime()).orElse(200);
    }

    private boolean isBurning() {
        return this.dataAccess.get(0) > 0;
    }

    private boolean isCooking() {
        return this.dataAccess.get(2) > 0;
    }

    public void setRecipeUsed(@Nullable RecipeHolder<?> pRecipe) {
        if (pRecipe != null) {
            ResourceLocation resourcelocation = pRecipe.id();
            this.recipesUsed.addTo((Object)resourcelocation, 1);
        }
    }

    @Nullable
    public RecipeHolder<?> getRecipeUsed() {
        return null;
    }

    public void fillStackedContents(StackedContents pContents) {
        for (ItemStack itemstack : this.items) {
            pContents.accountStack(itemstack);
        }
    }
}

