/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.api.entity.player.skills;

import de.teamlapen.vampirism.api.VampirismRegistries;
import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import de.teamlapen.vampirism.api.entity.player.actions.IAction;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Range;

public abstract class DefaultSkill<T extends IFactionPlayer<T>>
implements ISkill<T> {
    private final Map<Holder<Attribute>, AttributeHolder> attributeModifierMap = new HashMap<Holder<Attribute>, AttributeHolder>();
    private final @Range(from=0L, to=9L) int skillPointCost;
    private String translationId;

    public DefaultSkill() {
        this(1);
    }

    public DefaultSkill(@Range(from=0L, to=9L) int skillPointCost) {
        this.skillPointCost = skillPointCost;
    }

    @Override
    public String getTranslationKey() {
        if (this.translationId == null) {
            this.translationId = Util.makeDescriptionId((String)"skill", (ResourceLocation)VampirismRegistries.SKILL.get().getKey((Object)this));
        }
        return this.translationId;
    }

    @Override
    public final void onDisable(@NotNull T player) {
        this.removeAttributesModifiersFromEntity(player.asEntity());
        player.getActionHandler().relockActions(this.getActions());
        if (!this.getFaction().map(f -> f.getFactionPlayerInterface().isInstance(player)).orElse(true).booleanValue()) {
            throw new IllegalArgumentException("Faction player instance is of wrong class " + String.valueOf(player.getClass()) + " instead of " + String.valueOf(this.getFaction().get().getFactionPlayerInterface()));
        }
        this.onDisabled(player);
    }

    @Override
    public final void onEnable(@NotNull T player) {
        this.applyAttributesModifiersToEntity(player.asEntity());
        player.getActionHandler().unlockActions(this.getActions());
        if (!this.getFaction().map(f -> f.getFactionPlayerInterface().isInstance(player)).orElse(true).booleanValue()) {
            throw new IllegalArgumentException("Faction player instance is of wrong class " + String.valueOf(player.getClass()) + " instead of " + String.valueOf(this.getFaction().get().getFactionPlayerInterface()));
        }
        this.onEnabled(player);
    }

    @NotNull
    public DefaultSkill<T> registerAttributeModifier(Holder<Attribute> attribute, double amount, // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull AttributeModifier.Operation operation) {
        this.attributeModifierMap.put(attribute, new AttributeHolder(this, attribute, () -> amount, operation));
        return this;
    }

    @NotNull
    public DefaultSkill<T> registerAttributeModifier(Holder<Attribute> attribute, @NotNull Supplier<Double> amountSupplier, // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull AttributeModifier.Operation operation) {
        this.attributeModifierMap.put(attribute, new AttributeHolder(this, attribute, amountSupplier, operation));
        return this;
    }

    @NotNull
    public String toString() {
        return String.valueOf(this.getRegistryName()) + "(" + this.getClass().getSimpleName() + ")";
    }

    protected void getActions(Collection<IAction<T>> list) {
    }

    protected void onDisabled(T player) {
    }

    protected void onEnabled(T player) {
    }

    private void applyAttributesModifiersToEntity(@NotNull Player player) {
        for (Map.Entry<Holder<Attribute>, AttributeHolder> entry : this.attributeModifierMap.entrySet()) {
            AttributeInstance instance = player.getAttribute(entry.getKey());
            if (instance == null) continue;
            AttributeModifier attributeModifier = entry.getValue().create();
            instance.addOrReplacePermanentModifier(attributeModifier);
        }
    }

    @NotNull
    public Collection<IAction<T>> getActions() {
        ArrayList<IAction<IAction>> collection = new ArrayList<IAction<IAction>>();
        this.getActions(collection);
        collection.forEach(iAction -> {
            if (iAction.getFaction().isPresent() && iAction.getFaction().get() != this.getFaction().orElse(null)) {
                throw new IllegalArgumentException("Can't register action of faction " + (String)iAction.getFaction().map(Object::toString).orElse(null) + " for skill of faction" + this.getFaction().map(Object::toString).orElse("all"));
            }
        });
        return collection;
    }

    private void removeAttributesModifiersFromEntity(@NotNull Player player) {
        for (Map.Entry<Holder<Attribute>, AttributeHolder> entry : this.attributeModifierMap.entrySet()) {
            AttributeInstance attribute = player.getAttribute(entry.getKey());
            if (attribute == null) continue;
            attribute.removeModifier(entry.getValue().getId());
        }
    }

    @Nullable
    private ResourceLocation getRegistryName() {
        return VampirismRegistries.SKILL.get().getKey((Object)this);
    }

    @Override
    public @Range(from=0L, to=9L) int getSkillPointCost() {
        return this.skillPointCost;
    }

    protected static class AttributeHolder {
        public final Holder<Attribute> attribute;
        @NotNull
        public final Supplier<Double> amountSupplier;
        public final // Could not load outer class - annotation placement on inner may be incorrect
        @NotNull AttributeModifier.Operation operation;
        private final ISkill<?> skill;

        private AttributeHolder(ISkill<?> skill, Holder<Attribute> attribute, @NotNull Supplier<Double> amountSupplier, // Could not load outer class - annotation placement on inner may be incorrect
        @NotNull AttributeModifier.Operation operation) {
            this.attribute = attribute;
            this.amountSupplier = amountSupplier;
            this.operation = operation;
            this.skill = skill;
        }

        public ResourceLocation getId() {
            return VampirismRegistries.SKILL.get().getKey(this.skill);
        }

        public AttributeModifier create() {
            return new AttributeModifier(this.getId(), this.amountSupplier.get().doubleValue(), this.operation);
        }
    }
}

