/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.advancements.critereon;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.teamlapen.vampirism.core.ModAdvancements;
import java.util.Optional;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.StringRepresentable;
import org.jetbrains.annotations.NotNull;

public class VampireActionCriterionTrigger
extends SimpleCriterionTrigger<TriggerInstance> {
    public void trigger(@NotNull ServerPlayer player, Action action) {
        this.trigger(player, instance -> instance.matches(action));
    }

    @NotNull
    public Codec<TriggerInstance> codec() {
        return TriggerInstance.CODEC;
    }

    public static enum Action implements StringRepresentable
    {
        SNIPED_IN_BAT("sniped_in_bat"),
        POISONOUS_BITE("poisonous_bite"),
        PERFORM_RITUAL_INFUSION("perform_ritual_infusion"),
        BAT("bat"),
        SUCK_BLOOD("suck_blood"),
        NONE("none"),
        KILL_FROZEN_HUNTER("kill_frozen_hunter"),
        RESURRECT("resurrect");

        private final String name;

        private Action(String name) {
            this.name = name;
        }

        @NotNull
        public String getSerializedName() {
            return this.name;
        }
    }

    public record TriggerInstance(@NotNull Optional<ContextAwarePredicate> player, @NotNull Action action) implements SimpleCriterionTrigger.SimpleInstance
    {
        public static final Codec<TriggerInstance> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("player").forGetter(TriggerInstance::player), (App)StringRepresentable.fromEnum(Action::values).fieldOf("action").forGetter(TriggerInstance::action)).apply((Applicative)inst, TriggerInstance::new));

        @NotNull
        public static Criterion<TriggerInstance> of(@NotNull Action action) {
            return ((VampireActionCriterionTrigger)((Object)ModAdvancements.TRIGGER_VAMPIRE_ACTION.get())).createCriterion((CriterionTriggerInstance)new TriggerInstance(Optional.empty(), action));
        }

        boolean matches(Action action) {
            return this.action == action;
        }
    }
}

