/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.advancements.critereon;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import java.util.Optional;
import net.minecraft.advancements.critereon.EntitySubPredicate;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlayerFactionSubPredicate
implements EntitySubPredicate {
    public static final MapCodec<PlayerFactionSubPredicate> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)IPlayableFaction.CODEC.optionalFieldOf("faction", null).forGetter(p -> p.faction), (App)Codec.INT.optionalFieldOf("level").forGetter(p -> p.level), (App)Codec.INT.optionalFieldOf("lord_level").forGetter(p -> p.lordLevel)).apply((Applicative)inst, PlayerFactionSubPredicate::new));
    @Nullable
    private final IPlayableFaction<?> faction;
    @NotNull
    private final Optional<Integer> level;
    @NotNull
    private final Optional<Integer> lordLevel;

    private PlayerFactionSubPredicate(@Nullable IPlayableFaction<?> faction, @NotNull Optional<Integer> level, @NotNull Optional<Integer> lordLevel) {
        this.faction = faction;
        this.level = level;
        this.lordLevel = lordLevel;
    }

    public static PlayerFactionSubPredicate faction(@NotNull IPlayableFaction<?> faction) {
        return new PlayerFactionSubPredicate(faction, Optional.empty(), Optional.empty());
    }

    public static PlayerFactionSubPredicate level(@NotNull IPlayableFaction<?> faction, int level) {
        return new PlayerFactionSubPredicate(faction, Optional.of(level), Optional.empty());
    }

    public static PlayerFactionSubPredicate lord(@NotNull IPlayableFaction<?> faction, int lordLevel) {
        return new PlayerFactionSubPredicate(faction, Optional.empty(), Optional.of(lordLevel));
    }

    public static PlayerFactionSubPredicate lord(int lordLevel) {
        return new PlayerFactionSubPredicate(null, Optional.empty(), Optional.of(lordLevel));
    }

    public static PlayerFactionSubPredicate lord(@NotNull IPlayableFaction<?> faction) {
        return new PlayerFactionSubPredicate(faction, Optional.empty(), Optional.of(1));
    }

    public static PlayerFactionSubPredicate level(int level) {
        return new PlayerFactionSubPredicate(null, Optional.of(level), Optional.empty());
    }

    public boolean matches(@NotNull Entity pEntity, @NotNull ServerLevel pLevel, @Nullable Vec3 p_218830_) {
        if (pEntity instanceof Player) {
            Player player = (Player)pEntity;
            FactionPlayerHandler fph = FactionPlayerHandler.get(player);
            return !(this.faction != null && fph.getCurrentFaction() != this.faction || !this.level.isEmpty() && fph.getCurrentLevel() < this.level.get() || !this.lordLevel.isEmpty() && fph.getLordLevel() < this.lordLevel.get());
        }
        return false;
    }

    @NotNull
    public MapCodec<? extends EntitySubPredicate> codec() {
        return CODEC;
    }
}

