/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism;

import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import de.teamlapen.lib.HelperRegistry;
import de.teamlapen.lib.lib.entity.IPlayerEventListener;
import de.teamlapen.lib.lib.storage.IAttachedSyncable;
import de.teamlapen.lib.lib.util.IInitListener;
import de.teamlapen.lib.util.Color;
import de.teamlapen.vampirism.GeneralEventHandler;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.VampirismRegistries;
import de.teamlapen.vampirism.api.entity.player.hunter.IHunterPlayer;
import de.teamlapen.vampirism.api.entity.player.vampire.IVampirePlayer;
import de.teamlapen.vampirism.api.util.VResourceLocation;
import de.teamlapen.vampirism.blockentity.PotionTableBlockEntity;
import de.teamlapen.vampirism.client.VampirismModClient;
import de.teamlapen.vampirism.client.renderer.VampirismClientEntityRegistry;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.core.ModAttachments;
import de.teamlapen.vampirism.core.ModEntities;
import de.teamlapen.vampirism.core.ModEntitySelectors;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.core.ModStats;
import de.teamlapen.vampirism.core.ModTags;
import de.teamlapen.vampirism.core.ModTiles;
import de.teamlapen.vampirism.core.ModVillage;
import de.teamlapen.vampirism.core.RegistryManager;
import de.teamlapen.vampirism.data.reloadlistener.SingleJigsawReloadListener;
import de.teamlapen.vampirism.data.reloadlistener.SkillTreeReloadListener;
import de.teamlapen.vampirism.data.reloadlistener.SundamageReloadListener;
import de.teamlapen.vampirism.entity.ExtendedCreature;
import de.teamlapen.vampirism.entity.ModEntityEventHandler;
import de.teamlapen.vampirism.entity.SundamageRegistry;
import de.teamlapen.vampirism.entity.action.ActionManagerEntity;
import de.teamlapen.vampirism.entity.converted.VampirismEntityRegistry;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.entity.factions.FactionRegistry;
import de.teamlapen.vampirism.entity.minion.HunterMinionEntity;
import de.teamlapen.vampirism.entity.minion.VampireMinionEntity;
import de.teamlapen.vampirism.entity.minion.management.MinionData;
import de.teamlapen.vampirism.entity.player.ModPlayerEventHandler;
import de.teamlapen.vampirism.entity.player.actions.ActionManager;
import de.teamlapen.vampirism.entity.player.hunter.HunterPlayer;
import de.teamlapen.vampirism.entity.player.skills.SkillManager;
import de.teamlapen.vampirism.entity.player.vampire.BloodVision;
import de.teamlapen.vampirism.entity.player.vampire.NightVision;
import de.teamlapen.vampirism.entity.player.vampire.VampirePlayer;
import de.teamlapen.vampirism.items.BloodBottleFluidHandler;
import de.teamlapen.vampirism.items.VampireRefinementItem;
import de.teamlapen.vampirism.items.crossbow.CrossbowArrowHandler;
import de.teamlapen.vampirism.misc.SettingsProvider;
import de.teamlapen.vampirism.misc.VampirismLogger;
import de.teamlapen.vampirism.mixin.accessor.ReloadableServerResourcesAccessor;
import de.teamlapen.vampirism.mixin.accessor.TagManagerAccessor;
import de.teamlapen.vampirism.modcompat.IMCHandler;
import de.teamlapen.vampirism.modcompat.TerraBlenderCompat;
import de.teamlapen.vampirism.network.ModPacketDispatcher;
import de.teamlapen.vampirism.proxy.IProxy;
import de.teamlapen.vampirism.proxy.ServerProxy;
import de.teamlapen.vampirism.recipes.ExtendedBrewingRecipeRegistry;
import de.teamlapen.vampirism.sit.SitHandler;
import de.teamlapen.vampirism.util.CodecModifications;
import de.teamlapen.vampirism.util.HunterVillage;
import de.teamlapen.vampirism.util.LordTitles;
import de.teamlapen.vampirism.util.MigrationData;
import de.teamlapen.vampirism.util.Permissions;
import de.teamlapen.vampirism.util.SupporterManager;
import de.teamlapen.vampirism.util.TelemetryCollector;
import de.teamlapen.vampirism.util.VampireBookManager;
import de.teamlapen.vampirism.util.VampireVillage;
import de.teamlapen.vampirism.util.VampireVisionRegistry;
import de.teamlapen.vampirism.util.VersionUpdater;
import de.teamlapen.vampirism.world.BloodConversionRegistry;
import de.teamlapen.vampirism.world.biome.OverworldModifications;
import de.teamlapen.vampirism.world.gen.VanillaStructureModifications;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Direction;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.ShapedRecipePattern;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.neoforged.fml.event.lifecycle.InterModEnqueueEvent;
import net.neoforged.fml.event.lifecycle.InterModProcessEvent;
import net.neoforged.fml.event.lifecycle.ParallelDispatchEvent;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.ICapabilityProvider;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.AddReloadListenerEvent;
import net.neoforged.neoforge.event.OnDatapackSyncEvent;
import net.neoforged.neoforge.event.server.ServerAboutToStartEvent;
import net.neoforged.neoforge.event.server.ServerStoppedEvent;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.wrapper.InvWrapper;
import net.neoforged.neoforge.registries.NewRegistryEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Mod(value="vampirism")
public class VampirismMod {
    public static VampirismMod instance;
    public static final IProxy proxy;
    public static boolean inDev;
    public static boolean inDataGen;
    @NotNull
    private final RegistryManager registryManager;
    private final IEventBus modBus;
    private final ModContainer modContainer;

    public VampirismMod(IEventBus modEventBus, ModContainer modContainer) {
        instance = this;
        this.checkEnv();
        this.modBus = modEventBus;
        this.modContainer = modContainer;
        this.registryManager = new RegistryManager(modEventBus);
        this.modBus.addListener(this::setup);
        this.modBus.addListener(this::enqueueIMC);
        this.modBus.addListener(this::processIMC);
        this.modBus.addListener(this::loadComplete);
        this.modBus.addListener(this::registerCapabilities);
        this.modBus.addListener(this::finalizeConfiguration);
        this.modBus.addListener(VersionUpdater::catchModVersionMismatch);
        this.modBus.register(ModPacketDispatcher.class);
        this.modBus.register(MigrationData.class);
        NeoForge.EVENT_BUS.register(Permissions.class);
        NeoForge.EVENT_BUS.register(SitHandler.class);
        NeoForge.EVENT_BUS.register((Object)new GeneralEventHandler());
        NeoForge.EVENT_BUS.addListener(this::onAddReloadListenerEvent);
        NeoForge.EVENT_BUS.addListener(this::onServerStarting);
        NeoForge.EVENT_BUS.addListener(VersionUpdater::checkVersionUpdated);
        NeoForge.EVENT_BUS.addListener(this::onServerStopped);
        NeoForge.EVENT_BUS.addListener(this::onDataPackSyncEvent);
        ShapedRecipePattern.setCraftingSize((int)4, (int)4);
        this.prepareAPI();
        this.registryManager.setupRegistries();
        this.registryManager.registerModEventHandler();
        this.registryManager.registerForgeEventHandler();
    }

    public void onAddReloadListenerEvent(@NotNull AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)new SingleJigsawReloadListener());
        event.addListener((PreparableReloadListener)new SundamageReloadListener(((TagManagerAccessor)((ReloadableServerResourcesAccessor)event.getServerResources()).getTagManager()).getRegistryAccess()));
        event.addListener((PreparableReloadListener)new SkillTreeReloadListener());
    }

    private void checkEnv() {
        String launchTarget = System.getProperty("vampirism_target");
        if (launchTarget != null && launchTarget.contains("dev")) {
            inDev = true;
        }
        if (launchTarget != null && launchTarget.contains("data")) {
            inDataGen = true;
        }
    }

    private void enqueueIMC(@NotNull InterModEnqueueEvent event) {
        this.onInitStep(IInitListener.Step.ENQUEUE_IMC, (ParallelDispatchEvent)event);
        HelperRegistry.registerPlayerEventReceivingCapability((AttachmentType<IPlayerEventListener>)((AttachmentType)ModAttachments.VAMPIRE_PLAYER.get()), VampirePlayer.class);
        HelperRegistry.registerPlayerEventReceivingCapability((AttachmentType<IPlayerEventListener>)((AttachmentType)ModAttachments.HUNTER_PLAYER.get()), HunterPlayer.class);
        HelperRegistry.registerSyncableEntityCapability((AttachmentType<IAttachedSyncable>)((AttachmentType)ModAttachments.EXTENDED_CREATURE.get()), ExtendedCreature.class);
        HelperRegistry.registerSyncablePlayerCapability((AttachmentType<IAttachedSyncable>)((AttachmentType)ModAttachments.VAMPIRE_PLAYER.get()), VampirePlayer.class);
        HelperRegistry.registerSyncablePlayerCapability((AttachmentType<IAttachedSyncable>)((AttachmentType)ModAttachments.HUNTER_PLAYER.get()), HunterPlayer.class);
        HelperRegistry.registerSyncablePlayerCapability((AttachmentType<IAttachedSyncable>)((AttachmentType)ModAttachments.FACTION_PLAYER_HANDLER.get()), FactionPlayerHandler.class);
    }

    private void registerCapabilities(@NotNull RegisterCapabilitiesEvent event) {
        event.registerItem(Capabilities.FluidHandler.ITEM, (item, b) -> new BloodBottleFluidHandler((ItemStack)item, 900), new ItemLike[]{(ItemLike)ModItems.BLOOD_BOTTLE.get()});
        event.registerBlockEntity(Capabilities.FluidHandler.BLOCK, (BlockEntityType)ModTiles.BLOOD_CONTAINER.get(), (o, side) -> o.getTank());
        event.registerBlockEntity(Capabilities.FluidHandler.BLOCK, (BlockEntityType)ModTiles.ALTAR_INSPIRATION.get(), (o, side) -> o.getTank());
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)ModTiles.GRINDER.get(), (o, side) -> o.getItemHandler());
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)ModTiles.BLOOD_PEDESTAL.get(), (o, side) -> o);
        event.registerBlockEntity(Capabilities.FluidHandler.BLOCK, (BlockEntityType)ModTiles.SIEVE.get(), (o, side) -> o.getTank());
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)ModTiles.POTION_TABLE.get(), (ICapabilityProvider)new ICapabilityProvider<PotionTableBlockEntity, Direction, IItemHandler>(this){

            @Nullable
            public IItemHandler getCapability(@NotNull PotionTableBlockEntity object, @NotNull Direction context) {
                return object.getCapability(object, context);
            }
        });
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)ModTiles.ALTAR_INFUSION.get(), (o, side) -> new InvWrapper((Container)o));
    }

    private void onServerStarting(@NotNull ServerAboutToStartEvent event) {
        VanillaStructureModifications.addVillageStructures((RegistryAccess)event.getServer().registryAccess());
        ((SundamageRegistry)VampirismAPI.sundamageRegistry()).initServer((RegistryAccess)event.getServer().registryAccess());
    }

    private void onServerStopped(ServerStoppedEvent event) {
        ((SundamageRegistry)VampirismAPI.sundamageRegistry()).removeServer();
    }

    private void onDataPackSyncEvent(OnDatapackSyncEvent event) {
        if (event.getPlayer() != null) {
            ((SundamageRegistry)VampirismAPI.sundamageRegistry()).updateClient(event.getPlayer());
        } else {
            event.getPlayerList().getPlayers().forEach(player -> ((SundamageRegistry)VampirismAPI.sundamageRegistry()).updateClient((ServerPlayer)player));
        }
    }

    private void finalizeConfiguration(NewRegistryEvent event) {
        VampirismConfig.buildBalanceConfig();
        VampirismConfig.register(this.modContainer);
    }

    private void finishAPI() {
        ((FactionRegistry)VampirismAPI.factionRegistry()).finish();
    }

    private void loadComplete(@NotNull FMLLoadCompleteEvent event) {
        this.onInitStep(IInitListener.Step.LOAD_COMPLETE, (ParallelDispatchEvent)event);
        event.enqueueWork(OverworldModifications::addBiomesToOverworldUnsafe);
        if (FMLEnvironment.dist == Dist.DEDICATED_SERVER) {
            VampirismLogger.init();
        }
    }

    private void prepareAPI() {
        VampirismAPI.setUpRegistries(new FactionRegistry(), new SundamageRegistry(), FMLEnvironment.dist == Dist.CLIENT ? new VampirismClientEntityRegistry() : new VampirismEntityRegistry(), new ActionManager(), new SkillManager(), new VampireVisionRegistry(), new ActionManagerEntity(), new ExtendedBrewingRecipeRegistry(), new SettingsProvider("https://api.vampirism.dev/api/v1"), new BloodConversionRegistry());
        VReference.VAMPIRE_FACTION = VampirismAPI.factionRegistry().createPlayableFaction(VReference.VAMPIRE_FACTION_ID, IVampirePlayer.class, () -> (AttachmentType)ModAttachments.VAMPIRE_PLAYER.get()).color(Color.MAGENTA_DARK.getRGB()).chatColor(ChatFormatting.DARK_PURPLE).name("text.vampirism.vampire").namePlural("text.vampirism.vampires").hostileTowardsNeutral().highestLevel(14).lord().lordLevel(5).lordTitle(LordTitles::getVampireTitle).enableLordSkills().minion(VampireMinionEntity.VampireMinionData.ID, VampireMinionEntity.VampireMinionData::new).commandBuilder(() -> ModEntities.VAMPIRE_MINION.get()).with("name", "Vampire", StringArgumentType.string(), MinionData::setName, StringArgumentType::getString).with("texture", -1, IntegerArgumentType.integer((int)-1, (int)126), VampireMinionEntity.VampireMinionData::setType, IntegerArgumentType::getInteger).with("use_lord_skin", false, BoolArgumentType.bool(), VampireMinionEntity.VampireMinionData::setUseLordSkin, BoolArgumentType::getBool).build().build().build().village(VampireVillage::vampireVillage).refinementItems(VampireRefinementItem::getItemForType).addTag(Registries.BIOME, (TagKey)ModTags.Biomes.IS_VAMPIRE_BIOME).addTag(Registries.POINT_OF_INTEREST_TYPE, (TagKey)ModTags.PoiTypes.IS_VAMPIRE).addTag(Registries.VILLAGER_PROFESSION, (TagKey)ModTags.Professions.IS_VAMPIRE).addTag(Registries.ENTITY_TYPE, (TagKey)ModTags.Entities.VAMPIRE).addTag((ResourceKey)VampirismRegistries.Keys.TASK, (TagKey)ModTags.Tasks.IS_VAMPIRE).register();
        VReference.HUNTER_FACTION = VampirismAPI.factionRegistry().createPlayableFaction(VReference.HUNTER_FACTION_ID, IHunterPlayer.class, () -> (AttachmentType)ModAttachments.HUNTER_PLAYER.get()).color(Color.BLUE.getRGB()).chatColor(ChatFormatting.BLUE).name("text.vampirism.hunter").namePlural("text.vampirism.hunters").highestLevel(14).lord().lordLevel(5).lordTitle(LordTitles::getHunterTitle).enableLordSkills().minion(HunterMinionEntity.HunterMinionData.ID, HunterMinionEntity.HunterMinionData::new).commandBuilder(() -> ModEntities.HUNTER_MINION.get()).with("name", "Hunter", StringArgumentType.string(), MinionData::setName, StringArgumentType::getString).with("texture", -1, IntegerArgumentType.integer((int)-1, (int)126), HunterMinionEntity.HunterMinionData::setType, IntegerArgumentType::getInteger).with("hat", 0, IntegerArgumentType.integer((int)-1, (int)3), HunterMinionEntity.HunterMinionData::setHat, IntegerArgumentType::getInteger).with("use_lord_skin", false, BoolArgumentType.bool(), HunterMinionEntity.HunterMinionData::setUseLordSkin, BoolArgumentType::getBool).build().build().build().village(HunterVillage::hunterVillage).addTag(Registries.BIOME, (TagKey)ModTags.Biomes.IS_HUNTER_BIOME).addTag(Registries.POINT_OF_INTEREST_TYPE, (TagKey)ModTags.PoiTypes.IS_HUNTER).addTag(Registries.VILLAGER_PROFESSION, (TagKey)ModTags.Professions.IS_HUNTER).addTag(Registries.ENTITY_TYPE, (TagKey)ModTags.Entities.HUNTER).addTag((ResourceKey)VampirismRegistries.Keys.TASK, (TagKey)ModTags.Tasks.IS_HUNTER).register();
        VReference.vision_nightVision = VampirismAPI.vampireVisionRegistry().registerVision(VResourceLocation.mod("night_vision"), new NightVision());
        VReference.vision_bloodVision = VampirismAPI.vampireVisionRegistry().registerVision(VResourceLocation.mod("blood_vision"), new BloodVision());
        VampirismAPI.onSetupComplete();
    }

    private void processIMC(@NotNull InterModProcessEvent event) {
        this.finishAPI();
        this.onInitStep(IInitListener.Step.PROCESS_IMC, (ParallelDispatchEvent)event);
        IMCHandler.handleInterModMessage(event);
        CrossbowArrowHandler.collectCrossbowArrows();
    }

    private void setup(@NotNull FMLCommonSetupEvent event) {
        this.onInitStep(IInitListener.Step.COMMON_SETUP, (ParallelDispatchEvent)event);
        NeoForge.EVENT_BUS.register((Object)new ModPlayerEventHandler());
        NeoForge.EVENT_BUS.register((Object)new ModEntityEventHandler());
        SupporterManager.init();
        VampireBookManager.getInstance().init();
        ModEntitySelectors.registerSelectors();
        event.enqueueWork(TerraBlenderCompat::registerBiomeProviderIfPresentUnsafe);
        event.enqueueWork(ModStats::registerFormatter);
        event.enqueueWork(CodecModifications::changeMobEffectCodec);
        event.enqueueWork(ModVillage::villagerTradeSetup);
        event.enqueueWork(ModItems::registerDispenserBehaviourUnsafe);
        TelemetryCollector.execute();
    }

    private void onInitStep( @NotNull IInitListener.Step step, @NotNull ParallelDispatchEvent event) {
        proxy.onInitStep(step, event);
    }

    static {
        proxy = FMLEnvironment.dist == Dist.CLIENT ? VampirismModClient.getProxy() : new ServerProxy();
        inDev = false;
        inDataGen = false;
    }
}

